/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.OperatorNotFoundException;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.predicate.DiscreteValues;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Marker;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.Ranges;
import io.prestosql.spi.predicate.SortedRangeSet;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.predicate.Utils;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.InterpretedFunctionInvoker;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.DeterminismEvaluator;
import io.prestosql.sql.planner.ExpressionInterpreter;
import io.prestosql.sql.planner.LiteralEncoder;
import io.prestosql.sql.planner.NoOpSymbolResolver;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.BetweenPredicate;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.InListExpression;
import io.prestosql.sql.tree.InPredicate;
import io.prestosql.sql.tree.IsNotNullPredicate;
import io.prestosql.sql.tree.IsNullPredicate;
import io.prestosql.sql.tree.LikePredicate;
import io.prestosql.sql.tree.LogicalBinaryExpression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.NotExpression;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.type.LikeFunctions;
import io.prestosql.type.TypeCoercion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class DomainTranslator {
    private final Metadata metadata;
    private final LiteralEncoder literalEncoder;

    public DomainTranslator(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.literalEncoder = new LiteralEncoder(metadata);
    }

    public Expression toPredicate(TupleDomain<Symbol> tupleDomain) {
        if (tupleDomain.isNone()) {
            return BooleanLiteral.FALSE_LITERAL;
        }
        Map domains = (Map)tupleDomain.getDomains().get();
        return domains.entrySet().stream().map(entry -> this.toPredicate((Domain)entry.getValue(), ((Symbol)entry.getKey()).toSymbolReference())).collect(Collectors.collectingAndThen(ImmutableList.toImmutableList(), expressions -> ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)expressions)));
    }

    private Expression toPredicate(Domain domain, SymbolReference reference) {
        if (domain.getValues().isNone()) {
            return domain.isNullAllowed() ? new IsNullPredicate((Expression)reference) : BooleanLiteral.FALSE_LITERAL;
        }
        if (domain.getValues().isAll()) {
            return domain.isNullAllowed() ? BooleanLiteral.TRUE_LITERAL : new NotExpression((Expression)new IsNullPredicate((Expression)reference));
        }
        ArrayList<Expression> disjuncts = new ArrayList<Expression>();
        disjuncts.addAll((Collection)domain.getValues().getValuesProcessor().transform(ranges -> this.extractDisjuncts(domain.getType(), (Ranges)ranges, reference), discreteValues -> this.extractDisjuncts(domain.getType(), (DiscreteValues)discreteValues, reference), allOrNone -> {
            throw new IllegalStateException("Case should not be reachable");
        }));
        if (domain.isNullAllowed()) {
            disjuncts.add((Expression)new IsNullPredicate((Expression)reference));
        }
        return ExpressionUtils.combineDisjunctsWithDefault(this.metadata, disjuncts, (Expression)BooleanLiteral.TRUE_LITERAL);
    }

    private Expression processRange(Type type, Range range, SymbolReference reference) {
        if (range.isAll()) {
            return BooleanLiteral.TRUE_LITERAL;
        }
        if (DomainTranslator.isBetween(range)) {
            return new BetweenPredicate((Expression)reference, this.literalEncoder.toExpression(range.getLow().getValue(), type), this.literalEncoder.toExpression(range.getHigh().getValue(), type));
        }
        ArrayList<Expression> rangeConjuncts = new ArrayList<Expression>();
        if (!range.getLow().isLowerUnbounded()) {
            switch (range.getLow().getBound()) {
                case ABOVE: {
                    rangeConjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)reference, this.literalEncoder.toExpression(range.getLow().getValue(), type)));
                    break;
                }
                case EXACTLY: {
                    rangeConjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)reference, this.literalEncoder.toExpression(range.getLow().getValue(), type)));
                    break;
                }
                case BELOW: {
                    throw new IllegalStateException("Low Marker should never use BELOW bound: " + range);
                }
                default: {
                    throw new AssertionError((Object)("Unhandled bound: " + range.getLow().getBound()));
                }
            }
        }
        if (!range.getHigh().isUpperUnbounded()) {
            switch (range.getHigh().getBound()) {
                case ABOVE: {
                    throw new IllegalStateException("High Marker should never use ABOVE bound: " + range);
                }
                case EXACTLY: {
                    rangeConjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)reference, this.literalEncoder.toExpression(range.getHigh().getValue(), type)));
                    break;
                }
                case BELOW: {
                    rangeConjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)reference, this.literalEncoder.toExpression(range.getHigh().getValue(), type)));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unhandled bound: " + range.getHigh().getBound()));
                }
            }
        }
        Preconditions.checkState((!rangeConjuncts.isEmpty() ? 1 : 0) != 0);
        return ExpressionUtils.combineConjuncts(this.metadata, rangeConjuncts);
    }

    private Expression combineRangeWithExcludedPoints(Type type, SymbolReference reference, Range range, List<Expression> excludedPoints) {
        if (excludedPoints.isEmpty()) {
            return this.processRange(type, range, reference);
        }
        NotExpression excludedPointsExpression = new NotExpression((Expression)new InPredicate((Expression)reference, (Expression)new InListExpression(excludedPoints)));
        if (excludedPoints.size() == 1) {
            excludedPointsExpression = new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)reference, (Expression)Iterables.getOnlyElement(excludedPoints));
        }
        return ExpressionUtils.combineConjuncts(this.metadata, new Expression[]{this.processRange(type, range, reference), excludedPointsExpression});
    }

    private List<Expression> extractDisjuncts(Type type, Ranges ranges, SymbolReference reference) {
        ArrayList<Expression> disjuncts = new ArrayList<Expression>();
        ArrayList<Expression> singleValues = new ArrayList<Expression>();
        List orderedRanges = ranges.getOrderedRanges();
        SortedRangeSet sortedRangeSet = SortedRangeSet.copyOf((Type)type, (List)orderedRanges);
        SortedRangeSet complement = sortedRangeSet.complement();
        List singleValueExclusionsList = complement.getOrderedRanges().stream().filter(Range::isSingleValue).collect(Collectors.toList());
        List originalUnionSingleValues = SortedRangeSet.copyOf((Type)type, singleValueExclusionsList).union((ValueSet)sortedRangeSet).getOrderedRanges();
        PeekingIterator singleValueExclusions = Iterators.peekingIterator(singleValueExclusionsList.iterator());
        if (type instanceof RealType || type instanceof DoubleType) {
            boolean originalRangeIsAll = orderedRanges.stream().anyMatch(Range::isAll);
            boolean coalescedRangeIsAll = originalUnionSingleValues.stream().anyMatch(Range::isAll);
            if (!originalRangeIsAll && coalescedRangeIsAll) {
                for (Range range : orderedRanges) {
                    disjuncts.add(this.processRange(type, range, reference));
                }
                return disjuncts;
            }
        }
        for (Range range : originalUnionSingleValues) {
            if (range.isSingleValue()) {
                singleValues.add(this.literalEncoder.toExpression(range.getSingleValue(), type));
                continue;
            }
            ArrayList<Expression> singleValuesInRange = new ArrayList<Expression>();
            while (singleValueExclusions.hasNext() && range.contains((Range)singleValueExclusions.peek())) {
                singleValuesInRange.add(this.literalEncoder.toExpression(((Range)singleValueExclusions.next()).getSingleValue(), type));
            }
            if (!singleValuesInRange.isEmpty()) {
                disjuncts.add(this.combineRangeWithExcludedPoints(type, reference, range, singleValuesInRange));
                continue;
            }
            disjuncts.add(this.processRange(type, range, reference));
        }
        if (singleValues.size() == 1) {
            disjuncts.add((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)reference, (Expression)Iterables.getOnlyElement(singleValues)));
        } else if (singleValues.size() > 1) {
            disjuncts.add((Expression)new InPredicate((Expression)reference, (Expression)new InListExpression(singleValues)));
        }
        return disjuncts;
    }

    private List<Expression> extractDisjuncts(Type type, DiscreteValues discreteValues, SymbolReference reference) {
        List values = discreteValues.getValues().stream().map(object -> this.literalEncoder.toExpression(object, type)).collect(Collectors.toList());
        Preconditions.checkState((!values.isEmpty() ? 1 : 0) != 0);
        Object predicate = values.size() == 1 ? new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)reference, (Expression)Iterables.getOnlyElement(values)) : new InPredicate((Expression)reference, (Expression)new InListExpression(values));
        if (!discreteValues.isWhiteList()) {
            predicate = new NotExpression((Expression)predicate);
        }
        return ImmutableList.of((Object)predicate);
    }

    private static boolean isBetween(Range range) {
        return !range.getLow().isLowerUnbounded() && range.getLow().getBound() == Marker.Bound.EXACTLY && !range.getHigh().isUpperUnbounded() && range.getHigh().getBound() == Marker.Bound.EXACTLY;
    }

    public static ExtractionResult fromPredicate(Metadata metadata, Session session, Expression predicate, TypeProvider types) {
        return (ExtractionResult)new Visitor(metadata, session, types, new TypeAnalyzer(new SqlParser(), metadata)).process((Node)predicate, false);
    }

    public static class ExtractionResult {
        private final TupleDomain<Symbol> tupleDomain;
        private final Expression remainingExpression;

        public ExtractionResult(TupleDomain<Symbol> tupleDomain, Expression remainingExpression) {
            this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
            this.remainingExpression = Objects.requireNonNull(remainingExpression, "remainingExpression is null");
        }

        public TupleDomain<Symbol> getTupleDomain() {
            return this.tupleDomain;
        }

        public Expression getRemainingExpression() {
            return this.remainingExpression;
        }
    }

    private static class NormalizedSimpleComparison {
        private final Expression symbolExpression;
        private final ComparisonExpression.Operator comparisonOperator;
        private final NullableValue value;

        public NormalizedSimpleComparison(Expression symbolExpression, ComparisonExpression.Operator comparisonOperator, NullableValue value) {
            this.symbolExpression = Objects.requireNonNull(symbolExpression, "nameReference is null");
            this.comparisonOperator = Objects.requireNonNull(comparisonOperator, "comparisonOperator is null");
            this.value = Objects.requireNonNull(value, "value is null");
        }

        public Expression getSymbolExpression() {
            return this.symbolExpression;
        }

        public ComparisonExpression.Operator getComparisonOperator() {
            return this.comparisonOperator;
        }

        public NullableValue getValue() {
            return this.value;
        }
    }

    private static class Visitor
    extends AstVisitor<ExtractionResult, Boolean> {
        private final Metadata metadata;
        private final LiteralEncoder literalEncoder;
        private final Session session;
        private final TypeProvider types;
        private final InterpretedFunctionInvoker functionInvoker;
        private final TypeAnalyzer typeAnalyzer;
        private final TypeCoercion typeCoercion;

        private Visitor(Metadata metadata, Session session, TypeProvider types, TypeAnalyzer typeAnalyzer) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.literalEncoder = new LiteralEncoder(metadata);
            this.session = Objects.requireNonNull(session, "session is null");
            this.types = Objects.requireNonNull(types, "types is null");
            this.functionInvoker = new InterpretedFunctionInvoker(metadata);
            this.typeAnalyzer = Objects.requireNonNull(typeAnalyzer, "typeAnalyzer is null");
            this.typeCoercion = new TypeCoercion(metadata::getType);
        }

        private Type checkedTypeLookup(Symbol symbol) {
            Type type = this.types.get(symbol);
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Types is missing info for symbol: %s", (Object)symbol);
            return type;
        }

        private static ValueSet complementIfNecessary(ValueSet valueSet, boolean complement) {
            return complement ? valueSet.complement() : valueSet;
        }

        private static Domain complementIfNecessary(Domain domain, boolean complement) {
            return complement ? domain.complement() : domain;
        }

        private static Expression complementIfNecessary(Expression expression, boolean complement) {
            return complement ? new NotExpression(expression) : expression;
        }

        protected ExtractionResult visitExpression(Expression node, Boolean complement) {
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.all(), Visitor.complementIfNecessary(node, (boolean)complement));
        }

        protected ExtractionResult visitLogicalBinaryExpression(LogicalBinaryExpression node, Boolean complement) {
            ExtractionResult leftResult = (ExtractionResult)this.process((Node)node.getLeft(), complement);
            ExtractionResult rightResult = (ExtractionResult)this.process((Node)node.getRight(), complement);
            TupleDomain<Symbol> leftTupleDomain = leftResult.getTupleDomain();
            TupleDomain<Symbol> rightTupleDomain = rightResult.getTupleDomain();
            LogicalBinaryExpression.Operator operator = complement != false ? node.getOperator().flip() : node.getOperator();
            switch (operator) {
                case AND: {
                    return new ExtractionResult((TupleDomain<Symbol>)leftTupleDomain.intersect(rightTupleDomain), ExpressionUtils.combineConjuncts(this.metadata, leftResult.getRemainingExpression(), rightResult.getRemainingExpression()));
                }
                case OR: {
                    TupleDomain columnUnionedTupleDomain = TupleDomain.columnWiseUnion(leftTupleDomain, rightTupleDomain, (TupleDomain[])new TupleDomain[0]);
                    Expression remainingExpression = Visitor.complementIfNecessary((Expression)node, (boolean)complement);
                    if (leftResult.getRemainingExpression().equals((Object)rightResult.getRemainingExpression()) && DeterminismEvaluator.isDeterministic(leftResult.getRemainingExpression(), this.metadata)) {
                        boolean oneSideIsSuperSet;
                        boolean matchingSingleSymbolDomains = !leftTupleDomain.isNone() && !rightTupleDomain.isNone() && ((Map)leftTupleDomain.getDomains().get()).size() == 1 && ((Map)rightTupleDomain.getDomains().get()).size() == 1 && ((Map)leftTupleDomain.getDomains().get()).keySet().equals(((Map)rightTupleDomain.getDomains().get()).keySet());
                        boolean bl = oneSideIsSuperSet = leftTupleDomain.contains(rightTupleDomain) || rightTupleDomain.contains(leftTupleDomain);
                        if (oneSideIsSuperSet) {
                            remainingExpression = leftResult.getRemainingExpression();
                        } else if (matchingSingleSymbolDomains) {
                            boolean implicitlyAddedNaN;
                            Domain leftDomain = (Domain)Iterables.getOnlyElement(((Map)leftTupleDomain.getDomains().get()).values());
                            Domain rightDomain = (Domain)Iterables.getOnlyElement(((Map)rightTupleDomain.getDomains().get()).values());
                            Type type = leftDomain.getType();
                            boolean unionedDomainContainsNaN = columnUnionedTupleDomain.isAll() || columnUnionedTupleDomain.getDomains().isPresent() && ((Domain)Iterables.getOnlyElement(((Map)columnUnionedTupleDomain.getDomains().get()).values())).getValues().isAll();
                            boolean bl2 = implicitlyAddedNaN = (type instanceof RealType || type instanceof DoubleType) && !leftDomain.getValues().isAll() && !rightDomain.getValues().isAll() && unionedDomainContainsNaN;
                            if (!implicitlyAddedNaN) {
                                remainingExpression = leftResult.getRemainingExpression();
                            }
                        }
                    }
                    return new ExtractionResult((TupleDomain<Symbol>)columnUnionedTupleDomain, remainingExpression);
                }
            }
            throw new AssertionError((Object)("Unknown operator: " + node.getOperator()));
        }

        protected ExtractionResult visitNotExpression(NotExpression node, Boolean complement) {
            return (ExtractionResult)this.process((Node)node.getValue(), complement == false);
        }

        protected ExtractionResult visitComparisonExpression(ComparisonExpression node, Boolean complement) {
            Optional<NormalizedSimpleComparison> optionalNormalized = this.toNormalizedSimpleComparison(node);
            if (optionalNormalized.isEmpty()) {
                return (ExtractionResult)super.visitComparisonExpression(node, (Object)complement);
            }
            NormalizedSimpleComparison normalized = optionalNormalized.get();
            Expression symbolExpression = normalized.getSymbolExpression();
            if (symbolExpression instanceof SymbolReference) {
                Symbol symbol = Symbol.from(symbolExpression);
                NullableValue value = normalized.getValue();
                Type type = value.getType();
                return Visitor.createComparisonExtractionResult(normalized.getComparisonOperator(), symbol, type, value.getValue(), complement).orElseGet(() -> (ExtractionResult)super.visitComparisonExpression(node, (Object)complement));
            }
            if (symbolExpression instanceof Cast) {
                Cast castExpression = (Cast)symbolExpression;
                if (!this.isImplicitCoercion(castExpression)) {
                    return (ExtractionResult)super.visitComparisonExpression(node, (Object)complement);
                }
                Type castSourceType = this.typeAnalyzer.getType(this.session, this.types, castExpression.getExpression());
                Optional<Expression> coercedExpression = this.coerceComparisonWithRounding(castSourceType, castExpression.getExpression(), normalized.getValue(), normalized.getComparisonOperator());
                if (coercedExpression.isPresent()) {
                    return (ExtractionResult)this.process((Node)coercedExpression.get(), complement);
                }
                return (ExtractionResult)super.visitComparisonExpression(node, (Object)complement);
            }
            return (ExtractionResult)super.visitComparisonExpression(node, (Object)complement);
        }

        private Optional<NormalizedSimpleComparison> toNormalizedSimpleComparison(ComparisonExpression comparison) {
            NullableValue value;
            ComparisonExpression.Operator comparisonOperator;
            Expression symbolExpression;
            Map<NodeRef<Expression>, Type> expressionTypes = this.analyzeExpression((Expression)comparison);
            Object left = ExpressionInterpreter.expressionOptimizer(comparison.getLeft(), this.metadata, this.session, expressionTypes).optimize(NoOpSymbolResolver.INSTANCE);
            Object right = ExpressionInterpreter.expressionOptimizer(comparison.getRight(), this.metadata, this.session, expressionTypes).optimize(NoOpSymbolResolver.INSTANCE);
            Type leftType = expressionTypes.get(NodeRef.of((Node)comparison.getLeft()));
            Type rightType = expressionTypes.get(NodeRef.of((Node)comparison.getRight()));
            if (left instanceof Expression == right instanceof Expression) {
                return Optional.empty();
            }
            if (left instanceof Expression) {
                symbolExpression = comparison.getLeft();
                comparisonOperator = comparison.getOperator();
                value = new NullableValue(rightType, right);
            } else {
                symbolExpression = comparison.getRight();
                comparisonOperator = comparison.getOperator().flip();
                value = new NullableValue(leftType, left);
            }
            return Optional.of(new NormalizedSimpleComparison(symbolExpression, comparisonOperator, value));
        }

        private boolean isImplicitCoercion(Cast cast) {
            Map<NodeRef<Expression>, Type> expressionTypes = this.analyzeExpression((Expression)cast);
            Type actualType = expressionTypes.get(NodeRef.of((Node)cast.getExpression()));
            Type expectedType = expressionTypes.get(NodeRef.of((Node)cast));
            return this.typeCoercion.canCoerce(actualType, expectedType);
        }

        private Map<NodeRef<Expression>, Type> analyzeExpression(Expression expression) {
            return this.typeAnalyzer.getTypes(this.session, this.types, expression);
        }

        private static Optional<ExtractionResult> createComparisonExtractionResult(ComparisonExpression.Operator comparisonOperator, Symbol column, Type type, @Nullable Object value, boolean complement) {
            if (value == null) {
                switch (comparisonOperator) {
                    case EQUAL: 
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: 
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: 
                    case NOT_EQUAL: {
                        return Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.none(), (Expression)BooleanLiteral.TRUE_LITERAL));
                    }
                    case IS_DISTINCT_FROM: {
                        Domain domain2 = Visitor.complementIfNecessary(Domain.notNull((Type)type), complement);
                        return Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)domain2)), (Expression)BooleanLiteral.TRUE_LITERAL));
                    }
                }
                throw new AssertionError((Object)("Unhandled operator: " + comparisonOperator));
            }
            if (type.isOrderable()) {
                return Visitor.extractOrderableDomain(comparisonOperator, type, value, complement).map(domain -> new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)domain)), (Expression)BooleanLiteral.TRUE_LITERAL));
            }
            if (type.isComparable()) {
                Domain domain3 = Visitor.extractEquatableDomain(comparisonOperator, type, value, complement);
                return Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)domain3)), (Expression)BooleanLiteral.TRUE_LITERAL));
            }
            throw new AssertionError((Object)("Type cannot be used in a comparison expression (should have been caught in analysis): " + type));
        }

        private static Optional<Domain> extractOrderableDomain(ComparisonExpression.Operator comparisonOperator, Type type, Object value, boolean complement) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0);
            if (!(type instanceof DoubleType) && !(type instanceof RealType)) {
                switch (comparisonOperator) {
                    case EQUAL: {
                        return Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.equal((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false));
                    }
                    case GREATER_THAN: {
                        return Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.greaterThan((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false));
                    }
                    case GREATER_THAN_OR_EQUAL: {
                        return Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false));
                    }
                    case LESS_THAN: {
                        return Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false));
                    }
                    case LESS_THAN_OR_EQUAL: {
                        return Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, (Object)value), (Range[])new Range[0]), complement), (boolean)false));
                    }
                    case NOT_EQUAL: {
                        return Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)value), (Range[])new Range[]{Range.greaterThan((Type)type, (Object)value)}), complement), (boolean)false));
                    }
                    case IS_DISTINCT_FROM: {
                        return Optional.of(Visitor.complementIfNecessary(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)value), (Range[])new Range[]{Range.greaterThan((Type)type, (Object)value)}), (boolean)true), complement));
                    }
                }
                throw new AssertionError((Object)("Unhandled operator: " + comparisonOperator));
            }
            if (TypeUtils.isFloatingPointNaN((Type)type, (Object)value)) {
                switch (comparisonOperator) {
                    case EQUAL: 
                    case GREATER_THAN: 
                    case GREATER_THAN_OR_EQUAL: 
                    case LESS_THAN: 
                    case LESS_THAN_OR_EQUAL: {
                        return Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.none((Type)type), complement), (boolean)false));
                    }
                    case NOT_EQUAL: {
                        return Optional.of(Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.all((Type)type), complement), (boolean)false));
                    }
                    case IS_DISTINCT_FROM: {
                        return Optional.empty();
                    }
                }
                throw new AssertionError((Object)("Unhandled operator: " + comparisonOperator));
            }
            switch (comparisonOperator) {
                case EQUAL: {
                    if (complement) {
                        return Optional.empty();
                    }
                    return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false));
                }
                case GREATER_THAN: {
                    if (complement) {
                        return Optional.empty();
                    }
                    return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false));
                }
                case GREATER_THAN_OR_EQUAL: {
                    if (complement) {
                        return Optional.empty();
                    }
                    return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false));
                }
                case LESS_THAN: {
                    if (complement) {
                        return Optional.empty();
                    }
                    return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false));
                }
                case LESS_THAN_OR_EQUAL: {
                    if (complement) {
                        return Optional.empty();
                    }
                    return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false));
                }
                case NOT_EQUAL: {
                    if (complement) {
                        return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false));
                    }
                    return Optional.empty();
                }
                case IS_DISTINCT_FROM: {
                    if (complement) {
                        return Optional.of(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)type, (Object)value), (Range[])new Range[0]), (boolean)false));
                    }
                    return Optional.empty();
                }
            }
            throw new AssertionError((Object)("Unhandled operator: " + comparisonOperator));
        }

        private static Domain extractEquatableDomain(ComparisonExpression.Operator comparisonOperator, Type type, Object value, boolean complement) {
            Preconditions.checkArgument((value != null ? 1 : 0) != 0);
            switch (comparisonOperator) {
                case EQUAL: {
                    return Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.of((Type)type, (Object)value, (Object[])new Object[0]), complement), (boolean)false);
                }
                case NOT_EQUAL: {
                    return Domain.create((ValueSet)Visitor.complementIfNecessary(ValueSet.of((Type)type, (Object)value, (Object[])new Object[0]).complement(), complement), (boolean)false);
                }
                case IS_DISTINCT_FROM: {
                    return Visitor.complementIfNecessary(Domain.create((ValueSet)ValueSet.of((Type)type, (Object)value, (Object[])new Object[0]).complement(), (boolean)true), complement);
                }
            }
            throw new AssertionError((Object)("Unhandled operator: " + comparisonOperator));
        }

        private Optional<Expression> coerceComparisonWithRounding(Type symbolExpressionType, Expression symbolExpression, NullableValue nullableValue, ComparisonExpression.Operator comparisonOperator) {
            Objects.requireNonNull(nullableValue, "nullableValue is null");
            if (nullableValue.isNull()) {
                return Optional.empty();
            }
            Type valueType = nullableValue.getType();
            Object value = nullableValue.getValue();
            return this.floorValue(valueType, symbolExpressionType, value).map(floorValue -> this.rewriteComparisonExpression(symbolExpressionType, symbolExpression, valueType, value, floorValue, comparisonOperator));
        }

        private Expression rewriteComparisonExpression(Type symbolExpressionType, Expression symbolExpression, Type valueType, Object originalValue, Object coercedValue, ComparisonExpression.Operator comparisonOperator) {
            int originalComparedToCoerced = this.compareOriginalValueToCoerced(valueType, originalValue, symbolExpressionType, coercedValue);
            boolean coercedValueIsEqualToOriginal = originalComparedToCoerced == 0;
            boolean coercedValueIsLessThanOriginal = originalComparedToCoerced > 0;
            boolean coercedValueIsGreaterThanOriginal = originalComparedToCoerced < 0;
            Expression coercedLiteral = this.literalEncoder.toExpression(coercedValue, symbolExpressionType);
            switch (comparisonOperator) {
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    if (coercedValueIsGreaterThanOriginal) {
                        return new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, symbolExpression, coercedLiteral);
                    }
                    if (coercedValueIsEqualToOriginal) {
                        return new ComparisonExpression(comparisonOperator, symbolExpression, coercedLiteral);
                    }
                    if (coercedValueIsLessThanOriginal) {
                        return new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, symbolExpression, coercedLiteral);
                    }
                }
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    if (coercedValueIsLessThanOriginal) {
                        return new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, symbolExpression, coercedLiteral);
                    }
                    if (coercedValueIsEqualToOriginal) {
                        return new ComparisonExpression(comparisonOperator, symbolExpression, coercedLiteral);
                    }
                    if (coercedValueIsGreaterThanOriginal) {
                        return new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, symbolExpression, coercedLiteral);
                    }
                }
                case EQUAL: {
                    if (coercedValueIsEqualToOriginal) {
                        return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, symbolExpression, coercedLiteral);
                    }
                    return ExpressionUtils.and(new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, symbolExpression, coercedLiteral), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, symbolExpression, coercedLiteral)});
                }
                case NOT_EQUAL: {
                    if (coercedValueIsEqualToOriginal) {
                        return new ComparisonExpression(comparisonOperator, symbolExpression, coercedLiteral);
                    }
                    return ExpressionUtils.or(new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.EQUAL, symbolExpression, coercedLiteral), new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, symbolExpression, coercedLiteral)});
                }
                case IS_DISTINCT_FROM: {
                    if (coercedValueIsEqualToOriginal) {
                        return new ComparisonExpression(comparisonOperator, symbolExpression, coercedLiteral);
                    }
                    return BooleanLiteral.TRUE_LITERAL;
                }
            }
            throw new IllegalArgumentException("Unhandled operator: " + comparisonOperator);
        }

        private Optional<Object> floorValue(Type fromType, Type toType, Object value) {
            return this.getSaturatedFloorCastOperator(fromType, toType).map(operator -> this.functionInvoker.invoke((ResolvedFunction)operator, this.session.toConnectorSession(), value));
        }

        private Optional<ResolvedFunction> getSaturatedFloorCastOperator(Type fromType, Type toType) {
            try {
                return Optional.of(this.metadata.getCoercion(OperatorType.SATURATED_FLOOR_CAST, fromType, toType));
            }
            catch (OperatorNotFoundException e) {
                return Optional.empty();
            }
        }

        private int compareOriginalValueToCoerced(Type originalValueType, Object originalValue, Type coercedValueType, Object coercedValue) {
            ResolvedFunction castToOriginalTypeOperator = this.metadata.getCoercion(coercedValueType, originalValueType);
            Object coercedValueInOriginalType = this.functionInvoker.invoke(castToOriginalTypeOperator, this.session.toConnectorSession(), coercedValue);
            Block originalValueBlock = Utils.nativeValueToBlock((Type)originalValueType, (Object)originalValue);
            Block coercedValueBlock = Utils.nativeValueToBlock((Type)originalValueType, (Object)coercedValueInOriginalType);
            return originalValueType.compareTo(originalValueBlock, 0, coercedValueBlock, 0);
        }

        protected ExtractionResult visitInPredicate(InPredicate node, Boolean complement) {
            if (!(node.getValueList() instanceof InListExpression)) {
                return (ExtractionResult)super.visitInPredicate(node, (Object)complement);
            }
            InListExpression valueList = (InListExpression)node.getValueList();
            Preconditions.checkState((!valueList.getValues().isEmpty() ? 1 : 0) != 0, (Object)"InListExpression should never be empty");
            ImmutableList.Builder disjuncts = ImmutableList.builder();
            for (Expression expression : valueList.getValues()) {
                disjuncts.add((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, node.getValue(), expression));
            }
            ExtractionResult extractionResult = (ExtractionResult)this.process((Node)ExpressionUtils.or((Collection<Expression>)disjuncts.build()), complement);
            if (extractionResult.tupleDomain.isAll()) {
                InPredicate originalPredicate = node;
                if (complement.booleanValue()) {
                    originalPredicate = new NotExpression((Expression)originalPredicate);
                }
                return new ExtractionResult(extractionResult.tupleDomain, (Expression)originalPredicate);
            }
            return extractionResult;
        }

        protected ExtractionResult visitBetweenPredicate(BetweenPredicate node, Boolean complement) {
            return (ExtractionResult)this.process((Node)ExpressionUtils.and(new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, node.getValue(), node.getMin()), new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, node.getValue(), node.getMax())}), complement);
        }

        protected ExtractionResult visitLikePredicate(LikePredicate node, Boolean complement) {
            Optional<ExtractionResult> result = this.tryVisitLikePredicate(node, complement);
            if (result.isPresent()) {
                return result.get();
            }
            return (ExtractionResult)super.visitLikePredicate(node, (Object)complement);
        }

        private Optional<ExtractionResult> tryVisitLikePredicate(LikePredicate node, Boolean complement) {
            if (!(node.getValue() instanceof SymbolReference)) {
                return Optional.empty();
            }
            if (!(node.getPattern() instanceof StringLiteral)) {
                return Optional.empty();
            }
            if (node.getEscape().isPresent() && !(node.getEscape().get() instanceof StringLiteral)) {
                return Optional.empty();
            }
            Type type = this.typeAnalyzer.getType(this.session, this.types, node.getValue());
            if (!(type instanceof VarcharType)) {
                return Optional.empty();
            }
            VarcharType varcharType = (VarcharType)type;
            Symbol symbol = Symbol.from(node.getValue());
            Slice pattern = ((StringLiteral)node.getPattern()).getSlice();
            Optional<Slice> escape = node.getEscape().map(StringLiteral.class::cast).map(StringLiteral::getSlice);
            int patternConstantPrefixBytes = LikeFunctions.patternConstantPrefixBytes(pattern, escape);
            if (patternConstantPrefixBytes == pattern.length()) {
                Slice literal = LikeFunctions.unescapeLiteralLikePattern(pattern, escape);
                ValueSet valueSet = varcharType.isUnbounded() || SliceUtf8.countCodePoints((Slice)literal) <= varcharType.getBoundedLength() ? ValueSet.of((Type)type, (Object)literal, (Object[])new Object[0]) : ValueSet.none((Type)type);
                Domain domain = Domain.create((ValueSet)Visitor.complementIfNecessary(valueSet, (boolean)complement), (boolean)false);
                return Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain)), (Expression)BooleanLiteral.TRUE_LITERAL));
            }
            if (complement.booleanValue() || patternConstantPrefixBytes == 0) {
                return Optional.empty();
            }
            Slice constantPrefix = LikeFunctions.unescapeLiteralLikePattern(pattern.slice(0, patternConstantPrefixBytes), escape);
            int lastIncrementable = -1;
            for (int position = 0; position < constantPrefix.length(); position += SliceUtf8.lengthOfCodePoint((Slice)constantPrefix, (int)position)) {
                if (SliceUtf8.getCodePointAt((Slice)constantPrefix, (int)position) >= 127) continue;
                lastIncrementable = position;
            }
            if (lastIncrementable == -1) {
                return Optional.empty();
            }
            Slice lowerBound = constantPrefix;
            Slice upperBound = Slices.copyOf((Slice)constantPrefix.slice(0, lastIncrementable + SliceUtf8.lengthOfCodePoint((Slice)constantPrefix, (int)lastIncrementable)));
            SliceUtf8.setCodePointAt((int)(SliceUtf8.getCodePointAt((Slice)constantPrefix, (int)lastIncrementable) + 1), (Slice)upperBound, (int)lastIncrementable);
            Domain domain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)type, (Object)lowerBound, (boolean)true, (Object)upperBound, (boolean)false), (Range[])new Range[0]), (boolean)false);
            return Optional.of(new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain)), (Expression)node));
        }

        protected ExtractionResult visitIsNullPredicate(IsNullPredicate node, Boolean complement) {
            if (!(node.getValue() instanceof SymbolReference)) {
                return (ExtractionResult)super.visitIsNullPredicate(node, (Object)complement);
            }
            Symbol symbol = Symbol.from(node.getValue());
            Type columnType = this.checkedTypeLookup(symbol);
            Domain domain = Visitor.complementIfNecessary(Domain.onlyNull((Type)columnType), (boolean)complement);
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain)), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        protected ExtractionResult visitIsNotNullPredicate(IsNotNullPredicate node, Boolean complement) {
            if (!(node.getValue() instanceof SymbolReference)) {
                return (ExtractionResult)super.visitIsNotNullPredicate(node, (Object)complement);
            }
            Symbol symbol = Symbol.from(node.getValue());
            Type columnType = this.checkedTypeLookup(symbol);
            Domain domain = Visitor.complementIfNecessary(Domain.notNull((Type)columnType), (boolean)complement);
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain)), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        protected ExtractionResult visitBooleanLiteral(BooleanLiteral node, Boolean complement) {
            boolean value = complement.booleanValue() ? !node.getValue() : node.getValue();
            return new ExtractionResult((TupleDomain<Symbol>)(value ? TupleDomain.all() : TupleDomain.none()), (Expression)BooleanLiteral.TRUE_LITERAL);
        }

        protected ExtractionResult visitNullLiteral(NullLiteral node, Boolean complement) {
            return new ExtractionResult((TupleDomain<Symbol>)TupleDomain.none(), (Expression)BooleanLiteral.TRUE_LITERAL);
        }
    }
}

