/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.log.Logger;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.DynamicFilters;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.optimizations.PlanNodeSearcher;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.tree.SymbolReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public class LocalDynamicFilterConsumer {
    private static final Logger log = Logger.get(LocalDynamicFilterConsumer.class);
    private final Multimap<DynamicFilterId, Symbol> probeSymbols;
    private final Map<DynamicFilterId, Integer> buildChannels;
    private final Map<DynamicFilterId, Type> filterBuildTypes;
    private final SettableFuture<TupleDomain<DynamicFilterId>> resultFuture;
    private final int partitionCount;
    private final List<TupleDomain<DynamicFilterId>> partitions;

    public LocalDynamicFilterConsumer(Multimap<DynamicFilterId, Symbol> probeSymbols, Map<DynamicFilterId, Integer> buildChannels, Map<DynamicFilterId, Type> filterBuildTypes, int partitionCount) {
        this.probeSymbols = Objects.requireNonNull(probeSymbols, "probeSymbols is null");
        this.buildChannels = Objects.requireNonNull(buildChannels, "buildChannels is null");
        Verify.verify((boolean)buildChannels.keySet().containsAll(probeSymbols.keySet()), (String)"probeSymbols should be subset of buildChannels", (Object[])new Object[0]);
        this.filterBuildTypes = Objects.requireNonNull(filterBuildTypes, "filterBuildTypes is null");
        Verify.verify((boolean)buildChannels.keySet().equals(filterBuildTypes.keySet()), (String)"filterBuildTypes and buildChannels must have same keys", (Object[])new Object[0]);
        this.resultFuture = SettableFuture.create();
        this.partitionCount = partitionCount;
        this.partitions = new ArrayList<TupleDomain<DynamicFilterId>>(partitionCount);
    }

    public ListenableFuture<Map<DynamicFilterId, Domain>> getDynamicFilterDomains() {
        return Futures.transform(this.resultFuture, this::convertTupleDomain, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Map<Symbol, Domain>> getNodeLocalDynamicFilterForSymbols() {
        return Futures.transform(this.resultFuture, this::convertTupleDomainForLocalFilters, (Executor)MoreExecutors.directExecutor());
    }

    private synchronized void addPartition(TupleDomain<DynamicFilterId> tupleDomain) {
        Verify.verify((this.partitions.size() < this.partitionCount ? 1 : 0) != 0);
        this.partitions.add(tupleDomain);
        if (this.partitions.size() == this.partitionCount) {
            TupleDomain result = TupleDomain.columnWiseUnion(this.partitions);
            this.resultFuture.set((Object)result);
        }
    }

    private Map<Symbol, Domain> convertTupleDomainForLocalFilters(TupleDomain<DynamicFilterId> result) {
        if (result.isNone()) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<DynamicFilterId, Type> entry : this.filterBuildTypes.entrySet()) {
                for (Symbol probeSymbol : this.probeSymbols.get((Object)entry.getKey())) {
                    builder.put((Object)probeSymbol, (Object)Domain.none((Type)entry.getValue()));
                }
            }
            return builder.build();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : ((Map)result.getDomains().get()).entrySet()) {
            Domain domain = (Domain)entry.getValue();
            for (Symbol probeSymbol : this.probeSymbols.get((Object)((DynamicFilterId)entry.getKey()))) {
                builder.put((Object)probeSymbol, (Object)domain);
            }
        }
        return builder.build();
    }

    private Map<DynamicFilterId, Domain> convertTupleDomain(TupleDomain<DynamicFilterId> result) {
        if (result.isNone()) {
            return (Map)this.buildChannels.keySet().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), filterId -> Domain.none((Type)this.filterBuildTypes.get(filterId))));
        }
        return (Map)result.getDomains().get();
    }

    public static LocalDynamicFilterConsumer create(JoinNode planNode, List<Type> buildSourceTypes, int partitionCount) {
        Preconditions.checkArgument((!planNode.getDynamicFilters().isEmpty() ? 1 : 0) != 0, (Object)"Join node dynamicFilters is empty.");
        Set<DynamicFilterId> joinDynamicFilters = planNode.getDynamicFilters().keySet();
        List filterNodes = PlanNodeSearcher.searchFrom(planNode.getLeft()).where(LocalDynamicFilterConsumer::isFilterAboveTableScan).findAll();
        ImmutableMultimap.Builder probeSymbolsBuilder = ImmutableMultimap.builder();
        for (FilterNode filterNode : filterNodes) {
            DynamicFilters.ExtractResult extractResult = DynamicFilters.extractDynamicFilters(filterNode.getPredicate());
            for (DynamicFilters.Descriptor descriptor : extractResult.getDynamicConjuncts()) {
                if (!(descriptor.getInput() instanceof SymbolReference) || !joinDynamicFilters.contains(descriptor.getId())) continue;
                Symbol probeSymbol = Symbol.from(descriptor.getInput());
                log.debug("Adding dynamic filter %s: %s", new Object[]{descriptor, probeSymbol});
                probeSymbolsBuilder.put((Object)descriptor.getId(), (Object)probeSymbol);
            }
        }
        ImmutableMultimap probeSymbols = probeSymbolsBuilder.build();
        PlanNode buildNode = planNode.getRight();
        Map buildChannels = (Map)planNode.getDynamicFilters().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
            Symbol buildSymbol = (Symbol)entry.getValue();
            int buildChannelIndex = buildNode.getOutputSymbols().indexOf(buildSymbol);
            Verify.verify((buildChannelIndex >= 0 ? 1 : 0) != 0);
            return buildChannelIndex;
        }));
        Map filterBuildTypes = (Map)buildChannels.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (Type)buildSourceTypes.get((Integer)entry.getValue())));
        return new LocalDynamicFilterConsumer((Multimap<DynamicFilterId, Symbol>)probeSymbols, buildChannels, filterBuildTypes, partitionCount);
    }

    private static boolean isFilterAboveTableScan(PlanNode node) {
        return node instanceof FilterNode && ((FilterNode)node).getSource() instanceof TableScanNode;
    }

    public Map<DynamicFilterId, Integer> getBuildChannels() {
        return this.buildChannels;
    }

    public Consumer<TupleDomain<DynamicFilterId>> getTupleDomainConsumer() {
        return this::addPartition;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("probeSymbols", this.probeSymbols).add("buildChannels", this.buildChannels).add("partitionCount", this.partitionCount).add("partitions", this.partitions).toString();
    }
}

