/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.sql.planner.Symbol;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class LocalDynamicFiltersCollector {
    @GuardedBy(value="this")
    private final Map<Symbol, Domain> dynamicFilterDomainsResult = new HashMap<Symbol, Domain>();

    LocalDynamicFiltersCollector() {
    }

    public synchronized TupleDomain<Symbol> getDynamicFilter(Set<Symbol> probeSymbols) {
        Map probeSymbolDomains = (Map)this.dynamicFilterDomainsResult.entrySet().stream().filter(entry -> probeSymbols.contains(entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        return TupleDomain.withColumnDomains((Map)probeSymbolDomains);
    }

    public synchronized void addDynamicFilter(Map<Symbol, Domain> dynamicFilterDomains) {
        for (Map.Entry<Symbol, Domain> entry : dynamicFilterDomains.entrySet()) {
            this.dynamicFilterDomainsResult.merge(entry.getKey(), entry.getValue(), Domain::intersect);
        }
    }
}

