/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.planner.ExpressionExtractor;
import io.prestosql.sql.planner.PlanBuilder;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.ReferenceAwareExpressionNodeInliner;
import io.prestosql.sql.planner.RelationPlan;
import io.prestosql.sql.planner.RelationPlanner;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.TranslationMap;
import io.prestosql.sql.planner.plan.ApplyNode;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.CorrelatedJoinNode;
import io.prestosql.sql.planner.plan.EnforceSingleRowNode;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.SimplePlanRewriter;
import io.prestosql.sql.planner.plan.UnnestNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.DefaultExpressionTraversalVisitor;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.ExistsPredicate;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.InPredicate;
import io.prestosql.sql.tree.LambdaArgumentDeclaration;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.NotExpression;
import io.prestosql.sql.tree.QuantifiedComparisonExpression;
import io.prestosql.sql.tree.Query;
import io.prestosql.sql.tree.SubqueryExpression;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.sql.util.AstUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class SubqueryPlanner {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap;
    private final Metadata metadata;
    private final Session session;

    SubqueryPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Map<NodeRef<LambdaArgumentDeclaration>, Symbol> lambdaDeclarationToSymbolMap, Metadata metadata, Session session) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(lambdaDeclarationToSymbolMap, "lambdaDeclarationToSymbolMap is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.lambdaDeclarationToSymbolMap = lambdaDeclarationToSymbolMap;
        this.metadata = metadata;
        this.session = session;
    }

    public PlanBuilder handleSubqueries(PlanBuilder builder, Collection<Expression> expressions, Node node) {
        for (Expression expression : expressions) {
            builder = this.handleSubqueries(builder, expression, node);
        }
        return builder;
    }

    public PlanBuilder handleSubqueries(PlanBuilder builder, Expression expression, Node node) {
        builder = this.appendInPredicateApplyNodes(builder, this.collectInPredicateSubqueries(expression, node), node);
        builder = this.appendScalarSubqueryCorrelatedJoins(builder, this.collectScalarSubqueries(expression, node));
        builder = this.appendExistsSubqueryApplyNodes(builder, this.collectExistsSubqueries(expression, node));
        builder = this.appendQuantifiedComparisonApplyNodes(builder, this.collectQuantifiedComparisonSubqueries(expression, node), node);
        return builder;
    }

    public Set<InPredicate> collectInPredicateSubqueries(Expression expression, Node node) {
        return (Set)this.analysis.getInPredicateSubqueries(node).stream().filter(inPredicate -> AstUtils.nodeContains((Node)expression, (Node)inPredicate.getValueList())).collect(ImmutableSet.toImmutableSet());
    }

    public Set<SubqueryExpression> collectScalarSubqueries(Expression expression, Node node) {
        return (Set)this.analysis.getScalarSubqueries(node).stream().filter(subquery -> AstUtils.nodeContains((Node)expression, (Node)subquery)).collect(ImmutableSet.toImmutableSet());
    }

    public Set<ExistsPredicate> collectExistsSubqueries(Expression expression, Node node) {
        return (Set)this.analysis.getExistsSubqueries(node).stream().filter(subquery -> AstUtils.nodeContains((Node)expression, (Node)subquery)).collect(ImmutableSet.toImmutableSet());
    }

    public Set<QuantifiedComparisonExpression> collectQuantifiedComparisonSubqueries(Expression expression, Node node) {
        return (Set)this.analysis.getQuantifiedComparisonSubqueries(node).stream().filter(quantifiedComparison -> AstUtils.nodeContains((Node)expression, (Node)quantifiedComparison.getSubquery())).collect(ImmutableSet.toImmutableSet());
    }

    private PlanBuilder appendInPredicateApplyNodes(PlanBuilder subPlan, Set<InPredicate> inPredicates, Node node) {
        for (InPredicate inPredicate : inPredicates) {
            subPlan = this.appendInPredicateApplyNode(subPlan, inPredicate, node);
        }
        return subPlan;
    }

    private PlanBuilder appendInPredicateApplyNode(PlanBuilder subPlan, InPredicate inPredicate, Node node) {
        if (subPlan.canTranslate((Expression)inPredicate)) {
            return subPlan;
        }
        subPlan = this.handleSubqueries(subPlan, inPredicate.getValue(), node);
        subPlan = subPlan.appendProjections((Iterable<Expression>)ImmutableList.of((Object)inPredicate.getValue()), this.symbolAllocator, this.idAllocator);
        Preconditions.checkState((boolean)(inPredicate.getValueList() instanceof SubqueryExpression));
        SubqueryExpression valueListSubquery = (SubqueryExpression)inPredicate.getValueList();
        SubqueryExpression uncoercedValueListSubquery = this.uncoercedSubquery(valueListSubquery);
        PlanBuilder subqueryPlan = this.createPlanBuilder((Node)uncoercedValueListSubquery);
        subqueryPlan = subqueryPlan.appendProjections((Iterable<Expression>)ImmutableList.of((Object)valueListSubquery), this.symbolAllocator, this.idAllocator);
        SymbolReference valueList = subqueryPlan.translate((Expression)valueListSubquery).toSymbolReference();
        Symbol rewrittenValue = subPlan.translate(inPredicate.getValue());
        InPredicate inPredicateSubqueryExpression = new InPredicate((Expression)rewrittenValue.toSymbolReference(), (Expression)valueList);
        Symbol inPredicateSubquerySymbol = this.symbolAllocator.newSymbol((Expression)inPredicateSubqueryExpression, (Type)BooleanType.BOOLEAN);
        subPlan.getTranslations().put((Expression)inPredicate, inPredicateSubquerySymbol);
        return this.appendApplyNode(subPlan, (Node)inPredicate, subqueryPlan.getRoot(), Assignments.of(inPredicateSubquerySymbol, (Expression)inPredicateSubqueryExpression));
    }

    private PlanBuilder appendScalarSubqueryCorrelatedJoins(PlanBuilder builder, Set<SubqueryExpression> scalarSubqueries) {
        for (SubqueryExpression scalarSubquery : scalarSubqueries) {
            builder = this.appendScalarSubqueryApplyNode(builder, scalarSubquery);
        }
        return builder;
    }

    private PlanBuilder appendScalarSubqueryApplyNode(PlanBuilder subPlan, SubqueryExpression scalarSubquery) {
        if (subPlan.canTranslate((Expression)scalarSubquery)) {
            return subPlan;
        }
        List<Expression> coercions = this.coercionsFor((Expression)scalarSubquery);
        SubqueryExpression uncoercedScalarSubquery = this.uncoercedSubquery(scalarSubquery);
        PlanBuilder subqueryPlan = this.createPlanBuilder((Node)uncoercedScalarSubquery);
        subqueryPlan = subqueryPlan.withNewRoot(new EnforceSingleRowNode(this.idAllocator.getNextId(), subqueryPlan.getRoot()));
        subqueryPlan = subqueryPlan.appendProjections(coercions, this.symbolAllocator, this.idAllocator);
        Symbol uncoercedScalarSubquerySymbol = subqueryPlan.translate((Expression)uncoercedScalarSubquery);
        subPlan.getTranslations().put((Expression)uncoercedScalarSubquery, uncoercedScalarSubquerySymbol);
        for (Expression coercion : coercions) {
            Symbol coercionSymbol = subqueryPlan.translate(coercion);
            subPlan.getTranslations().put(coercion, coercionSymbol);
        }
        return this.appendCorrelatedJoin(subPlan, subqueryPlan, scalarSubquery.getQuery(), CorrelatedJoinNode.Type.INNER, (Expression)BooleanLiteral.TRUE_LITERAL);
    }

    public PlanBuilder appendCorrelatedJoin(PlanBuilder subPlan, PlanBuilder subqueryPlan, Query query, CorrelatedJoinNode.Type type, Expression filterCondition) {
        PlanNode subqueryNode = subqueryPlan.getRoot();
        Map<NodeRef<Expression>, Expression> correlation = this.extractCorrelation(subPlan, subqueryNode);
        subqueryNode = this.replaceExpressionsWithSymbols(subqueryNode, correlation);
        return new PlanBuilder(subPlan.copyTranslations(), new CorrelatedJoinNode(this.idAllocator.getNextId(), subPlan.getRoot(), subqueryNode, (List<Symbol>)ImmutableList.copyOf(SymbolsExtractor.extractUnique(correlation.values())), type, filterCondition, (Node)query));
    }

    private PlanBuilder appendExistsSubqueryApplyNodes(PlanBuilder builder, Set<ExistsPredicate> existsPredicates) {
        for (ExistsPredicate existsPredicate : existsPredicates) {
            builder = this.appendExistSubqueryApplyNode(builder, existsPredicate);
        }
        return builder;
    }

    private PlanBuilder appendExistSubqueryApplyNode(PlanBuilder subPlan, ExistsPredicate existsPredicate) {
        if (subPlan.canTranslate((Expression)existsPredicate)) {
            return subPlan;
        }
        PlanBuilder subqueryPlan = this.createPlanBuilder((Node)existsPredicate.getSubquery());
        Symbol exists = this.symbolAllocator.newSymbol("exists", (Type)BooleanType.BOOLEAN);
        subPlan.getTranslations().put((Expression)existsPredicate, exists);
        ExistsPredicate rewrittenExistsPredicate = new ExistsPredicate((Expression)BooleanLiteral.TRUE_LITERAL);
        return this.appendApplyNode(subPlan, (Node)existsPredicate.getSubquery(), subqueryPlan.getRoot(), Assignments.of(exists, (Expression)rewrittenExistsPredicate));
    }

    private PlanBuilder appendQuantifiedComparisonApplyNodes(PlanBuilder subPlan, Set<QuantifiedComparisonExpression> quantifiedComparisons, Node node) {
        for (QuantifiedComparisonExpression quantifiedComparison : quantifiedComparisons) {
            subPlan = this.appendQuantifiedComparisonApplyNode(subPlan, quantifiedComparison, node);
        }
        return subPlan;
    }

    private PlanBuilder appendQuantifiedComparisonApplyNode(PlanBuilder subPlan, QuantifiedComparisonExpression quantifiedComparison, Node node) {
        if (subPlan.canTranslate((Expression)quantifiedComparison)) {
            return subPlan;
        }
        switch (quantifiedComparison.getOperator()) {
            case EQUAL: {
                switch (quantifiedComparison.getQuantifier()) {
                    case ALL: {
                        return this.planQuantifiedApplyNode(subPlan, quantifiedComparison);
                    }
                    case ANY: 
                    case SOME: {
                        InPredicate inPredicate = new InPredicate(quantifiedComparison.getValue(), quantifiedComparison.getSubquery());
                        subPlan = this.appendInPredicateApplyNode(subPlan, inPredicate, node);
                        subPlan.getTranslations().put((Expression)quantifiedComparison, subPlan.translate((Expression)inPredicate));
                        return subPlan;
                    }
                }
                break;
            }
            case NOT_EQUAL: {
                switch (quantifiedComparison.getQuantifier()) {
                    case ALL: {
                        QuantifiedComparisonExpression rewrittenAny = new QuantifiedComparisonExpression(ComparisonExpression.Operator.EQUAL, QuantifiedComparisonExpression.Quantifier.ANY, quantifiedComparison.getValue(), quantifiedComparison.getSubquery());
                        NotExpression notAny = new NotExpression((Expression)rewrittenAny);
                        subPlan.getTranslations().put((Expression)quantifiedComparison, subPlan.getTranslations().rewrite((Expression)notAny));
                        return this.appendQuantifiedComparisonApplyNode(subPlan, rewrittenAny, node);
                    }
                    case ANY: 
                    case SOME: {
                        QuantifiedComparisonExpression rewrittenAll = new QuantifiedComparisonExpression(ComparisonExpression.Operator.EQUAL, QuantifiedComparisonExpression.Quantifier.ALL, quantifiedComparison.getValue(), quantifiedComparison.getSubquery());
                        NotExpression notAll = new NotExpression((Expression)rewrittenAll);
                        subPlan.getTranslations().put((Expression)quantifiedComparison, subPlan.getTranslations().rewrite((Expression)notAll));
                        return this.appendQuantifiedComparisonApplyNode(subPlan, rewrittenAll, node);
                    }
                }
                break;
            }
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                return this.planQuantifiedApplyNode(subPlan, quantifiedComparison);
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected quantified comparison: '%s %s'", quantifiedComparison.getOperator().getValue(), quantifiedComparison.getQuantifier()));
    }

    private PlanBuilder planQuantifiedApplyNode(PlanBuilder subPlan, QuantifiedComparisonExpression quantifiedComparison) {
        subPlan = subPlan.appendProjections((Iterable<Expression>)ImmutableList.of((Object)quantifiedComparison.getValue()), this.symbolAllocator, this.idAllocator);
        Preconditions.checkState((boolean)(quantifiedComparison.getSubquery() instanceof SubqueryExpression));
        SubqueryExpression quantifiedSubquery = (SubqueryExpression)quantifiedComparison.getSubquery();
        SubqueryExpression uncoercedQuantifiedSubquery = this.uncoercedSubquery(quantifiedSubquery);
        PlanBuilder subqueryPlan = this.createPlanBuilder((Node)uncoercedQuantifiedSubquery);
        subqueryPlan = subqueryPlan.appendProjections((Iterable<Expression>)ImmutableList.of((Object)quantifiedSubquery), this.symbolAllocator, this.idAllocator);
        QuantifiedComparisonExpression coercedQuantifiedComparison = new QuantifiedComparisonExpression(quantifiedComparison.getOperator(), quantifiedComparison.getQuantifier(), (Expression)subPlan.translate(quantifiedComparison.getValue()).toSymbolReference(), (Expression)subqueryPlan.translate((Expression)quantifiedSubquery).toSymbolReference());
        Symbol coercedQuantifiedComparisonSymbol = this.symbolAllocator.newSymbol((Expression)coercedQuantifiedComparison, (Type)BooleanType.BOOLEAN);
        subPlan.getTranslations().put((Expression)quantifiedComparison, coercedQuantifiedComparisonSymbol);
        return this.appendApplyNode(subPlan, (Node)quantifiedComparison.getSubquery(), subqueryPlan.getRoot(), Assignments.of(coercedQuantifiedComparisonSymbol, (Expression)coercedQuantifiedComparison));
    }

    private SubqueryExpression uncoercedSubquery(SubqueryExpression subquery) {
        return new SubqueryExpression(subquery.getQuery());
    }

    private List<Expression> coercionsFor(Expression expression) {
        return (List)this.analysis.getCoercions().keySet().stream().map(NodeRef::getNode).filter(coercionExpression -> coercionExpression.equals((Object)expression)).collect(ImmutableList.toImmutableList());
    }

    private PlanBuilder appendApplyNode(PlanBuilder subPlan, Node subquery, PlanNode subqueryNode, Assignments subqueryAssignments) {
        Map<NodeRef<Expression>, Expression> correlation = this.extractCorrelation(subPlan, subqueryNode);
        subPlan = subPlan.appendProjections((Iterable)correlation.keySet().stream().map(NodeRef::getNode).collect(ImmutableSet.toImmutableSet()), this.symbolAllocator, this.idAllocator);
        subqueryNode = this.replaceExpressionsWithSymbols(subqueryNode, correlation);
        TranslationMap translations = subPlan.copyTranslations();
        PlanNode root = subPlan.getRoot();
        return new PlanBuilder(translations, new ApplyNode(this.idAllocator.getNextId(), root, subqueryNode, subqueryAssignments, (List<Symbol>)ImmutableList.copyOf(SymbolsExtractor.extractUnique(correlation.values())), subquery));
    }

    private Map<NodeRef<Expression>, Expression> extractCorrelation(PlanBuilder subPlan, PlanNode subquery) {
        Set<NodeRef<Expression>> missingReferences = this.extractOuterColumnReferences(subquery);
        ImmutableMap.Builder correlation = ImmutableMap.builder();
        for (NodeRef<Expression> missingReference : missingReferences) {
            SubqueryPlanner.tryResolveMissingExpression(subPlan, (Expression)missingReference.getNode()).ifPresent(symbolReference -> correlation.put((Object)missingReference, symbolReference));
        }
        return correlation.build();
    }

    private static Optional<Expression> tryResolveMissingExpression(PlanBuilder subPlan, Expression expression) {
        Expression rewritten = subPlan.rewrite(expression);
        if (rewritten != expression) {
            return Optional.of(rewritten);
        }
        return Optional.empty();
    }

    private PlanBuilder createPlanBuilder(Node node) {
        RelationPlan relationPlan = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.lambdaDeclarationToSymbolMap, this.metadata, this.session).process(node, null);
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis, this.lambdaDeclarationToSymbolMap);
        translations.setFieldMappings(relationPlan.getFieldMappings());
        if (node instanceof Expression && relationPlan.getFieldMappings().size() == 1) {
            translations.put((Expression)node, (Symbol)Iterables.getOnlyElement(relationPlan.getFieldMappings()));
        }
        return new PlanBuilder(translations, relationPlan.getRoot());
    }

    private Set<NodeRef<Expression>> extractOuterColumnReferences(PlanNode planNode) {
        return (Set)ExpressionExtractor.extractExpressions(planNode).stream().flatMap(expression -> SubqueryPlanner.extractColumnReferences(expression, this.analysis.getColumnReferences()).stream()).collect(ImmutableSet.toImmutableSet());
    }

    private static Set<NodeRef<Expression>> extractColumnReferences(Expression expression, Set<NodeRef<Expression>> columnReferences) {
        ColumnReferencesExtractor columnReferencesExtractor = new ColumnReferencesExtractor(columnReferences);
        columnReferencesExtractor.process((Node)expression, null);
        return columnReferencesExtractor.getFound();
    }

    private PlanNode replaceExpressionsWithSymbols(PlanNode planNode, Map<NodeRef<Expression>, Expression> mapping) {
        if (mapping.isEmpty()) {
            return planNode;
        }
        return SimplePlanRewriter.rewriteWith(new ExpressionReplacer(mapping), planNode, null);
    }

    private static class ExpressionReplacer
    extends SimplePlanRewriter<Void> {
        private final Map<NodeRef<Expression>, Expression> mapping;

        public ExpressionReplacer(Map<NodeRef<Expression>, Expression> mapping) {
            this.mapping = Objects.requireNonNull(mapping, "mapping is null");
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            ProjectNode rewrittenNode = (ProjectNode)context.defaultRewrite(node);
            Assignments assignments = rewrittenNode.getAssignments().rewrite(expression -> ReferenceAwareExpressionNodeInliner.replaceExpression(expression, this.mapping));
            return new ProjectNode(node.getId(), rewrittenNode.getSource(), assignments);
        }

        @Override
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            FilterNode rewrittenNode = (FilterNode)context.defaultRewrite(node);
            return new FilterNode(node.getId(), rewrittenNode.getSource(), ReferenceAwareExpressionNodeInliner.replaceExpression(rewrittenNode.getPredicate(), this.mapping));
        }

        @Override
        public PlanNode visitUnnest(UnnestNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            UnnestNode rewrittenNode = (UnnestNode)context.defaultRewrite(node);
            return new UnnestNode(node.getId(), rewrittenNode.getSource(), rewrittenNode.getReplicateSymbols(), rewrittenNode.getMappings(), rewrittenNode.getOrdinalitySymbol(), rewrittenNode.getJoinType(), rewrittenNode.getFilter().map(expression -> ReferenceAwareExpressionNodeInliner.replaceExpression(expression, this.mapping)));
        }

        @Override
        public PlanNode visitValues(ValuesNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            ValuesNode rewrittenNode = (ValuesNode)context.defaultRewrite(node);
            List rewrittenRows = (List)rewrittenNode.getRows().stream().map(row -> (ImmutableList)row.stream().map(column -> ReferenceAwareExpressionNodeInliner.replaceExpression(column, this.mapping)).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
            return new ValuesNode(node.getId(), rewrittenNode.getOutputSymbols(), rewrittenRows);
        }
    }

    private static class ColumnReferencesExtractor
    extends DefaultExpressionTraversalVisitor<Void> {
        private final Set<NodeRef<Expression>> columnReferences;
        private final ImmutableSet.Builder<NodeRef<Expression>> found = ImmutableSet.builder();

        private ColumnReferencesExtractor(Set<NodeRef<Expression>> columnReferences) {
            this.columnReferences = Objects.requireNonNull(columnReferences, "columnReferences is null");
        }

        public Set<NodeRef<Expression>> getFound() {
            return this.found.build();
        }

        protected Void visitDereferenceExpression(DereferenceExpression node, Void context) {
            if (this.columnReferences.contains(NodeRef.of((Node)node))) {
                this.found.add((Object)NodeRef.of((Node)node));
            } else {
                this.process((Node)node.getBase(), context);
            }
            return null;
        }

        protected Void visitIdentifier(Identifier node, Void context) {
            this.found.add((Object)NodeRef.of((Node)node));
            return null;
        }
    }
}

