/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.planner.FunctionCallBuilder;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.optimizations.PlanNodeSearcher;
import io.prestosql.sql.planner.optimizations.QueryCardinalityUtil;
import io.prestosql.sql.planner.plan.AssignUniqueId;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.CorrelatedJoinNode;
import io.prestosql.sql.planner.plan.EnforceSingleRowNode;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.MarkDistinctNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SimpleCaseExpression;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.WhenClause;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TransformCorrelatedScalarSubquery
implements Rule<CorrelatedJoinNode> {
    private static final Pattern<CorrelatedJoinNode> PATTERN = Patterns.correlatedJoin().with(Pattern.nonEmpty(Patterns.CorrelatedJoin.correlation())).with(Patterns.CorrelatedJoin.filter().equalTo((Object)BooleanLiteral.TRUE_LITERAL));
    private final Metadata metadata;

    public TransformCorrelatedScalarSubquery(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<CorrelatedJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(CorrelatedJoinNode correlatedJoinNode, Captures captures, Rule.Context context) {
        PlanNode subquery = context.getLookup().resolve(correlatedJoinNode.getSubquery());
        if (!PlanNodeSearcher.searchFrom(subquery, context.getLookup()).where(EnforceSingleRowNode.class::isInstance).recurseOnlyWhen(ProjectNode.class::isInstance).matches()) {
            return Rule.Result.empty();
        }
        PlanNode rewrittenSubquery = PlanNodeSearcher.searchFrom(subquery, context.getLookup()).where(EnforceSingleRowNode.class::isInstance).recurseOnlyWhen(ProjectNode.class::isInstance).removeFirst();
        Range<Long> subqueryCardinality = QueryCardinalityUtil.extractCardinality(rewrittenSubquery, context.getLookup());
        boolean producesAtMostOneRow = Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(1L)).encloses(subqueryCardinality);
        if (producesAtMostOneRow) {
            boolean producesSingleRow = Range.singleton((Comparable)Long.valueOf(1L)).encloses(subqueryCardinality);
            return Rule.Result.ofPlanNode(new CorrelatedJoinNode(context.getIdAllocator().getNextId(), correlatedJoinNode.getInput(), rewrittenSubquery, correlatedJoinNode.getCorrelation(), producesSingleRow ? correlatedJoinNode.getType() : CorrelatedJoinNode.Type.LEFT, correlatedJoinNode.getFilter(), correlatedJoinNode.getOriginSubquery()));
        }
        Symbol unique = context.getSymbolAllocator().newSymbol("unique", (Type)BigintType.BIGINT);
        CorrelatedJoinNode rewrittenCorrelatedJoinNode = new CorrelatedJoinNode(context.getIdAllocator().getNextId(), new AssignUniqueId(context.getIdAllocator().getNextId(), correlatedJoinNode.getInput(), unique), rewrittenSubquery, correlatedJoinNode.getCorrelation(), CorrelatedJoinNode.Type.LEFT, correlatedJoinNode.getFilter(), correlatedJoinNode.getOriginSubquery());
        Symbol isDistinct = context.getSymbolAllocator().newSymbol("is_distinct", (Type)BooleanType.BOOLEAN);
        MarkDistinctNode markDistinctNode = new MarkDistinctNode(context.getIdAllocator().getNextId(), rewrittenCorrelatedJoinNode, isDistinct, rewrittenCorrelatedJoinNode.getInput().getOutputSymbols(), Optional.empty());
        FilterNode filterNode = new FilterNode(context.getIdAllocator().getNextId(), markDistinctNode, (Expression)new SimpleCaseExpression((Expression)isDistinct.toSymbolReference(), (List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)BooleanLiteral.TRUE_LITERAL)), Optional.of(new Cast((Expression)new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)"fail")).addArgument((Type)IntegerType.INTEGER, (Expression)new LongLiteral(Integer.toString(StandardErrorCode.SUBQUERY_MULTIPLE_ROWS.toErrorCode().getCode()))).addArgument((Type)VarcharType.VARCHAR, (Expression)new StringLiteral("Scalar sub-query has returned multiple rows")).build(), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN)))));
        return Rule.Result.ofPlanNode(new ProjectNode(context.getIdAllocator().getNextId(), filterNode, Assignments.identity(correlatedJoinNode.getOutputSymbols())));
    }
}

