/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.optimizations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.sql.planner.DeterminismEvaluator;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.PartitioningScheme;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.optimizations.PlanOptimizer;
import io.prestosql.sql.planner.optimizations.SymbolMapper;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.ApplyNode;
import io.prestosql.sql.planner.plan.AssignUniqueId;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.CorrelatedJoinNode;
import io.prestosql.sql.planner.plan.DeleteNode;
import io.prestosql.sql.planner.plan.DistinctLimitNode;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.planner.plan.EnforceSingleRowNode;
import io.prestosql.sql.planner.plan.ExceptNode;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.ExplainAnalyzeNode;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.GroupIdNode;
import io.prestosql.sql.planner.plan.IndexJoinNode;
import io.prestosql.sql.planner.plan.IndexSourceNode;
import io.prestosql.sql.planner.plan.IntersectNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.MarkDistinctNode;
import io.prestosql.sql.planner.plan.OffsetNode;
import io.prestosql.sql.planner.plan.OutputNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.RemoteSourceNode;
import io.prestosql.sql.planner.plan.RowNumberNode;
import io.prestosql.sql.planner.plan.SampleNode;
import io.prestosql.sql.planner.plan.SemiJoinNode;
import io.prestosql.sql.planner.plan.SortNode;
import io.prestosql.sql.planner.plan.SpatialJoinNode;
import io.prestosql.sql.planner.plan.StatisticsWriterNode;
import io.prestosql.sql.planner.plan.TableDeleteNode;
import io.prestosql.sql.planner.plan.TableFinishNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.plan.TableWriterNode;
import io.prestosql.sql.planner.plan.TopNNode;
import io.prestosql.sql.planner.plan.TopNRowNumberNode;
import io.prestosql.sql.planner.plan.UnionNode;
import io.prestosql.sql.planner.plan.UnnestNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.planner.plan.WindowNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.SymbolReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class UnaliasSymbolReferences
implements PlanOptimizer {
    private final Metadata metadata;

    public UnaliasSymbolReferences(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return plan.accept(new Visitor(this.metadata), UnaliasContext.empty()).getRoot();
    }

    private static class PlanAndMappings {
        private final PlanNode root;
        private final Map<Symbol, Symbol> mappings;

        public PlanAndMappings(PlanNode root, Map<Symbol, Symbol> mappings) {
            this.root = Objects.requireNonNull(root, "root is null");
            this.mappings = ImmutableMap.copyOf(Objects.requireNonNull(mappings, "mappings is null"));
        }

        public PlanNode getRoot() {
            return this.root;
        }

        public Map<Symbol, Symbol> getMappings() {
            return this.mappings;
        }
    }

    private static class UnaliasContext {
        private final Map<Symbol, Symbol> correlationMapping;

        public UnaliasContext(Map<Symbol, Symbol> correlationMapping) {
            this.correlationMapping = Objects.requireNonNull(correlationMapping, "correlationMapping is null");
        }

        public static UnaliasContext empty() {
            return new UnaliasContext((Map<Symbol, Symbol>)ImmutableMap.of());
        }

        public Map<Symbol, Symbol> getCorrelationMapping() {
            return this.correlationMapping;
        }
    }

    private static class Visitor
    extends PlanVisitor<PlanAndMappings, UnaliasContext> {
        private final Metadata metadata;

        public Visitor(Metadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        @Override
        protected PlanAndMappings visitPlan(PlanNode node, UnaliasContext context) {
            throw new UnsupportedOperationException("Unsupported plan node " + node.getClass().getSimpleName());
        }

        @Override
        public PlanAndMappings visitAggregation(AggregationNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            AggregationNode rewrittenAggregation = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenAggregation, mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitGroupId(GroupIdNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            GroupIdNode rewrittenGroupId = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenGroupId, mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitExplainAnalyze(ExplainAnalyzeNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            Symbol newOutputSymbol = mapper.map(node.getOutputSymbol());
            return new PlanAndMappings(new ExplainAnalyzeNode(node.getId(), rewrittenSource.getRoot(), newOutputSymbol, node.isVerbose()), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitMarkDistinct(MarkDistinctNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            Symbol newMarkerSymbol = mapper.map(node.getMarkerSymbol());
            List<Symbol> newDistinctSymbols = mapper.mapAndDistinct(node.getDistinctSymbols());
            Optional<Symbol> newHashSymbol = node.getHashSymbol().map(mapper::map);
            return new PlanAndMappings(new MarkDistinctNode(node.getId(), rewrittenSource.getRoot(), newMarkerSymbol, newDistinctSymbols, newHashSymbol), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitUnnest(UnnestNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            List<Symbol> newReplicateSymbols = mapper.mapAndDistinct(node.getReplicateSymbols());
            ImmutableList.Builder newMappings = ImmutableList.builder();
            for (UnnestNode.Mapping unnestMapping : node.getMappings()) {
                newMappings.add((Object)new UnnestNode.Mapping(mapper.map(unnestMapping.getInput()), mapper.map(unnestMapping.getOutputs())));
            }
            Optional<Symbol> newOrdinalitySymbol = node.getOrdinalitySymbol().map(mapper::map);
            Optional<Expression> newFilter = node.getFilter().map(mapper::map);
            return new PlanAndMappings(new UnnestNode(node.getId(), rewrittenSource.getRoot(), newReplicateSymbols, (List<UnnestNode.Mapping>)newMappings.build(), newOrdinalitySymbol, node.getJoinType(), newFilter), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitWindow(WindowNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            WindowNode rewrittenWindow = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenWindow, mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitTableScan(TableScanNode node, UnaliasContext context) {
            SymbolMapper mapper = new SymbolMapper(context.getCorrelationMapping());
            List<Symbol> newOutputs = mapper.map(node.getOutputSymbols());
            HashMap<Symbol, ColumnHandle> newAssignments = new HashMap<Symbol, ColumnHandle>();
            node.getAssignments().forEach((symbol, handle) -> newAssignments.put(mapper.map((Symbol)symbol), (ColumnHandle)handle));
            return new PlanAndMappings(new TableScanNode(node.getId(), node.getTable(), newOutputs, newAssignments, node.getEnforcedConstraint()), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitExchange(ExchangeNode node, UnaliasContext context) {
            ImmutableList.Builder rewrittenChildren = ImmutableList.builder();
            ImmutableList.Builder rewrittenInputsBuilder = ImmutableList.builder();
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanAndMappings rewrittenChild = node.getSources().get(i).accept(this, context);
                rewrittenChildren.add((Object)rewrittenChild.getRoot());
                SymbolMapper mapper = new SymbolMapper(rewrittenChild.getMappings());
                rewrittenInputsBuilder.add(mapper.map(node.getInputs().get(i)));
            }
            ImmutableList rewrittenInputs = rewrittenInputsBuilder.build();
            SymbolMapper mapper = new SymbolMapper(context.getCorrelationMapping());
            List<Symbol> rewrittenOutputs = mapper.map(node.getOutputSymbols());
            HashMap<Symbol, ImmutableList> outputsToInputs = new HashMap<Symbol, ImmutableList>();
            for (int i = 0; i < rewrittenOutputs.size(); ++i) {
                ImmutableList.Builder inputsBuilder = ImmutableList.builder();
                for (List inputs : rewrittenInputs) {
                    inputsBuilder.add((Object)((Symbol)inputs.get(i)));
                }
                ImmutableList inputs = inputsBuilder.build();
                List previous = (List)outputsToInputs.put(rewrittenOutputs.get(i), inputs);
                Preconditions.checkState((previous == null || inputs.equals(previous) ? 1 : 0) != 0, (Object)"different inputs mapped to the same output symbol");
            }
            HashMap<Symbol, Symbol> newMapping = new HashMap<Symbol, Symbol>();
            if (rewrittenInputs.size() == 1) {
                for (int i = 0; i < rewrittenOutputs.size(); ++i) {
                    Symbol input;
                    Symbol output = rewrittenOutputs.get(i);
                    if (output.equals(input = (Symbol)((List)rewrittenInputs.get(0)).get(i))) continue;
                    newMapping.put(output, input);
                }
            }
            HashMap<ImmutableList, Symbol> inputsToOutputs = new HashMap<ImmutableList, Symbol>();
            for (int i = 0; i < rewrittenOutputs.size(); ++i) {
                ImmutableList.Builder inputsBuilder = ImmutableList.builder();
                for (List inputs : rewrittenInputs) {
                    inputsBuilder.add((Object)((Symbol)inputs.get(i)));
                }
                ImmutableList inputs = inputsBuilder.build();
                Symbol previous = (Symbol)inputsToOutputs.get(inputs);
                if (previous == null || rewrittenOutputs.get(i).equals(previous)) {
                    inputsToOutputs.put(inputs, rewrittenOutputs.get(i));
                    continue;
                }
                newMapping.put(rewrittenOutputs.get(i), previous);
            }
            HashMap<Symbol, Symbol> outputMapping = new HashMap<Symbol, Symbol>();
            outputMapping.putAll(mapper.getMapping());
            outputMapping.putAll(newMapping);
            mapper = new SymbolMapper(outputMapping);
            ArrayList<List<Symbol>> newInputs = new ArrayList<List<Symbol>>();
            for (int i = 0; i < node.getInputs().size(); ++i) {
                newInputs.add(new ArrayList());
            }
            ImmutableList.Builder newOutputs = ImmutableList.builder();
            HashSet<Symbol> addedOutputs = new HashSet<Symbol>();
            for (int i = 0; i < rewrittenOutputs.size(); ++i) {
                Symbol output = mapper.map(rewrittenOutputs.get(i));
                if (!addedOutputs.add(output)) continue;
                newOutputs.add((Object)output);
                for (int j = 0; j < rewrittenInputs.size(); ++j) {
                    ((List)newInputs.get(j)).add((Symbol)((List)rewrittenInputs.get(j)).get(i));
                }
            }
            PartitioningScheme newPartitioningScheme = mapper.map(node.getPartitioningScheme(), (List<Symbol>)newOutputs.build());
            Optional<OrderingScheme> newOrderingScheme = node.getOrderingScheme().map(mapper::map);
            return new PlanAndMappings(new ExchangeNode(node.getId(), node.getType(), node.getScope(), newPartitioningScheme, (List<PlanNode>)rewrittenChildren.build(), newInputs, newOrderingScheme), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitRemoteSource(RemoteSourceNode node, UnaliasContext context) {
            SymbolMapper mapper = new SymbolMapper(context.getCorrelationMapping());
            List<Symbol> newOutputs = mapper.mapAndDistinct(node.getOutputSymbols());
            Optional<OrderingScheme> newOrderingScheme = node.getOrderingScheme().map(mapper::map);
            return new PlanAndMappings(new RemoteSourceNode(node.getId(), node.getSourceFragmentIds(), newOutputs, newOrderingScheme, node.getExchangeType()), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitOffset(OffsetNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            return new PlanAndMappings(node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)rewrittenSource.getRoot())), rewrittenSource.getMappings());
        }

        @Override
        public PlanAndMappings visitLimit(LimitNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            LimitNode rewrittenLimit = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenLimit, mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitDistinctLimit(DistinctLimitNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            DistinctLimitNode rewrittenDistinctLimit = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenDistinctLimit, mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitSample(SampleNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            return new PlanAndMappings(node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)rewrittenSource.getRoot())), rewrittenSource.getMappings());
        }

        @Override
        public PlanAndMappings visitValues(ValuesNode node, UnaliasContext context) {
            SymbolMapper mapper = new SymbolMapper(context.getCorrelationMapping());
            List newRows = (List)node.getRows().stream().map(row -> (ImmutableList)row.stream().map(mapper::map).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
            List<Symbol> newOutputSymbols = mapper.mapAndDistinct(node.getOutputSymbols());
            Preconditions.checkState((node.getOutputSymbols().size() == newOutputSymbols.size() ? 1 : 0) != 0, (Object)"Values output symbols were pruned");
            return new PlanAndMappings(new ValuesNode(node.getId(), newOutputSymbols, newRows), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitTableDelete(TableDeleteNode node, UnaliasContext context) {
            SymbolMapper mapper = new SymbolMapper(context.getCorrelationMapping());
            Symbol newOutput = mapper.map(node.getOutput());
            return new PlanAndMappings(new TableDeleteNode(node.getId(), node.getTarget(), newOutput), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitDelete(DeleteNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            Symbol newRowId = mapper.map(node.getRowId());
            List<Symbol> newOutputs = mapper.map(node.getOutputSymbols());
            return new PlanAndMappings(new DeleteNode(node.getId(), rewrittenSource.getRoot(), node.getTarget(), newRowId, newOutputs), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitStatisticsWriterNode(StatisticsWriterNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            StatisticsWriterNode rewrittenStatisticsWriter = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenStatisticsWriter, mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitTableWriter(TableWriterNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            TableWriterNode rewrittenTableWriter = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenTableWriter, mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitTableFinish(TableFinishNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            TableFinishNode rewrittenTableFinish = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenTableFinish, mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitRowNumber(RowNumberNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            RowNumberNode rewrittenRowNumber = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenRowNumber, mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitTopNRowNumber(TopNRowNumberNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            TopNRowNumberNode rewrittenTopNRowNumber = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenTopNRowNumber, mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitTopN(TopNNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            TopNNode rewrittenTopN = mapper.map(node, rewrittenSource.getRoot());
            return new PlanAndMappings(rewrittenTopN, mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitSort(SortNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            OrderingScheme newOrderingScheme = mapper.map(node.getOrderingScheme());
            return new PlanAndMappings(new SortNode(node.getId(), rewrittenSource.getRoot(), newOrderingScheme, node.isPartial()), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitFilter(FilterNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            Expression newPredicate = mapper.map(node.getPredicate());
            return new PlanAndMappings(new FilterNode(node.getId(), rewrittenSource.getRoot(), newPredicate), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitProject(ProjectNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            ImmutableList.Builder rewrittenAssignments = ImmutableList.builder();
            for (Map.Entry<Symbol, Expression> assignment : node.getAssignments().entrySet()) {
                rewrittenAssignments.add(new AbstractMap.SimpleEntry<Symbol, Expression>(mapper.map(assignment.getKey()), mapper.map(assignment.getValue())));
            }
            Map<Symbol, Expression> deduplicateAssignments = rewrittenAssignments.build().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (previous, current) -> {
                Preconditions.checkState((boolean)previous.equals(current), (Object)"different expressions projected to the same symbol");
                return previous;
            }));
            Map<Symbol, Symbol> newMapping = this.mappingFromAssignments(deduplicateAssignments);
            HashMap<Symbol, Symbol> outputMapping = new HashMap<Symbol, Symbol>();
            outputMapping.putAll(mapper.getMapping());
            outputMapping.putAll(newMapping);
            mapper = new SymbolMapper(outputMapping);
            Assignments.Builder newAssignments = Assignments.builder();
            for (Map.Entry<Symbol, Expression> assignment : deduplicateAssignments.entrySet()) {
                newAssignments.put(mapper.map(assignment.getKey()), assignment.getValue());
            }
            return new PlanAndMappings(new ProjectNode(node.getId(), rewrittenSource.getRoot(), newAssignments.build()), mapper.getMapping());
        }

        private Map<Symbol, Symbol> mappingFromAssignments(Map<Symbol, Expression> assignments) {
            HashMap<Symbol, Symbol> newMapping = new HashMap<Symbol, Symbol>();
            HashMap<Expression, Symbol> inputsToOutputs = new HashMap<Expression, Symbol>();
            for (Map.Entry<Symbol, Expression> assignment : assignments.entrySet()) {
                Expression expression = assignment.getValue();
                if (expression instanceof SymbolReference) {
                    Symbol value = Symbol.from(expression);
                    if (assignment.getKey().equals(value)) continue;
                    newMapping.put(assignment.getKey(), value);
                    continue;
                }
                if (!DeterminismEvaluator.isDeterministic(expression, this.metadata) || expression instanceof NullLiteral) continue;
                Symbol previous = (Symbol)inputsToOutputs.get(expression);
                if (previous == null) {
                    inputsToOutputs.put(expression, assignment.getKey());
                    continue;
                }
                newMapping.put(assignment.getKey(), previous);
            }
            return newMapping;
        }

        @Override
        public PlanAndMappings visitOutput(OutputNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            List<Symbol> newOutputs = mapper.map(node.getOutputSymbols());
            return new PlanAndMappings(new OutputNode(node.getId(), rewrittenSource.getRoot(), node.getColumnNames(), newOutputs), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitEnforceSingleRow(EnforceSingleRowNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            return new PlanAndMappings(node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)rewrittenSource.getRoot())), rewrittenSource.getMappings());
        }

        @Override
        public PlanAndMappings visitAssignUniqueId(AssignUniqueId node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenSource.getMappings());
            Symbol newUnique = mapper.map(node.getIdColumn());
            return new PlanAndMappings(new AssignUniqueId(node.getId(), rewrittenSource.getRoot(), newUnique), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitApply(ApplyNode node, UnaliasContext context) {
            PlanAndMappings rewrittenInput = node.getInput().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenInput.getMappings());
            List<Symbol> rewrittenCorrelation = mapper.mapAndDistinct(node.getCorrelation());
            ImmutableSet correlationSymbols = ImmutableSet.copyOf(node.getCorrelation());
            Map correlationMapping = (Map)mapper.getMapping().entrySet().stream().filter(arg_0 -> Visitor.lambda$visitApply$3((Set)correlationSymbols, arg_0)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            HashMap<Symbol, Symbol> mappingForSubquery = new HashMap<Symbol, Symbol>();
            mappingForSubquery.putAll(context.getCorrelationMapping());
            mappingForSubquery.putAll(correlationMapping);
            PlanAndMappings rewrittenSubquery = node.getSubquery().accept(this, new UnaliasContext(mappingForSubquery));
            HashMap<Symbol, Symbol> resultMapping = new HashMap<Symbol, Symbol>();
            resultMapping.putAll(rewrittenInput.getMappings());
            resultMapping.putAll(rewrittenSubquery.getMappings());
            mapper = new SymbolMapper(resultMapping);
            ImmutableList.Builder rewrittenAssignments = ImmutableList.builder();
            for (Map.Entry<Symbol, Expression> assignment : node.getSubqueryAssignments().entrySet()) {
                rewrittenAssignments.add(new AbstractMap.SimpleEntry<Symbol, Expression>(mapper.map(assignment.getKey()), mapper.map(assignment.getValue())));
            }
            Map<Symbol, Expression> deduplicateAssignments = rewrittenAssignments.build().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (previous, current) -> {
                Preconditions.checkState((boolean)previous.equals(current), (Object)"different expressions assigned to the same symbol");
                return previous;
            }));
            Map<Symbol, Symbol> newMapping = this.mappingFromAssignments(deduplicateAssignments);
            HashMap<Symbol, Symbol> assignmentsOutputMapping = new HashMap<Symbol, Symbol>();
            assignmentsOutputMapping.putAll(mapper.getMapping());
            assignmentsOutputMapping.putAll(newMapping);
            mapper = new SymbolMapper(assignmentsOutputMapping);
            Assignments.Builder newAssignments = Assignments.builder();
            for (Map.Entry<Symbol, Expression> assignment : deduplicateAssignments.entrySet()) {
                newAssignments.put(mapper.map(assignment.getKey()), assignment.getValue());
            }
            return new PlanAndMappings(new ApplyNode(node.getId(), rewrittenInput.getRoot(), rewrittenSubquery.getRoot(), newAssignments.build(), rewrittenCorrelation, node.getOriginSubquery()), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitCorrelatedJoin(CorrelatedJoinNode node, UnaliasContext context) {
            PlanAndMappings rewrittenInput = node.getInput().accept(this, context);
            SymbolMapper mapper = new SymbolMapper(rewrittenInput.getMappings());
            List<Symbol> rewrittenCorrelation = mapper.mapAndDistinct(node.getCorrelation());
            ImmutableSet correlationSymbols = ImmutableSet.copyOf(node.getCorrelation());
            Map correlationMapping = (Map)mapper.getMapping().entrySet().stream().filter(arg_0 -> Visitor.lambda$visitCorrelatedJoin$5((Set)correlationSymbols, arg_0)).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            HashMap<Symbol, Symbol> mappingForSubquery = new HashMap<Symbol, Symbol>();
            mappingForSubquery.putAll(context.getCorrelationMapping());
            mappingForSubquery.putAll(correlationMapping);
            PlanAndMappings rewrittenSubquery = node.getSubquery().accept(this, new UnaliasContext(mappingForSubquery));
            HashMap<Symbol, Symbol> resultMapping = new HashMap<Symbol, Symbol>();
            resultMapping.putAll(rewrittenInput.getMappings());
            resultMapping.putAll(rewrittenSubquery.getMappings());
            mapper = new SymbolMapper(resultMapping);
            Expression newFilter = mapper.map(node.getFilter());
            return new PlanAndMappings(new CorrelatedJoinNode(node.getId(), rewrittenInput.getRoot(), rewrittenSubquery.getRoot(), rewrittenCorrelation, node.getType(), newFilter, node.getOriginSubquery()), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitJoin(JoinNode node, UnaliasContext context) {
            PlanAndMappings rewrittenLeft = node.getLeft().accept(this, context);
            PlanAndMappings rewrittenRight = node.getRight().accept(this, context);
            HashMap<Symbol, Symbol> unifiedMapping = new HashMap<Symbol, Symbol>();
            unifiedMapping.putAll(rewrittenLeft.getMappings());
            unifiedMapping.putAll(rewrittenRight.getMappings());
            SymbolMapper mapper = new SymbolMapper(unifiedMapping);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (JoinNode.EquiJoinClause clause2 : node.getCriteria()) {
                builder.add((Object)new JoinNode.EquiJoinClause(mapper.map(clause2.getLeft()), mapper.map(clause2.getRight())));
            }
            ImmutableList newCriteria = builder.build();
            Optional<Expression> newFilter = node.getFilter().map(mapper::map);
            Optional<Symbol> newLeftHashSymbol = node.getLeftHashSymbol().map(mapper::map);
            Optional<Symbol> newRightHashSymbol = node.getRightHashSymbol().map(mapper::map);
            HashSet<Symbol> added = new HashSet<Symbol>();
            ImmutableMap.Builder filtersBuilder = ImmutableMap.builder();
            for (Map.Entry<DynamicFilterId, Symbol> entry : node.getDynamicFilters().entrySet()) {
                Symbol canonical = mapper.map(entry.getValue());
                if (!added.add(canonical)) continue;
                filtersBuilder.put((Object)entry.getKey(), (Object)canonical);
            }
            ImmutableMap newDynamicFilters = filtersBuilder.build();
            HashMap newMapping = new HashMap();
            if (node.getType() == JoinNode.Type.INNER) {
                newCriteria.stream().forEach(clause -> newMapping.put(clause.getRight(), clause.getLeft()));
            }
            HashMap<Symbol, Symbol> outputMapping = new HashMap<Symbol, Symbol>();
            outputMapping.putAll(mapper.getMapping());
            outputMapping.putAll(newMapping);
            mapper = new SymbolMapper(outputMapping);
            List<Symbol> canonicalOutputs = mapper.mapAndDistinct(node.getOutputSymbols());
            List newLeftOutputSymbols = (List)canonicalOutputs.stream().filter(rewrittenLeft.getRoot().getOutputSymbols()::contains).collect(ImmutableList.toImmutableList());
            List newRightOutputSymbols = (List)canonicalOutputs.stream().filter(rewrittenRight.getRoot().getOutputSymbols()::contains).collect(ImmutableList.toImmutableList());
            return new PlanAndMappings(new JoinNode(node.getId(), node.getType(), rewrittenLeft.getRoot(), rewrittenRight.getRoot(), (List<JoinNode.EquiJoinClause>)newCriteria, newLeftOutputSymbols, newRightOutputSymbols, newFilter, newLeftHashSymbol, newRightHashSymbol, node.getDistributionType(), node.isSpillable(), (Map<DynamicFilterId, Symbol>)newDynamicFilters, node.getReorderJoinStatsAndCost()), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitSemiJoin(SemiJoinNode node, UnaliasContext context) {
            PlanAndMappings rewrittenSource = node.getSource().accept(this, context);
            PlanAndMappings rewrittenFilteringSource = node.getFilteringSource().accept(this, context);
            HashMap<Symbol, Symbol> outputMapping = new HashMap<Symbol, Symbol>();
            outputMapping.putAll(rewrittenSource.getMappings());
            outputMapping.putAll(rewrittenFilteringSource.getMappings());
            SymbolMapper mapper = new SymbolMapper(outputMapping);
            Symbol newSourceJoinSymbol = mapper.map(node.getSourceJoinSymbol());
            Symbol newFilteringSourceJoinSymbol = mapper.map(node.getFilteringSourceJoinSymbol());
            Symbol newSemiJoinOutput = mapper.map(node.getSemiJoinOutput());
            Optional<Symbol> newSourceHashSymbol = node.getSourceHashSymbol().map(mapper::map);
            Optional<Symbol> newFilteringSourceHashSymbol = node.getFilteringSourceHashSymbol().map(mapper::map);
            return new PlanAndMappings(new SemiJoinNode(node.getId(), rewrittenSource.getRoot(), rewrittenFilteringSource.getRoot(), newSourceJoinSymbol, newFilteringSourceJoinSymbol, newSemiJoinOutput, newSourceHashSymbol, newFilteringSourceHashSymbol, node.getDistributionType()), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitSpatialJoin(SpatialJoinNode node, UnaliasContext context) {
            PlanAndMappings rewrittenLeft = node.getLeft().accept(this, context);
            PlanAndMappings rewrittenRight = node.getRight().accept(this, context);
            HashMap<Symbol, Symbol> outputMapping = new HashMap<Symbol, Symbol>();
            outputMapping.putAll(rewrittenLeft.getMappings());
            outputMapping.putAll(rewrittenRight.getMappings());
            SymbolMapper mapper = new SymbolMapper(outputMapping);
            List<Symbol> newOutputSymbols = mapper.mapAndDistinct(node.getOutputSymbols());
            Expression newFilter = mapper.map(node.getFilter());
            Optional<Symbol> newLeftPartitionSymbol = node.getLeftPartitionSymbol().map(mapper::map);
            Optional<Symbol> newRightPartitionSymbol = node.getRightPartitionSymbol().map(mapper::map);
            return new PlanAndMappings(new SpatialJoinNode(node.getId(), node.getType(), rewrittenLeft.getRoot(), rewrittenRight.getRoot(), newOutputSymbols, newFilter, newLeftPartitionSymbol, newRightPartitionSymbol, node.getKdbTree()), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitIndexJoin(IndexJoinNode node, UnaliasContext context) {
            PlanAndMappings rewrittenProbe = node.getProbeSource().accept(this, context);
            PlanAndMappings rewrittenIndex = node.getIndexSource().accept(this, context);
            HashMap<Symbol, Symbol> outputMapping = new HashMap<Symbol, Symbol>();
            outputMapping.putAll(rewrittenProbe.getMappings());
            outputMapping.putAll(rewrittenIndex.getMappings());
            SymbolMapper mapper = new SymbolMapper(outputMapping);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                builder.add((Object)new IndexJoinNode.EquiJoinClause(mapper.map(clause.getProbe()), mapper.map(clause.getIndex())));
            }
            ImmutableList newEquiCriteria = builder.build();
            Optional<Symbol> newProbeHashSymbol = node.getProbeHashSymbol().map(mapper::map);
            Optional<Symbol> newIndexHashSymbol = node.getIndexHashSymbol().map(mapper::map);
            return new PlanAndMappings(new IndexJoinNode(node.getId(), node.getType(), rewrittenProbe.getRoot(), rewrittenIndex.getRoot(), (List<IndexJoinNode.EquiJoinClause>)newEquiCriteria, newProbeHashSymbol, newIndexHashSymbol), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitIndexSource(IndexSourceNode node, UnaliasContext context) {
            SymbolMapper mapper = new SymbolMapper(context.getCorrelationMapping());
            Set newLookupSymbols = (Set)node.getLookupSymbols().stream().map(mapper::map).collect(ImmutableSet.toImmutableSet());
            List<Symbol> newOutputSymbols = mapper.mapAndDistinct(node.getOutputSymbols());
            HashMap<Symbol, ColumnHandle> newAssignments = new HashMap<Symbol, ColumnHandle>();
            node.getAssignments().entrySet().stream().forEach(assignment -> newAssignments.put(mapper.map((Symbol)assignment.getKey()), (ColumnHandle)assignment.getValue()));
            return new PlanAndMappings(new IndexSourceNode(node.getId(), node.getIndexHandle(), node.getTableHandle(), newLookupSymbols, newOutputSymbols, newAssignments), mapper.getMapping());
        }

        @Override
        public PlanAndMappings visitUnion(UnionNode node, UnaliasContext context) {
            List rewrittenSources = (List)node.getSources().stream().map(source -> source.accept(this, context)).collect(ImmutableList.toImmutableList());
            List inputMappers = (List)rewrittenSources.stream().map(source -> new SymbolMapper(source.getMappings())).collect(ImmutableList.toImmutableList());
            SymbolMapper outputMapper = new SymbolMapper(context.getCorrelationMapping());
            ListMultimap<Symbol, Symbol> newOutputToInputs = this.rewriteOutputToInputsMap(node.getSymbolMapping(), outputMapper, inputMappers);
            List<Symbol> newOutputs = outputMapper.mapAndDistinct(node.getOutputSymbols());
            return new PlanAndMappings(new UnionNode(node.getId(), (List)rewrittenSources.stream().map(PlanAndMappings::getRoot).collect(ImmutableList.toImmutableList()), newOutputToInputs, newOutputs), outputMapper.getMapping());
        }

        @Override
        public PlanAndMappings visitIntersect(IntersectNode node, UnaliasContext context) {
            List rewrittenSources = (List)node.getSources().stream().map(source -> source.accept(this, context)).collect(ImmutableList.toImmutableList());
            List inputMappers = (List)rewrittenSources.stream().map(source -> new SymbolMapper(source.getMappings())).collect(ImmutableList.toImmutableList());
            SymbolMapper outputMapper = new SymbolMapper(context.getCorrelationMapping());
            ListMultimap<Symbol, Symbol> newOutputToInputs = this.rewriteOutputToInputsMap(node.getSymbolMapping(), outputMapper, inputMappers);
            List<Symbol> newOutputs = outputMapper.mapAndDistinct(node.getOutputSymbols());
            return new PlanAndMappings(new IntersectNode(node.getId(), (List)rewrittenSources.stream().map(PlanAndMappings::getRoot).collect(ImmutableList.toImmutableList()), newOutputToInputs, newOutputs), outputMapper.getMapping());
        }

        @Override
        public PlanAndMappings visitExcept(ExceptNode node, UnaliasContext context) {
            List rewrittenSources = (List)node.getSources().stream().map(source -> source.accept(this, context)).collect(ImmutableList.toImmutableList());
            List inputMappers = (List)rewrittenSources.stream().map(source -> new SymbolMapper(source.getMappings())).collect(ImmutableList.toImmutableList());
            SymbolMapper outputMapper = new SymbolMapper(context.getCorrelationMapping());
            ListMultimap<Symbol, Symbol> newOutputToInputs = this.rewriteOutputToInputsMap(node.getSymbolMapping(), outputMapper, inputMappers);
            List<Symbol> newOutputs = outputMapper.mapAndDistinct(node.getOutputSymbols());
            return new PlanAndMappings(new ExceptNode(node.getId(), (List)rewrittenSources.stream().map(PlanAndMappings::getRoot).collect(ImmutableList.toImmutableList()), newOutputToInputs, newOutputs), outputMapper.getMapping());
        }

        private ListMultimap<Symbol, Symbol> rewriteOutputToInputsMap(ListMultimap<Symbol, Symbol> oldMapping, SymbolMapper outputMapper, List<SymbolMapper> inputMappers) {
            ImmutableListMultimap.Builder newMappingBuilder = ImmutableListMultimap.builder();
            HashSet<Symbol> addedSymbols = new HashSet<Symbol>();
            for (Map.Entry entry : oldMapping.asMap().entrySet()) {
                Symbol rewrittenOutput = outputMapper.map((Symbol)entry.getKey());
                if (!addedSymbols.add(rewrittenOutput)) continue;
                ImmutableList inputs = ImmutableList.copyOf((Collection)((Collection)entry.getValue()));
                ImmutableList.Builder rewrittenInputs = ImmutableList.builder();
                for (int i = 0; i < inputs.size(); ++i) {
                    rewrittenInputs.add((Object)inputMappers.get(i).map((Symbol)inputs.get(i)));
                }
                newMappingBuilder.putAll((Object)rewrittenOutput, (Iterable)rewrittenInputs.build());
            }
            return newMappingBuilder.build();
        }

        private static /* synthetic */ boolean lambda$visitCorrelatedJoin$5(Set correlationSymbols, Map.Entry mapping) {
            return correlationSymbols.contains(mapping.getKey());
        }

        private static /* synthetic */ boolean lambda$visitApply$3(Set correlationSymbols, Map.Entry mapping) {
            return correlationSymbols.contains(mapping.getKey());
        }
    }
}

