/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.rewrite;

import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.type.FixedWidthType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.sql.ParsingUtil;
import io.prestosql.sql.QueryUtil;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.analyzer.Analyzer;
import io.prestosql.sql.analyzer.Field;
import io.prestosql.sql.analyzer.QueryExplainer;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.rewrite.StatementRewrite;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.DescribeOutput;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Limit;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.Parameter;
import io.prestosql.sql.tree.Relation;
import io.prestosql.sql.tree.Row;
import io.prestosql.sql.tree.Select;
import io.prestosql.sql.tree.Statement;
import io.prestosql.sql.tree.StringLiteral;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class DescribeOutputRewrite
implements StatementRewrite.Rewrite {
    DescribeOutputRewrite() {
    }

    @Override
    public Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, AccessControl accessControl, WarningCollector warningCollector) {
        return (Statement)new Visitor(session, parser, metadata, queryExplainer, parameters, parameterLookup, accessControl, warningCollector).process((Node)node, null);
    }

    private static final class Visitor
    extends AstVisitor<Node, Void> {
        private final Session session;
        private final SqlParser parser;
        private final Metadata metadata;
        private final Optional<QueryExplainer> queryExplainer;
        private final List<Expression> parameters;
        private final Map<NodeRef<Parameter>, Expression> parameterLookup;
        private final AccessControl accessControl;
        private final WarningCollector warningCollector;

        public Visitor(Session session, SqlParser parser, Metadata metadata, Optional<QueryExplainer> queryExplainer, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, AccessControl accessControl, WarningCollector warningCollector) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.parser = parser;
            this.metadata = metadata;
            this.queryExplainer = queryExplainer;
            this.parameters = parameters;
            this.parameterLookup = parameterLookup;
            this.accessControl = accessControl;
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        protected Node visitDescribeOutput(DescribeOutput node, Void context) {
            String sqlString = this.session.getPreparedStatement(node.getName().getValue());
            Statement statement = this.parser.createStatement(sqlString, ParsingUtil.createParsingOptions(this.session));
            Analyzer analyzer = new Analyzer(this.session, this.metadata, this.parser, this.accessControl, this.queryExplainer, this.parameters, this.parameterLookup, this.warningCollector);
            Analysis analysis = analyzer.analyze(statement, true);
            Optional<Object> limit = Optional.empty();
            Row[] rows = (Row[])analysis.getRootScope().getRelationType().getVisibleFields().stream().map(field -> this.createDescribeOutputRow((Field)field, analysis)).toArray(Row[]::new);
            if (rows.length == 0) {
                NullLiteral nullLiteral = new NullLiteral();
                rows = new Row[]{QueryUtil.row((Expression[])new Expression[]{nullLiteral, nullLiteral, nullLiteral, nullLiteral, nullLiteral, nullLiteral, nullLiteral})};
                limit = Optional.of(new Limit("0"));
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{QueryUtil.identifier((String)"Column Name"), QueryUtil.identifier((String)"Catalog"), QueryUtil.identifier((String)"Schema"), QueryUtil.identifier((String)"Table"), QueryUtil.identifier((String)"Type"), QueryUtil.identifier((String)"Type Size"), QueryUtil.identifier((String)"Aliased")}), (Relation)QueryUtil.aliased((Relation)QueryUtil.values((Row[])rows), (String)"Statement Output", (List)ImmutableList.of((Object)"Column Name", (Object)"Catalog", (Object)"Schema", (Object)"Table", (Object)"Type", (Object)"Type Size", (Object)"Aliased")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), limit);
        }

        private Row createDescribeOutputRow(Field field, Analysis analysis) {
            Object columnName;
            LongLiteral typeSize = new LongLiteral("0");
            if (field.getType() instanceof FixedWidthType) {
                typeSize = new LongLiteral(String.valueOf(((FixedWidthType)field.getType()).getFixedSize()));
            }
            if (field.getName().isPresent()) {
                columnName = field.getName().get();
            } else {
                int columnIndex = ImmutableList.copyOf(analysis.getOutputDescriptor().getVisibleFields()).indexOf((Object)field);
                columnName = "_col" + columnIndex;
            }
            Optional<QualifiedObjectName> originTable = field.getOriginTable();
            String type = field.getType().getDisplayName();
            if (SystemSessionProperties.isOmitDateTimeTypePrecision(this.session)) {
                if (field.getType() instanceof TimestampType && ((TimestampType)field.getType()).getPrecision() == 3) {
                    type = "timestamp";
                } else if (field.getType() instanceof TimestampWithTimeZoneType && ((TimestampWithTimeZoneType)field.getType()).getPrecision() == 3) {
                    type = "timestamp with time zone";
                }
            }
            return QueryUtil.row((Expression[])new Expression[]{new StringLiteral((String)columnName), new StringLiteral(originTable.map(QualifiedObjectName::getCatalogName).orElse("")), new StringLiteral(originTable.map(QualifiedObjectName::getSchemaName).orElse("")), new StringLiteral(originTable.map(QualifiedObjectName::getObjectName).orElse("")), new StringLiteral(type), typeSize, new BooleanLiteral(String.valueOf(field.isAliased()))});
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }
    }
}

