/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system.jdbc;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import io.prestosql.FullConnectorSession;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.connector.system.SystemColumnHandle;
import io.prestosql.connector.system.jdbc.FilterUtil;
import io.prestosql.connector.system.jdbc.JdbcTable;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataListing;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedTablePrefix;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.InMemoryRecordSet;
import io.prestosql.spi.connector.RecordCursor;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.type.TypeUtils;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class ColumnJdbcTable
extends JdbcTable {
    public static final SchemaTableName NAME = new SchemaTableName("jdbc", "columns");
    private static final int MAX_DOMAIN_SIZE = 100;
    private static final int MAX_TIMEZONE_LENGTH = ZoneId.getAvailableZoneIds().stream().map(String::length).max(Integer::compareTo).get();
    private static final ColumnHandle TABLE_CATALOG_COLUMN = new SystemColumnHandle("table_cat");
    private static final ColumnHandle TABLE_SCHEMA_COLUMN = new SystemColumnHandle("table_schem");
    private static final ColumnHandle TABLE_NAME_COLUMN = new SystemColumnHandle("table_name");
    public static final ConnectorTableMetadata METADATA = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(NAME).column("table_cat", (Type)VarcharType.createUnboundedVarcharType()).column("table_schem", (Type)VarcharType.createUnboundedVarcharType()).column("table_name", (Type)VarcharType.createUnboundedVarcharType()).column("column_name", (Type)VarcharType.createUnboundedVarcharType()).column("data_type", (Type)BigintType.BIGINT).column("type_name", (Type)VarcharType.createUnboundedVarcharType()).column("column_size", (Type)BigintType.BIGINT).column("buffer_length", (Type)BigintType.BIGINT).column("decimal_digits", (Type)BigintType.BIGINT).column("num_prec_radix", (Type)BigintType.BIGINT).column("nullable", (Type)BigintType.BIGINT).column("remarks", (Type)VarcharType.createUnboundedVarcharType()).column("column_def", (Type)VarcharType.createUnboundedVarcharType()).column("sql_data_type", (Type)BigintType.BIGINT).column("sql_datetime_sub", (Type)BigintType.BIGINT).column("char_octet_length", (Type)BigintType.BIGINT).column("ordinal_position", (Type)BigintType.BIGINT).column("is_nullable", (Type)VarcharType.createUnboundedVarcharType()).column("scope_catalog", (Type)VarcharType.createUnboundedVarcharType()).column("scope_schema", (Type)VarcharType.createUnboundedVarcharType()).column("scope_table", (Type)VarcharType.createUnboundedVarcharType()).column("source_data_type", (Type)BigintType.BIGINT).column("is_autoincrement", (Type)VarcharType.createUnboundedVarcharType()).column("is_generatedcolumn", (Type)VarcharType.createUnboundedVarcharType()).build();
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public ColumnJdbcTable(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    @Override
    public TupleDomain<ColumnHandle> applyFilter(ConnectorSession connectorSession, Constraint constraint) {
        TupleDomain tupleDomain = constraint.getSummary();
        if (tupleDomain.isNone() || constraint.predicate().isEmpty()) {
            return tupleDomain;
        }
        Predicate predicate = (Predicate)constraint.predicate().get();
        Set predicateColumns = (Set)constraint.getColumns().orElseThrow(() -> new VerifyException("columns not present for a predicate"));
        boolean hasSchemaPredicate = predicateColumns.contains(TABLE_SCHEMA_COLUMN);
        boolean hasTablePredicate = predicateColumns.contains(TABLE_NAME_COLUMN);
        if (!hasSchemaPredicate && !hasTablePredicate) {
            return tupleDomain;
        }
        Session session = ((FullConnectorSession)connectorSession).getSession();
        Optional<String> catalogFilter = FilterUtil.tryGetSingleVarcharValue(tupleDomain, TABLE_CATALOG_COLUMN);
        Optional<String> schemaFilter = FilterUtil.tryGetSingleVarcharValue(tupleDomain, TABLE_SCHEMA_COLUMN);
        Optional<String> tableFilter = FilterUtil.tryGetSingleVarcharValue(tupleDomain, TABLE_NAME_COLUMN);
        if (schemaFilter.isPresent() && tableFilter.isPresent()) {
            return tupleDomain;
        }
        List catalogs = (List)MetadataListing.listCatalogs(session, this.metadata, this.accessControl, catalogFilter).keySet().stream().filter(catalogName -> predicate.test(ImmutableMap.of((Object)TABLE_CATALOG_COLUMN, (Object)ColumnJdbcTable.toNullableValue(catalogName)))).collect(ImmutableList.toImmutableList());
        List schemas = (List)catalogs.stream().flatMap(catalogName -> MetadataListing.listSchemas(session, this.metadata, this.accessControl, catalogName, schemaFilter).stream().filter(schemaName -> !hasSchemaPredicate || predicate.test(ImmutableMap.of((Object)TABLE_CATALOG_COLUMN, (Object)ColumnJdbcTable.toNullableValue(catalogName), (Object)TABLE_SCHEMA_COLUMN, (Object)ColumnJdbcTable.toNullableValue(schemaName)))).map(schemaName -> new CatalogSchemaName(catalogName, schemaName))).collect(ImmutableList.toImmutableList());
        if (!hasTablePredicate) {
            return TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)TABLE_CATALOG_COLUMN, (Object)schemas.stream().map(CatalogSchemaName::getCatalogName).collect(ColumnJdbcTable.toVarcharDomain()).simplify(100)).put((Object)TABLE_SCHEMA_COLUMN, (Object)schemas.stream().map(CatalogSchemaName::getSchemaName).collect(ColumnJdbcTable.toVarcharDomain()).simplify(100)).build());
        }
        List tables = (List)schemas.stream().flatMap(schema -> {
            QualifiedTablePrefix tablePrefix = tableFilter.isPresent() ? new QualifiedTablePrefix(schema.getCatalogName(), schema.getSchemaName(), (String)tableFilter.get()) : new QualifiedTablePrefix(schema.getCatalogName(), schema.getSchemaName());
            return MetadataListing.listTables(session, this.metadata, this.accessControl, tablePrefix).stream().filter(schemaTableName -> predicate.test(ImmutableMap.of((Object)TABLE_CATALOG_COLUMN, (Object)ColumnJdbcTable.toNullableValue(schema.getCatalogName()), (Object)TABLE_SCHEMA_COLUMN, (Object)ColumnJdbcTable.toNullableValue(schemaTableName.getSchemaName()), (Object)TABLE_NAME_COLUMN, (Object)ColumnJdbcTable.toNullableValue(schemaTableName.getTableName())))).map(schemaTableName -> new CatalogSchemaTableName(schema.getCatalogName(), schemaTableName.getSchemaName(), schemaTableName.getTableName()));
        }).collect(ImmutableList.toImmutableList());
        return TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)TABLE_CATALOG_COLUMN, (Object)tables.stream().map(CatalogSchemaTableName::getCatalogName).collect(ColumnJdbcTable.toVarcharDomain()).simplify(100)).put((Object)TABLE_SCHEMA_COLUMN, (Object)tables.stream().map(catalogSchemaTableName -> catalogSchemaTableName.getSchemaTableName().getSchemaName()).collect(ColumnJdbcTable.toVarcharDomain()).simplify(100)).put((Object)TABLE_NAME_COLUMN, (Object)tables.stream().map(catalogSchemaTableName -> catalogSchemaTableName.getSchemaTableName().getTableName()).collect(ColumnJdbcTable.toVarcharDomain()).simplify(100)).build());
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)METADATA);
        if (constraint.isNone()) {
            return table.build().cursor();
        }
        Session session = ((FullConnectorSession)connectorSession).getSession();
        boolean omitDateTimeTypePrecision = SystemSessionProperties.isOmitDateTimeTypePrecision(session);
        Optional<String> catalogFilter = FilterUtil.tryGetSingleVarcharValue(constraint, 0);
        Optional<String> schemaFilter = FilterUtil.tryGetSingleVarcharValue(constraint, 1);
        Optional<String> tableFilter = FilterUtil.tryGetSingleVarcharValue(constraint, 2);
        Domain catalogDomain = ((Map)constraint.getDomains().get()).getOrDefault(0, Domain.all((Type)VarcharType.createUnboundedVarcharType()));
        Domain schemaDomain = ((Map)constraint.getDomains().get()).getOrDefault(1, Domain.all((Type)VarcharType.createUnboundedVarcharType()));
        Domain tableDomain = ((Map)constraint.getDomains().get()).getOrDefault(2, Domain.all((Type)VarcharType.createUnboundedVarcharType()));
        for (String catalog : MetadataListing.listCatalogs(session, this.metadata, this.accessControl, catalogFilter).keySet()) {
            if (!catalogDomain.includesNullableValue((Object)Slices.utf8Slice((String)catalog))) continue;
            if (schemaDomain.isAll() && tableDomain.isAll() || schemaFilter.isPresent() && tableFilter.isPresent()) {
                QualifiedTablePrefix tablePrefix = FilterUtil.tablePrefix(catalog, schemaFilter, tableFilter);
                Map<SchemaTableName, List<ColumnMetadata>> tableColumns = MetadataListing.listTableColumns(session, this.metadata, this.accessControl, tablePrefix);
                ColumnJdbcTable.addColumnsRow(table, catalog, tableColumns, omitDateTimeTypePrecision);
                continue;
            }
            SortedSet<String> schemas = MetadataListing.listSchemas(session, this.metadata, this.accessControl, catalog, schemaFilter);
            for (String schema : schemas) {
                if (!schemaDomain.includesNullableValue((Object)Slices.utf8Slice((String)schema))) continue;
                QualifiedTablePrefix tablePrefix = tableFilter.isPresent() ? new QualifiedTablePrefix(catalog, schema, tableFilter.get()) : new QualifiedTablePrefix(catalog, schema);
                Set<SchemaTableName> tables = MetadataListing.listTables(session, this.metadata, this.accessControl, tablePrefix);
                for (SchemaTableName schemaTableName : tables) {
                    String tableName = schemaTableName.getTableName();
                    if (!tableDomain.includesNullableValue((Object)Slices.utf8Slice((String)tableName))) continue;
                    Map<SchemaTableName, List<ColumnMetadata>> tableColumns = MetadataListing.listTableColumns(session, this.metadata, this.accessControl, new QualifiedTablePrefix(catalog, schema, tableName));
                    ColumnJdbcTable.addColumnsRow(table, catalog, tableColumns, omitDateTimeTypePrecision);
                }
            }
        }
        return table.build().cursor();
    }

    private static void addColumnsRow(InMemoryRecordSet.Builder builder, String catalog, Map<SchemaTableName, List<ColumnMetadata>> columns, boolean isOmitTimestampPrecision) {
        for (Map.Entry<SchemaTableName, List<ColumnMetadata>> entry : columns.entrySet()) {
            ColumnJdbcTable.addColumnRows(builder, catalog, entry.getKey(), entry.getValue(), isOmitTimestampPrecision);
        }
    }

    private static void addColumnRows(InMemoryRecordSet.Builder builder, String catalog, SchemaTableName tableName, List<ColumnMetadata> columns, boolean isOmitTimestampPrecision) {
        int ordinalPosition = 1;
        for (ColumnMetadata column : columns) {
            if (column.isHidden()) continue;
            builder.addRow(new Object[]{catalog, tableName.getSchemaName(), tableName.getTableName(), column.getName(), ColumnJdbcTable.jdbcDataType(column.getType()), TypeUtils.getDisplayLabel(column.getType(), isOmitTimestampPrecision), ColumnJdbcTable.columnSize(column.getType()), 0, ColumnJdbcTable.decimalDigits(column.getType()), ColumnJdbcTable.numPrecRadix(column.getType()), 2, column.getComment(), null, null, null, ColumnJdbcTable.charOctetLength(column.getType()), ordinalPosition, "", null, null, null, null, null, null});
            ++ordinalPosition;
        }
    }

    static int jdbcDataType(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return 16;
        }
        if (type.equals(BigintType.BIGINT)) {
            return -5;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return 4;
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return 5;
        }
        if (type.equals(TinyintType.TINYINT)) {
            return -6;
        }
        if (type.equals(RealType.REAL)) {
            return 7;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return 8;
        }
        if (type instanceof DecimalType) {
            return 3;
        }
        if (type instanceof VarcharType) {
            return 12;
        }
        if (type instanceof CharType) {
            return 1;
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return -3;
        }
        if (type.equals(TimeType.TIME)) {
            return 92;
        }
        if (type.equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE)) {
            return 2013;
        }
        if (type instanceof TimestampType) {
            return 93;
        }
        if (type instanceof TimestampWithTimeZoneType) {
            return 2014;
        }
        if (type.equals(DateType.DATE)) {
            return 91;
        }
        if (type instanceof ArrayType) {
            return 2003;
        }
        return 2000;
    }

    static Integer columnSize(Type type) {
        if (type.equals(BigintType.BIGINT)) {
            return 19;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return 10;
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return 5;
        }
        if (type.equals(TinyintType.TINYINT)) {
            return 3;
        }
        if (type instanceof DecimalType) {
            return ((DecimalType)type).getPrecision();
        }
        if (type.equals(RealType.REAL)) {
            return 24;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return 53;
        }
        if (type instanceof VarcharType) {
            return ((VarcharType)type).getLength().orElse(Integer.MAX_VALUE);
        }
        if (type instanceof CharType) {
            return ((CharType)type).getLength();
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return Integer.MAX_VALUE;
        }
        if (type instanceof TimeType) {
            int precision = ((TimeType)type).getPrecision();
            return 8 + Math.min(precision, 1) + precision;
        }
        if (type instanceof TimeWithTimeZoneType) {
            int precision = ((TimeWithTimeZoneType)type).getPrecision();
            return 8 + Math.min(precision, 1) + precision + 6;
        }
        if (type.equals(DateType.DATE)) {
            return 14;
        }
        if (type instanceof TimestampType) {
            int precision = ((TimestampType)type).getPrecision();
            return 21 + Math.min(precision, 1) + precision;
        }
        if (type instanceof TimestampWithTimeZoneType) {
            int precision = ((TimestampWithTimeZoneType)type).getPrecision();
            return 22 + Math.min(precision, 1) + precision + 1 + MAX_TIMEZONE_LENGTH;
        }
        return null;
    }

    private static Integer decimalDigits(Type type) {
        if (type instanceof DecimalType) {
            return ((DecimalType)type).getScale();
        }
        return null;
    }

    private static Integer charOctetLength(Type type) {
        if (type instanceof VarcharType) {
            return ((VarcharType)type).getLength().orElse(Integer.MAX_VALUE);
        }
        if (type instanceof CharType) {
            return ((CharType)type).getLength();
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return Integer.MAX_VALUE;
        }
        return null;
    }

    static Integer numPrecRadix(Type type) {
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT) || type instanceof DecimalType) {
            return 10;
        }
        if (type.equals(RealType.REAL) || type.equals(DoubleType.DOUBLE)) {
            return 2;
        }
        return null;
    }

    private static NullableValue toNullableValue(String varcharValue) {
        return NullableValue.of((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)varcharValue));
    }

    private static Collector<String, ?, Domain> toVarcharDomain() {
        return Collectors.collectingAndThen(ImmutableSet.toImmutableSet(), set -> {
            if (set.isEmpty()) {
                return Domain.none((Type)VarcharType.createUnboundedVarcharType());
            }
            return Domain.multipleValues((Type)VarcharType.createUnboundedVarcharType(), (List)((List)set.stream().map(Slices::utf8Slice).collect(ImmutableList.toImmutableList())));
        });
    }
}

