/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.cost;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.graph.Traverser;
import io.prestosql.cost.CostProvider;
import io.prestosql.cost.PlanCostEstimate;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.StatsProvider;
import io.prestosql.execution.StageInfo;
import io.prestosql.sql.planner.PlanFragment;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import java.util.Map;
import java.util.Objects;

public class StatsAndCosts {
    private static final StatsAndCosts EMPTY = new StatsAndCosts((Map<PlanNodeId, PlanNodeStatsEstimate>)ImmutableMap.of(), (Map<PlanNodeId, PlanCostEstimate>)ImmutableMap.of());
    private final Map<PlanNodeId, PlanNodeStatsEstimate> stats;
    private final Map<PlanNodeId, PlanCostEstimate> costs;

    public static StatsAndCosts empty() {
        return EMPTY;
    }

    @JsonCreator
    public StatsAndCosts(@JsonProperty(value="stats") Map<PlanNodeId, PlanNodeStatsEstimate> stats, @JsonProperty(value="costs") Map<PlanNodeId, PlanCostEstimate> costs) {
        this.stats = ImmutableMap.copyOf(Objects.requireNonNull(stats, "stats is null"));
        this.costs = ImmutableMap.copyOf(Objects.requireNonNull(costs, "costs is null"));
    }

    @JsonProperty
    public Map<PlanNodeId, PlanNodeStatsEstimate> getStats() {
        return this.stats;
    }

    @JsonProperty
    public Map<PlanNodeId, PlanCostEstimate> getCosts() {
        return this.costs;
    }

    public StatsAndCosts getForSubplan(PlanNode root) {
        Iterable planIterator = Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)root);
        ImmutableMap.Builder filteredStats = ImmutableMap.builder();
        ImmutableMap.Builder filteredCosts = ImmutableMap.builder();
        for (PlanNode node : planIterator) {
            if (this.stats.containsKey(node.getId())) {
                filteredStats.put((Object)node.getId(), (Object)this.stats.get(node.getId()));
            }
            if (!this.costs.containsKey(node.getId())) continue;
            filteredCosts.put((Object)node.getId(), (Object)this.costs.get(node.getId()));
        }
        return new StatsAndCosts((Map<PlanNodeId, PlanNodeStatsEstimate>)filteredStats.build(), (Map<PlanNodeId, PlanCostEstimate>)filteredCosts.build());
    }

    public static StatsAndCosts create(PlanNode root, StatsProvider statsProvider, CostProvider costProvider) {
        Iterable planIterator = Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)root);
        ImmutableMap.Builder stats = ImmutableMap.builder();
        ImmutableMap.Builder costs = ImmutableMap.builder();
        for (PlanNode node : planIterator) {
            stats.put((Object)node.getId(), (Object)statsProvider.getStats(node));
            costs.put((Object)node.getId(), (Object)costProvider.getCost(node));
        }
        return new StatsAndCosts((Map<PlanNodeId, PlanNodeStatsEstimate>)stats.build(), (Map<PlanNodeId, PlanCostEstimate>)costs.build());
    }

    public static StatsAndCosts create(StageInfo stageInfo) {
        ImmutableMap.Builder planNodeStats = ImmutableMap.builder();
        ImmutableMap.Builder planNodeCosts = ImmutableMap.builder();
        StatsAndCosts.reconstructStatsAndCosts(stageInfo, (ImmutableMap.Builder<PlanNodeId, PlanNodeStatsEstimate>)planNodeStats, (ImmutableMap.Builder<PlanNodeId, PlanCostEstimate>)planNodeCosts);
        return new StatsAndCosts((Map<PlanNodeId, PlanNodeStatsEstimate>)planNodeStats.build(), (Map<PlanNodeId, PlanCostEstimate>)planNodeCosts.build());
    }

    private static void reconstructStatsAndCosts(StageInfo stage, ImmutableMap.Builder<PlanNodeId, PlanNodeStatsEstimate> planNodeStats, ImmutableMap.Builder<PlanNodeId, PlanCostEstimate> planNodeCosts) {
        PlanFragment planFragment = stage.getPlan();
        if (planFragment != null) {
            planNodeStats.putAll(planFragment.getStatsAndCosts().getStats());
            planNodeCosts.putAll(planFragment.getStatsAndCosts().getCosts());
        }
        for (StageInfo subStage : stage.getSubStages()) {
            StatsAndCosts.reconstructStatsAndCosts(subStage, planNodeStats, planNodeCosts);
        }
    }
}

