/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.dispatcher;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import io.prestosql.Session;
import io.prestosql.dispatcher.DispatchExecutor;
import io.prestosql.dispatcher.DispatchQuery;
import io.prestosql.dispatcher.DispatchQueryFactory;
import io.prestosql.dispatcher.LocalDispatchQuery;
import io.prestosql.event.QueryMonitor;
import io.prestosql.execution.ClusterSizeMonitor;
import io.prestosql.execution.LocationFactory;
import io.prestosql.execution.QueryExecution;
import io.prestosql.execution.QueryManager;
import io.prestosql.execution.QueryPreparer;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.execution.warnings.WarningCollectorFactory;
import io.prestosql.metadata.Metadata;
import io.prestosql.security.AccessControl;
import io.prestosql.server.protocol.Slug;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.sql.tree.Statement;
import io.prestosql.transaction.TransactionManager;
import io.prestosql.util.Failures;
import io.prestosql.util.StatementUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.inject.Inject;

public class LocalDispatchQueryFactory
implements DispatchQueryFactory {
    private final QueryManager queryManager;
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final Metadata metadata;
    private final QueryMonitor queryMonitor;
    private final LocationFactory locationFactory;
    private final ClusterSizeMonitor clusterSizeMonitor;
    private final Map<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionFactories;
    private final WarningCollectorFactory warningCollectorFactory;
    private final ListeningExecutorService executor;

    @Inject
    public LocalDispatchQueryFactory(QueryManager queryManager, TransactionManager transactionManager, AccessControl accessControl, Metadata metadata, QueryMonitor queryMonitor, LocationFactory locationFactory, Map<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionFactories, WarningCollectorFactory warningCollectorFactory, ClusterSizeMonitor clusterSizeMonitor, DispatchExecutor dispatchExecutor) {
        this.queryManager = Objects.requireNonNull(queryManager, "queryManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
        this.executionFactories = Objects.requireNonNull(executionFactories, "executionFactories is null");
        this.warningCollectorFactory = Objects.requireNonNull(warningCollectorFactory, "warningCollectorFactory is null");
        this.clusterSizeMonitor = Objects.requireNonNull(clusterSizeMonitor, "clusterSizeMonitor is null");
        this.executor = Objects.requireNonNull(dispatchExecutor, "executorService is null").getExecutor();
    }

    @Override
    public DispatchQuery createDispatchQuery(Session session, String query, QueryPreparer.PreparedQuery preparedQuery, Slug slug, ResourceGroupId resourceGroup) {
        WarningCollector warningCollector = this.warningCollectorFactory.create();
        QueryStateMachine stateMachine = QueryStateMachine.begin(query, preparedQuery.getPrepareSql(), session, this.locationFactory.createQueryLocation(session.getQueryId()), resourceGroup, StatementUtils.isTransactionControlStatement(preparedQuery.getStatement()), this.transactionManager, this.accessControl, (Executor)this.executor, this.metadata, warningCollector, StatementUtils.getQueryType(preparedQuery.getStatement().getClass()));
        this.queryMonitor.queryCreatedEvent(stateMachine.getBasicQueryInfo(Optional.empty()));
        ListenableFuture queryExecutionFuture = this.executor.submit(() -> {
            QueryExecution.QueryExecutionFactory<?> queryExecutionFactory = this.executionFactories.get(preparedQuery.getStatement().getClass());
            if (queryExecutionFactory == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported statement type: " + preparedQuery.getStatement().getClass().getSimpleName());
            }
            try {
                return queryExecutionFactory.createQueryExecution(preparedQuery, stateMachine, slug, warningCollector);
            }
            catch (Throwable e) {
                stateMachine.transitionToFailed(e);
                this.queryMonitor.queryImmediateFailureEvent(stateMachine.getBasicQueryInfo(Optional.empty()), Failures.toFailure(e));
                throw e;
            }
        });
        return new LocalDispatchQuery(stateMachine, (ListenableFuture<QueryExecution>)queryExecutionFuture, this.clusterSizeMonitor, (Executor)this.executor, this.queryManager::createQuery);
    }
}

