/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.tree.Comment;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CommentTask
implements DataDefinitionTask<Comment> {
    @Override
    public String getName() {
        return "COMMENT";
    }

    @Override
    public ListenableFuture<?> execute(Comment statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        if (statement.getType() == Comment.Type.TABLE) {
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
            Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName);
            if (tableHandle.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table does not exist: %s", tableName);
            }
            accessControl.checkCanSetTableComment(session.toSecurityContext(), tableName);
            metadata.setTableComment(session, tableHandle.get(), statement.getComment());
        } else if (statement.getType() == Comment.Type.COLUMN) {
            Optional prefix = statement.getName().getPrefix();
            if (prefix.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_TABLE, (Node)statement, "Table must be specified", new Object[0]);
            }
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, (QualifiedName)prefix.get());
            Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName);
            if (tableHandle.isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table does not exist: " + tableName, new Object[0]);
            }
            String columnName = statement.getName().getSuffix();
            Map<String, ColumnHandle> columnHandles = metadata.getColumnHandles(session, tableHandle.get());
            if (!columnHandles.containsKey(columnName)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.COLUMN_NOT_FOUND, (Node)statement, "Column does not exist: " + columnName, new Object[0]);
            }
            accessControl.checkCanSetColumnComment(session.toSecurityContext(), tableName);
            metadata.setColumnComment(session, tableHandle.get(), columnHandles.get(columnName), statement.getComment());
        } else {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Unsupported comment type: %s", statement.getType());
        }
        return Futures.immediateFuture(null);
    }
}

