/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorMaterializedViewDefinition;
import io.prestosql.sql.NodeUtils;
import io.prestosql.sql.ParameterUtils;
import io.prestosql.sql.SqlFormatterUtil;
import io.prestosql.sql.analyzer.Analysis;
import io.prestosql.sql.analyzer.Analyzer;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.tree.CreateMaterializedView;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.Parameter;
import io.prestosql.sql.tree.Statement;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class CreateMaterializedViewTask
implements DataDefinitionTask<CreateMaterializedView> {
    private final SqlParser sqlParser;

    @Inject
    public CreateMaterializedViewTask(SqlParser sqlParser, FeaturesConfig featuresConfig) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        Objects.requireNonNull(featuresConfig, "featuresConfig is null");
    }

    @Override
    public String getName() {
        return "CREATE MATERIALIZED VIEW";
    }

    @Override
    public String explain(CreateMaterializedView statement, List<Expression> parameters) {
        return "CREATE MATERIALIZED VIEW " + statement.getName();
    }

    @Override
    public ListenableFuture<?> execute(CreateMaterializedView statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        QualifiedObjectName name = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        Map<NodeRef<Parameter>, Expression> parameterLookup = ParameterUtils.parameterExtractor((Statement)statement, parameters);
        String sql = SqlFormatterUtil.getFormattedSql((Statement)statement.getQuery(), this.sqlParser);
        Analysis analysis = this.analyzeStatement((Statement)statement, session, metadata, accessControl, parameters, parameterLookup, stateMachine.getWarningCollector());
        List columns = (List)analysis.getOutputDescriptor((Node)statement.getQuery()).getVisibleFields().stream().map(field -> new ConnectorMaterializedViewDefinition.Column(field.getName().get(), field.getType().getTypeId())).collect(ImmutableList.toImmutableList());
        Optional<String> owner = Optional.of(session.getUser());
        CatalogName catalogName = metadata.getCatalogHandle(session, name.getCatalogName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + name.getCatalogName()));
        Map<String, Expression> sqlProperties = NodeUtils.mapFromProperties(statement.getProperties());
        Map<String, Object> properties = metadata.getTablePropertyManager().getProperties(catalogName, name.getCatalogName(), sqlProperties, session, metadata, accessControl, parameterLookup);
        ConnectorMaterializedViewDefinition definition = new ConnectorMaterializedViewDefinition(sql, null, session.getCatalog(), session.getSchema(), columns, statement.getComment(), owner, properties);
        metadata.createMaterializedView(session, name, definition, statement.isReplace(), statement.isNotExists());
        return Futures.immediateFuture(null);
    }

    private Analysis analyzeStatement(Statement statement, Session session, Metadata metadata, AccessControl accessControl, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, WarningCollector warningCollector) {
        Analyzer analyzer = new Analyzer(session, metadata, this.sqlParser, accessControl, Optional.empty(), parameters, parameterLookup, warningCollector);
        return analyzer.analyze(statement);
    }
}

