/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.execution.BasicStageStats;
import io.prestosql.execution.ExecutionFailureInfo;
import io.prestosql.execution.Input;
import io.prestosql.execution.QueryExecution;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryState;
import io.prestosql.execution.QueryStateTimer;
import io.prestosql.execution.QueryStats;
import io.prestosql.execution.StageInfo;
import io.prestosql.execution.StageState;
import io.prestosql.execution.StageStats;
import io.prestosql.execution.StateMachine;
import io.prestosql.execution.TableInfo;
import io.prestosql.execution.TaskInfo;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.memory.LocalMemoryManager;
import io.prestosql.memory.VersionedMemoryPoolId;
import io.prestosql.metadata.Metadata;
import io.prestosql.operator.BlockedReason;
import io.prestosql.operator.OperatorStats;
import io.prestosql.security.AccessControl;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.server.BasicQueryStats;
import io.prestosql.server.DynamicFilterService;
import io.prestosql.spi.ErrorCode;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.eventlistener.RoutineInfo;
import io.prestosql.spi.eventlistener.StageGcStatistics;
import io.prestosql.spi.resourcegroups.QueryType;
import io.prestosql.spi.resourcegroups.ResourceGroupId;
import io.prestosql.spi.security.SelectedRole;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.Output;
import io.prestosql.sql.planner.PlanFragment;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.transaction.TransactionId;
import io.prestosql.transaction.TransactionManager;
import io.prestosql.util.Failures;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;

@ThreadSafe
public class QueryStateMachine {
    private static final Logger QUERY_STATE_LOG = Logger.get(QueryStateMachine.class);
    private final QueryId queryId;
    private final String query;
    private final Optional<String> preparedQuery;
    private final Session session;
    private final URI self;
    private final ResourceGroupId resourceGroup;
    private final TransactionManager transactionManager;
    private final Metadata metadata;
    private final QueryOutputManager outputManager;
    private final AtomicReference<VersionedMemoryPoolId> memoryPool = new AtomicReference<VersionedMemoryPoolId>(new VersionedMemoryPoolId(LocalMemoryManager.GENERAL_POOL, 0L));
    private final AtomicLong currentUserMemory = new AtomicLong();
    private final AtomicLong peakUserMemory = new AtomicLong();
    private final AtomicLong currentRevocableMemory = new AtomicLong();
    private final AtomicLong peakRevocableMemory = new AtomicLong();
    private final AtomicLong peakNonRevocableMemory = new AtomicLong();
    private final AtomicLong currentTotalMemory = new AtomicLong();
    private final AtomicLong peakTotalMemory = new AtomicLong();
    private final AtomicLong peakTaskUserMemory = new AtomicLong();
    private final AtomicLong peakTaskRevocableMemory = new AtomicLong();
    private final AtomicLong peakTaskTotalMemory = new AtomicLong();
    private final QueryStateTimer queryStateTimer;
    private final StateMachine<QueryState> queryState;
    private final AtomicBoolean queryCleanedUp = new AtomicBoolean();
    private final AtomicReference<String> setCatalog = new AtomicReference();
    private final AtomicReference<String> setSchema = new AtomicReference();
    private final AtomicReference<String> setPath = new AtomicReference();
    private final Map<String, String> setSessionProperties = new ConcurrentHashMap<String, String>();
    private final Set<String> resetSessionProperties = Sets.newConcurrentHashSet();
    private final Map<String, SelectedRole> setRoles = new ConcurrentHashMap<String, SelectedRole>();
    private final Map<String, String> addedPreparedStatements = new ConcurrentHashMap<String, String>();
    private final Set<String> deallocatedPreparedStatements = Sets.newConcurrentHashSet();
    private final AtomicReference<TransactionId> startedTransactionId = new AtomicReference();
    private final AtomicBoolean clearTransactionId = new AtomicBoolean();
    private final AtomicReference<String> updateType = new AtomicReference();
    private final AtomicReference<ExecutionFailureInfo> failureCause = new AtomicReference();
    private final AtomicReference<Set<Input>> inputs = new AtomicReference<ImmutableSet>(ImmutableSet.of());
    private final AtomicReference<Optional<Output>> output = new AtomicReference(Optional.empty());
    private final AtomicReference<List<io.prestosql.spi.eventlistener.TableInfo>> referencedTables = new AtomicReference<ImmutableList>(ImmutableList.of());
    private final AtomicReference<List<RoutineInfo>> routines = new AtomicReference<ImmutableList>(ImmutableList.of());
    private final StateMachine<Optional<QueryInfo>> finalQueryInfo;
    private final WarningCollector warningCollector;
    private final Optional<QueryType> queryType;
    @GuardedBy(value="dynamicFiltersStatsSupplierLock")
    private Supplier<DynamicFilterService.DynamicFiltersStats> dynamicFiltersStatsSupplier = () -> DynamicFilterService.DynamicFiltersStats.EMPTY;
    private final Object dynamicFiltersStatsSupplierLock = new Object();

    private QueryStateMachine(String query, Optional<String> preparedQuery, Session session, URI self, ResourceGroupId resourceGroup, TransactionManager transactionManager, Executor executor, Ticker ticker, Metadata metadata, WarningCollector warningCollector, Optional<QueryType> queryType) {
        this.query = Objects.requireNonNull(query, "query is null");
        this.preparedQuery = Objects.requireNonNull(preparedQuery, "preparedQuery is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.queryId = session.getQueryId();
        this.self = Objects.requireNonNull(self, "self is null");
        this.resourceGroup = Objects.requireNonNull(resourceGroup, "resourceGroup is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.queryStateTimer = new QueryStateTimer(ticker);
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.queryState = new StateMachine<QueryState>("query " + query, executor, QueryState.QUEUED, QueryState.TERMINAL_QUERY_STATES);
        this.finalQueryInfo = new StateMachine("finalQueryInfo-" + this.queryId, executor, Optional.empty());
        this.outputManager = new QueryOutputManager(executor);
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.queryType = Objects.requireNonNull(queryType, "queryType is null");
    }

    public static QueryStateMachine begin(String query, Optional<String> preparedQuery, Session session, URI self, ResourceGroupId resourceGroup, boolean transactionControl, TransactionManager transactionManager, AccessControl accessControl, Executor executor, Metadata metadata, WarningCollector warningCollector, Optional<QueryType> queryType) {
        return QueryStateMachine.beginWithTicker(query, preparedQuery, session, self, resourceGroup, transactionControl, transactionManager, accessControl, executor, Ticker.systemTicker(), metadata, warningCollector, queryType);
    }

    static QueryStateMachine beginWithTicker(String query, Optional<String> preparedQuery, Session session, URI self, ResourceGroupId resourceGroup, boolean transactionControl, TransactionManager transactionManager, AccessControl accessControl, Executor executor, Ticker ticker, Metadata metadata, WarningCollector warningCollector, Optional<QueryType> queryType) {
        if (session.getTransactionId().isEmpty() && !transactionControl) {
            TransactionId transactionId = transactionManager.beginTransaction(true);
            session = session.beginTransactionId(transactionId, transactionManager, accessControl);
        }
        QueryStateMachine queryStateMachine = new QueryStateMachine(query, preparedQuery, session, self, resourceGroup, transactionManager, executor, ticker, metadata, warningCollector, queryType);
        queryStateMachine.addStateChangeListener(newState -> QUERY_STATE_LOG.debug("Query %s is %s", new Object[]{queryStateMachine.getQueryId(), newState}));
        return queryStateMachine;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public Session getSession() {
        return this.session;
    }

    public long getPeakUserMemoryInBytes() {
        return this.peakUserMemory.get();
    }

    public long getPeakRevocableMemoryInBytes() {
        return this.peakRevocableMemory.get();
    }

    public long getPeakNonRevocableMemoryInBytes() {
        return this.peakNonRevocableMemory.get();
    }

    public long getPeakTotalMemoryInBytes() {
        return this.peakTotalMemory.get();
    }

    public long getPeakTaskUserMemory() {
        return this.peakTaskUserMemory.get();
    }

    public long getPeakTaskRevocableMemory() {
        return this.peakTaskRevocableMemory.get();
    }

    public long getPeakTaskTotalMemory() {
        return this.peakTaskTotalMemory.get();
    }

    public WarningCollector getWarningCollector() {
        return this.warningCollector;
    }

    public void updateMemoryUsage(long deltaUserMemoryInBytes, long deltaRevocableMemoryInBytes, long deltaTotalMemoryInBytes, long taskUserMemoryInBytes, long taskRevocableMemoryInBytes, long taskTotalMemoryInBytes) {
        this.currentUserMemory.addAndGet(deltaUserMemoryInBytes);
        this.currentRevocableMemory.addAndGet(deltaRevocableMemoryInBytes);
        this.currentTotalMemory.addAndGet(deltaTotalMemoryInBytes);
        this.peakUserMemory.updateAndGet(currentPeakValue -> Math.max(this.currentUserMemory.get(), currentPeakValue));
        this.peakRevocableMemory.updateAndGet(currentPeakValue -> Math.max(this.currentRevocableMemory.get(), currentPeakValue));
        this.peakNonRevocableMemory.updateAndGet(currentPeakValue -> Math.max(this.currentTotalMemory.get() - this.currentRevocableMemory.get(), currentPeakValue));
        this.peakTotalMemory.updateAndGet(currentPeakValue -> Math.max(this.currentTotalMemory.get(), currentPeakValue));
        this.peakTaskUserMemory.accumulateAndGet(taskUserMemoryInBytes, Math::max);
        this.peakTaskRevocableMemory.accumulateAndGet(taskRevocableMemoryInBytes, Math::max);
        this.peakTaskTotalMemory.accumulateAndGet(taskTotalMemoryInBytes, Math::max);
    }

    public BasicQueryInfo getBasicQueryInfo(Optional<BasicStageStats> rootStage) {
        ExecutionFailureInfo failureCause;
        QueryState state = this.queryState.get();
        ErrorCode errorCode = null;
        if (state == QueryState.FAILED && (failureCause = this.failureCause.get()) != null) {
            errorCode = failureCause.getErrorCode();
        }
        BasicStageStats stageStats = rootStage.orElse(BasicStageStats.EMPTY_STAGE_STATS);
        BasicQueryStats queryStats = new BasicQueryStats(this.queryStateTimer.getCreateTime(), this.getEndTime().orElse(null), this.queryStateTimer.getQueuedTime(), this.queryStateTimer.getElapsedTime(), this.queryStateTimer.getExecutionTime(), stageStats.getTotalDrivers(), stageStats.getQueuedDrivers(), stageStats.getRunningDrivers(), stageStats.getCompletedDrivers(), stageStats.getRawInputDataSize(), stageStats.getRawInputPositions(), stageStats.getPhysicalInputDataSize(), stageStats.getCumulativeUserMemory(), stageStats.getUserMemoryReservation(), stageStats.getTotalMemoryReservation(), DataSize.succinctBytes((long)this.getPeakUserMemoryInBytes()), DataSize.succinctBytes((long)this.getPeakTotalMemoryInBytes()), stageStats.getTotalCpuTime(), stageStats.getTotalScheduledTime(), stageStats.isFullyBlocked(), stageStats.getBlockedReasons(), stageStats.getProgressPercentage());
        return new BasicQueryInfo(this.queryId, this.session.toSessionRepresentation(), Optional.of(this.resourceGroup), state, this.memoryPool.get().getId(), stageStats.isScheduled(), this.self, this.query, Optional.ofNullable(this.updateType.get()), this.preparedQuery, queryStats, errorCode == null ? null : errorCode.getType(), errorCode, this.queryType);
    }

    @VisibleForTesting
    QueryInfo getQueryInfo(Optional<StageInfo> rootStage) {
        QueryState state = this.queryState.get();
        ExecutionFailureInfo failureCause = null;
        ErrorCode errorCode = null;
        if (state == QueryState.FAILED && (failureCause = this.failureCause.get()) != null) {
            errorCode = failureCause.getErrorCode();
        }
        boolean completeInfo = StageInfo.getAllStages(rootStage).stream().allMatch(StageInfo::isCompleteInfo);
        boolean isScheduled = QueryStateMachine.isScheduled(rootStage);
        return new QueryInfo(this.queryId, this.session.toSessionRepresentation(), state, this.memoryPool.get().getId(), isScheduled, this.self, this.outputManager.getQueryOutputInfo().map(QueryExecution.QueryOutputInfo::getColumnNames).orElse((List)ImmutableList.of()), this.query, this.preparedQuery, this.getQueryStats(rootStage), Optional.ofNullable(this.setCatalog.get()), Optional.ofNullable(this.setSchema.get()), Optional.ofNullable(this.setPath.get()), this.setSessionProperties, this.resetSessionProperties, this.setRoles, this.addedPreparedStatements, this.deallocatedPreparedStatements, Optional.ofNullable(this.startedTransactionId.get()), this.clearTransactionId.get(), this.updateType.get(), rootStage, failureCause, errorCode, this.warningCollector.getWarnings(), this.inputs.get(), this.output.get(), this.referencedTables.get(), this.routines.get(), completeInfo, Optional.of(this.resourceGroup), this.queryType);
    }

    private QueryStats getQueryStats(Optional<StageInfo> rootStage) {
        int totalTasks = 0;
        int runningTasks = 0;
        int completedTasks = 0;
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int runningDrivers = 0;
        int blockedDrivers = 0;
        int completedDrivers = 0;
        long cumulativeUserMemory = 0L;
        long userMemoryReservation = 0L;
        long revocableMemoryReservation = 0L;
        long totalMemoryReservation = 0L;
        long totalScheduledTime = 0L;
        long totalCpuTime = 0L;
        long totalBlockedTime = 0L;
        long physicalInputDataSize = 0L;
        long physicalInputPositions = 0L;
        long physicalInputReadTime = 0L;
        long internalNetworkInputDataSize = 0L;
        long internalNetworkInputPositions = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        long processedInputDataSize = 0L;
        long processedInputPositions = 0L;
        long outputDataSize = 0L;
        long outputPositions = 0L;
        long physicalWrittenDataSize = 0L;
        ImmutableList.Builder stageGcStatistics = ImmutableList.builder();
        boolean fullyBlocked = rootStage.isPresent();
        HashSet<BlockedReason> blockedReasons = new HashSet<BlockedReason>();
        ImmutableList.Builder operatorStatsSummary = ImmutableList.builder();
        boolean completeInfo = true;
        for (StageInfo stageInfo : StageInfo.getAllStages(rootStage)) {
            StageStats stageStats = stageInfo.getStageStats();
            totalTasks += stageStats.getTotalTasks();
            runningTasks += stageStats.getRunningTasks();
            completedTasks += stageStats.getCompletedTasks();
            totalDrivers += stageStats.getTotalDrivers();
            queuedDrivers += stageStats.getQueuedDrivers();
            runningDrivers += stageStats.getRunningDrivers();
            blockedDrivers += stageStats.getBlockedDrivers();
            completedDrivers += stageStats.getCompletedDrivers();
            cumulativeUserMemory = (long)((double)cumulativeUserMemory + stageStats.getCumulativeUserMemory());
            userMemoryReservation += stageStats.getUserMemoryReservation().toBytes();
            revocableMemoryReservation += stageStats.getRevocableMemoryReservation().toBytes();
            totalMemoryReservation += stageStats.getTotalMemoryReservation().toBytes();
            totalScheduledTime += stageStats.getTotalScheduledTime().roundTo(TimeUnit.MILLISECONDS);
            totalCpuTime += stageStats.getTotalCpuTime().roundTo(TimeUnit.MILLISECONDS);
            totalBlockedTime += stageStats.getTotalBlockedTime().roundTo(TimeUnit.MILLISECONDS);
            if (!stageInfo.getState().isDone()) {
                fullyBlocked &= stageStats.isFullyBlocked();
                blockedReasons.addAll(stageStats.getBlockedReasons());
            }
            physicalInputDataSize += stageStats.getPhysicalInputDataSize().toBytes();
            physicalInputPositions += stageStats.getPhysicalInputPositions();
            physicalInputReadTime += stageStats.getPhysicalInputReadTime().roundTo(TimeUnit.MILLISECONDS);
            internalNetworkInputDataSize += stageStats.getInternalNetworkInputDataSize().toBytes();
            internalNetworkInputPositions += stageStats.getInternalNetworkInputPositions();
            PlanFragment plan = stageInfo.getPlan();
            if (plan != null) {
                if (plan.getPartitionedSourceNodes().stream().anyMatch(TableScanNode.class::isInstance)) {
                    rawInputDataSize += stageStats.getRawInputDataSize().toBytes();
                    rawInputPositions += stageStats.getRawInputPositions();
                    processedInputDataSize += stageStats.getProcessedInputDataSize().toBytes();
                    processedInputPositions += stageStats.getProcessedInputPositions();
                }
            }
            physicalWrittenDataSize += stageStats.getPhysicalWrittenDataSize().toBytes();
            stageGcStatistics.add((Object)stageStats.getGcInfo());
            completeInfo = completeInfo && stageInfo.isCompleteInfo();
            operatorStatsSummary.addAll(stageInfo.getStageStats().getOperatorSummaries());
        }
        if (rootStage.isPresent()) {
            StageStats outputStageStats = rootStage.get().getStageStats();
            outputDataSize += outputStageStats.getOutputDataSize().toBytes();
            outputPositions += outputStageStats.getOutputPositions();
        }
        boolean isScheduled = QueryStateMachine.isScheduled(rootStage);
        return new QueryStats(this.queryStateTimer.getCreateTime(), this.getExecutionStartTime().orElse(null), this.getLastHeartbeat(), this.getEndTime().orElse(null), this.queryStateTimer.getElapsedTime(), this.queryStateTimer.getQueuedTime(), this.queryStateTimer.getResourceWaitingTime(), this.queryStateTimer.getDispatchingTime(), this.queryStateTimer.getExecutionTime(), this.queryStateTimer.getAnalysisTime(), this.queryStateTimer.getPlanningTime(), this.queryStateTimer.getFinishingTime(), totalTasks, runningTasks, completedTasks, totalDrivers, queuedDrivers, runningDrivers, blockedDrivers, completedDrivers, cumulativeUserMemory, DataSize.succinctBytes((long)userMemoryReservation), DataSize.succinctBytes((long)revocableMemoryReservation), DataSize.succinctBytes((long)totalMemoryReservation), DataSize.succinctBytes((long)this.getPeakUserMemoryInBytes()), DataSize.succinctBytes((long)this.getPeakRevocableMemoryInBytes()), DataSize.succinctBytes((long)this.getPeakNonRevocableMemoryInBytes()), DataSize.succinctBytes((long)this.getPeakTotalMemoryInBytes()), DataSize.succinctBytes((long)this.getPeakTaskUserMemory()), DataSize.succinctBytes((long)this.getPeakTaskRevocableMemory()), DataSize.succinctBytes((long)this.getPeakTaskTotalMemory()), isScheduled, new Duration((double)totalScheduledTime, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalCpuTime, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit(), new Duration((double)totalBlockedTime, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit(), fullyBlocked, blockedReasons, DataSize.succinctBytes((long)physicalInputDataSize), physicalInputPositions, new Duration((double)physicalInputReadTime, TimeUnit.MILLISECONDS).convertToMostSuccinctTimeUnit(), DataSize.succinctBytes((long)internalNetworkInputDataSize), internalNetworkInputPositions, DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, DataSize.succinctBytes((long)processedInputDataSize), processedInputPositions, DataSize.succinctBytes((long)outputDataSize), outputPositions, DataSize.succinctBytes((long)physicalWrittenDataSize), (List<StageGcStatistics>)stageGcStatistics.build(), this.getDynamicFiltersStats(), (List<OperatorStats>)operatorStatsSummary.build());
    }

    public VersionedMemoryPoolId getMemoryPool() {
        return this.memoryPool.get();
    }

    public void setMemoryPool(VersionedMemoryPoolId memoryPool) {
        this.memoryPool.set(Objects.requireNonNull(memoryPool, "memoryPool is null"));
    }

    public void addOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
        this.outputManager.addOutputInfoListener(listener);
    }

    public void setColumns(List<String> columnNames, List<Type> columnTypes) {
        this.outputManager.setColumns(columnNames, columnTypes);
    }

    public void updateOutputLocations(Set<URI> newExchangeLocations, boolean noMoreExchangeLocations) {
        this.outputManager.updateOutputLocations(newExchangeLocations, noMoreExchangeLocations);
    }

    public void setInputs(List<Input> inputs) {
        Objects.requireNonNull(inputs, "inputs is null");
        this.inputs.set((Set<Input>)ImmutableSet.copyOf(inputs));
    }

    public void setOutput(Optional<Output> output) {
        Objects.requireNonNull(output, "output is null");
        this.output.set(output);
    }

    public void setReferencedTables(List<io.prestosql.spi.eventlistener.TableInfo> tables) {
        Objects.requireNonNull(tables, "tables is null");
        this.referencedTables.set((List<io.prestosql.spi.eventlistener.TableInfo>)ImmutableList.copyOf(tables));
    }

    public void setRoutines(List<RoutineInfo> routines) {
        Objects.requireNonNull(routines, "routines is null");
        this.routines.set((List<RoutineInfo>)ImmutableList.copyOf(routines));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicFilterService.DynamicFiltersStats getDynamicFiltersStats() {
        Object object = this.dynamicFiltersStatsSupplierLock;
        synchronized (object) {
            return this.dynamicFiltersStatsSupplier.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDynamicFiltersStatsSupplier(Supplier<DynamicFilterService.DynamicFiltersStats> dynamicFiltersStatsSupplier) {
        Object object = this.dynamicFiltersStatsSupplierLock;
        synchronized (object) {
            this.dynamicFiltersStatsSupplier = Objects.requireNonNull(dynamicFiltersStatsSupplier, "dynamicFiltersStatsSupplier is null");
        }
    }

    public Map<String, String> getSetSessionProperties() {
        return this.setSessionProperties;
    }

    public void setSetCatalog(String catalog) {
        this.setCatalog.set(Objects.requireNonNull(catalog, "catalog is null"));
    }

    public void setSetSchema(String schema) {
        this.setSchema.set(Objects.requireNonNull(schema, "schema is null"));
    }

    public void setSetPath(String path) {
        Objects.requireNonNull(path, "path is null");
        this.setPath.set(path);
    }

    public String getSetPath() {
        return this.setPath.get();
    }

    public void addSetSessionProperties(String key, String value) {
        this.setSessionProperties.put(Objects.requireNonNull(key, "key is null"), Objects.requireNonNull(value, "value is null"));
    }

    public void addSetRole(String catalog, SelectedRole role) {
        this.setRoles.put(Objects.requireNonNull(catalog, "catalog is null"), Objects.requireNonNull(role, "role is null"));
    }

    public Set<String> getResetSessionProperties() {
        return this.resetSessionProperties;
    }

    public void addResetSessionProperties(String name) {
        this.resetSessionProperties.add(Objects.requireNonNull(name, "name is null"));
    }

    public Map<String, String> getAddedPreparedStatements() {
        return this.addedPreparedStatements;
    }

    public Set<String> getDeallocatedPreparedStatements() {
        return this.deallocatedPreparedStatements;
    }

    public void addPreparedStatement(String key, String value) {
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(value, "value is null");
        this.addedPreparedStatements.put(key, value);
    }

    public void removePreparedStatement(String key) {
        Objects.requireNonNull(key, "key is null");
        if (!this.session.getPreparedStatements().containsKey(key)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Prepared statement not found: " + key);
        }
        this.deallocatedPreparedStatements.add(key);
    }

    public void setStartedTransactionId(TransactionId startedTransactionId) {
        Preconditions.checkArgument((!this.clearTransactionId.get() ? 1 : 0) != 0, (Object)"Cannot start and clear transaction ID in the same request");
        this.startedTransactionId.set(startedTransactionId);
    }

    public void clearTransactionId() {
        Preconditions.checkArgument((this.startedTransactionId.get() == null ? 1 : 0) != 0, (Object)"Cannot start and clear transaction ID in the same request");
        this.clearTransactionId.set(true);
    }

    public void setUpdateType(String updateType) {
        this.updateType.set(updateType);
    }

    public QueryState getQueryState() {
        return this.queryState.get();
    }

    public boolean isDone() {
        return this.queryState.get().isDone();
    }

    public boolean transitionToWaitingForResources() {
        this.queryStateTimer.beginWaitingForResources();
        return this.queryState.setIf(QueryState.WAITING_FOR_RESOURCES, currentState -> currentState.ordinal() < QueryState.WAITING_FOR_RESOURCES.ordinal());
    }

    public boolean transitionToDispatching() {
        this.queryStateTimer.beginDispatching();
        return this.queryState.setIf(QueryState.DISPATCHING, currentState -> currentState.ordinal() < QueryState.DISPATCHING.ordinal());
    }

    public boolean transitionToPlanning() {
        this.queryStateTimer.beginPlanning();
        return this.queryState.setIf(QueryState.PLANNING, currentState -> currentState.ordinal() < QueryState.PLANNING.ordinal());
    }

    public boolean transitionToStarting() {
        this.queryStateTimer.beginStarting();
        return this.queryState.setIf(QueryState.STARTING, currentState -> currentState.ordinal() < QueryState.STARTING.ordinal());
    }

    public boolean transitionToRunning() {
        this.queryStateTimer.beginRunning();
        return this.queryState.setIf(QueryState.RUNNING, currentState -> currentState.ordinal() < QueryState.RUNNING.ordinal());
    }

    public boolean transitionToFinishing() {
        this.queryStateTimer.beginFinishing();
        if (!this.queryState.setIf(QueryState.FINISHING, currentState -> currentState != QueryState.FINISHING && !currentState.isDone())) {
            return false;
        }
        try {
            this.cleanupQuery();
        }
        catch (Exception e) {
            this.transitionToFailed(e);
            return true;
        }
        Optional<TransactionId> transactionId = this.session.getTransactionId();
        if (transactionId.isPresent() && this.transactionManager.transactionExists(transactionId.get()) && this.transactionManager.isAutoCommit(transactionId.get())) {
            ListenableFuture<?> commitFuture = this.transactionManager.asyncCommit(transactionId.get());
            Futures.addCallback(commitFuture, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(@Nullable Object result) {
                    QueryStateMachine.this.transitionToFinished();
                }

                public void onFailure(Throwable throwable) {
                    QueryStateMachine.this.transitionToFailed(throwable);
                }
            }, (Executor)MoreExecutors.directExecutor());
        } else {
            this.transitionToFinished();
        }
        return true;
    }

    private void transitionToFinished() {
        this.queryStateTimer.endQuery();
        this.queryState.setIf(QueryState.FINISHED, currentState -> !currentState.isDone());
    }

    public boolean transitionToFailed(Throwable throwable) {
        this.cleanupQueryQuietly();
        this.queryStateTimer.endQuery();
        Objects.requireNonNull(throwable, "throwable is null");
        this.failureCause.compareAndSet(null, Failures.toFailure(throwable));
        QueryState oldState = this.queryState.trySet(QueryState.FAILED);
        if (oldState.isDone()) {
            QUERY_STATE_LOG.debug(throwable, "Failure after query %s finished", new Object[]{this.queryId});
            return false;
        }
        try {
            QUERY_STATE_LOG.debug(throwable, "Query %s failed", new Object[]{this.queryId});
            this.session.getTransactionId().ifPresent(transactionId -> {
                try {
                    if (this.transactionManager.transactionExists((TransactionId)transactionId) && this.transactionManager.isAutoCommit((TransactionId)transactionId)) {
                        this.transactionManager.asyncAbort((TransactionId)transactionId);
                        return;
                    }
                }
                catch (RuntimeException e) {
                    QUERY_STATE_LOG.error((Throwable)e, "Error aborting transaction for failed query. Transaction will be failed directly");
                }
                this.transactionManager.fail((TransactionId)transactionId);
            });
        }
        finally {
            if (oldState.ordinal() <= QueryState.PLANNING.ordinal()) {
                this.finalQueryInfo.compareAndSet(Optional.empty(), Optional.of(this.getQueryInfo(Optional.empty())));
            }
        }
        return true;
    }

    public boolean transitionToCanceled() {
        this.cleanupQueryQuietly();
        this.queryStateTimer.endQuery();
        this.failureCause.compareAndSet(null, Failures.toFailure(new PrestoException((ErrorCodeSupplier)StandardErrorCode.USER_CANCELED, "Query was canceled")));
        boolean canceled = this.queryState.setIf(QueryState.FAILED, currentState -> !currentState.isDone());
        if (canceled) {
            this.session.getTransactionId().ifPresent(transactionId -> {
                if (this.transactionManager.isAutoCommit((TransactionId)transactionId)) {
                    this.transactionManager.asyncAbort((TransactionId)transactionId);
                } else {
                    this.transactionManager.fail((TransactionId)transactionId);
                }
            });
        }
        return canceled;
    }

    private void cleanupQuery() {
        if (this.queryCleanedUp.compareAndSet(false, true)) {
            this.metadata.cleanupQuery(this.session);
        }
    }

    private void cleanupQueryQuietly() {
        try {
            this.cleanupQuery();
        }
        catch (Throwable t) {
            QUERY_STATE_LOG.error("Error cleaning up query: %s", new Object[]{t});
        }
    }

    public void addStateChangeListener(StateMachine.StateChangeListener<QueryState> stateChangeListener) {
        this.queryState.addStateChangeListener(stateChangeListener);
    }

    public void addQueryInfoStateChangeListener(StateMachine.StateChangeListener<QueryInfo> stateChangeListener) {
        AtomicBoolean done = new AtomicBoolean();
        StateMachine.StateChangeListener<Optional> fireOnceStateChangeListener = finalQueryInfo -> {
            if (finalQueryInfo.isPresent() && done.compareAndSet(false, true)) {
                stateChangeListener.stateChanged((QueryInfo)finalQueryInfo.get());
            }
        };
        this.finalQueryInfo.addStateChangeListener(fireOnceStateChangeListener);
    }

    public ListenableFuture<QueryState> getStateChange(QueryState currentState) {
        return this.queryState.getStateChange(currentState);
    }

    public void recordHeartbeat() {
        this.queryStateTimer.recordHeartbeat();
    }

    public void beginAnalysis() {
        this.queryStateTimer.beginAnalysis();
    }

    public void endAnalysis() {
        this.queryStateTimer.endAnalysis();
    }

    public DateTime getCreateTime() {
        return this.queryStateTimer.getCreateTime();
    }

    public Optional<DateTime> getExecutionStartTime() {
        return this.queryStateTimer.getExecutionStartTime();
    }

    public DateTime getLastHeartbeat() {
        return this.queryStateTimer.getLastHeartbeat();
    }

    public Optional<DateTime> getEndTime() {
        return this.queryStateTimer.getEndTime();
    }

    private static boolean isScheduled(Optional<StageInfo> rootStage) {
        if (rootStage.isEmpty()) {
            return false;
        }
        return StageInfo.getAllStages(rootStage).stream().map(StageInfo::getState).allMatch(state -> state == StageState.RUNNING || state == StageState.FLUSHING || state.isDone());
    }

    public Optional<ExecutionFailureInfo> getFailureInfo() {
        if (this.queryState.get() != QueryState.FAILED) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.failureCause.get());
    }

    public Optional<QueryInfo> getFinalQueryInfo() {
        return this.finalQueryInfo.get();
    }

    public QueryInfo updateQueryInfo(Optional<StageInfo> stageInfo) {
        QueryInfo queryInfo = this.getQueryInfo(stageInfo);
        if (queryInfo.isFinalQueryInfo()) {
            this.finalQueryInfo.compareAndSet(Optional.empty(), Optional.of(queryInfo));
        }
        return queryInfo;
    }

    public void pruneQueryInfo() {
        Optional<QueryInfo> finalInfo = this.finalQueryInfo.get();
        if (finalInfo.isEmpty() || finalInfo.get().getOutputStage().isEmpty()) {
            return;
        }
        QueryInfo queryInfo = finalInfo.get();
        Optional<StageInfo> prunedOutputStage = queryInfo.getOutputStage().map(outputStage -> new StageInfo(outputStage.getStageId(), outputStage.getState(), null, outputStage.getTypes(), outputStage.getStageStats(), (List<TaskInfo>)ImmutableList.of(), (List<StageInfo>)ImmutableList.of(), (Map<PlanNodeId, TableInfo>)ImmutableMap.of(), outputStage.getFailureCause()));
        QueryInfo prunedQueryInfo = new QueryInfo(queryInfo.getQueryId(), queryInfo.getSession(), queryInfo.getState(), this.getMemoryPool().getId(), queryInfo.isScheduled(), queryInfo.getSelf(), queryInfo.getFieldNames(), queryInfo.getQuery(), queryInfo.getPreparedQuery(), QueryStateMachine.pruneQueryStats(queryInfo.getQueryStats()), queryInfo.getSetCatalog(), queryInfo.getSetSchema(), queryInfo.getSetPath(), queryInfo.getSetSessionProperties(), queryInfo.getResetSessionProperties(), queryInfo.getSetRoles(), queryInfo.getAddedPreparedStatements(), queryInfo.getDeallocatedPreparedStatements(), queryInfo.getStartedTransactionId(), queryInfo.isClearTransactionId(), queryInfo.getUpdateType(), prunedOutputStage, queryInfo.getFailureInfo(), queryInfo.getErrorCode(), queryInfo.getWarnings(), queryInfo.getInputs(), queryInfo.getOutput(), queryInfo.getReferencedTables(), queryInfo.getRoutines(), queryInfo.isCompleteInfo(), queryInfo.getResourceGroupId(), queryInfo.getQueryType());
        this.finalQueryInfo.compareAndSet(finalInfo, Optional.of(prunedQueryInfo));
    }

    private static QueryStats pruneQueryStats(QueryStats queryStats) {
        return new QueryStats(queryStats.getCreateTime(), queryStats.getExecutionStartTime(), queryStats.getLastHeartbeat(), queryStats.getEndTime(), queryStats.getElapsedTime(), queryStats.getQueuedTime(), queryStats.getResourceWaitingTime(), queryStats.getDispatchingTime(), queryStats.getExecutionTime(), queryStats.getAnalysisTime(), queryStats.getPlanningTime(), queryStats.getFinishingTime(), queryStats.getTotalTasks(), queryStats.getRunningTasks(), queryStats.getCompletedTasks(), queryStats.getTotalDrivers(), queryStats.getQueuedDrivers(), queryStats.getRunningDrivers(), queryStats.getBlockedDrivers(), queryStats.getCompletedDrivers(), queryStats.getCumulativeUserMemory(), queryStats.getUserMemoryReservation(), queryStats.getRevocableMemoryReservation(), queryStats.getTotalMemoryReservation(), queryStats.getPeakUserMemoryReservation(), queryStats.getPeakRevocableMemoryReservation(), queryStats.getPeakNonRevocableMemoryReservation(), queryStats.getPeakTotalMemoryReservation(), queryStats.getPeakTaskUserMemory(), queryStats.getPeakTaskRevocableMemory(), queryStats.getPeakTaskTotalMemory(), queryStats.isScheduled(), queryStats.getTotalScheduledTime(), queryStats.getTotalCpuTime(), queryStats.getTotalBlockedTime(), queryStats.isFullyBlocked(), queryStats.getBlockedReasons(), queryStats.getPhysicalInputDataSize(), queryStats.getPhysicalInputPositions(), queryStats.getPhysicalInputReadTime(), queryStats.getInternalNetworkInputDataSize(), queryStats.getInternalNetworkInputPositions(), queryStats.getRawInputDataSize(), queryStats.getRawInputPositions(), queryStats.getProcessedInputDataSize(), queryStats.getProcessedInputPositions(), queryStats.getOutputDataSize(), queryStats.getOutputPositions(), queryStats.getPhysicalWrittenDataSize(), queryStats.getStageGcStatistics(), queryStats.getDynamicFiltersStats(), (List<OperatorStats>)ImmutableList.of());
    }

    public static class QueryOutputManager {
        private final Executor executor;
        @GuardedBy(value="this")
        private final List<Consumer<QueryExecution.QueryOutputInfo>> outputInfoListeners = new ArrayList<Consumer<QueryExecution.QueryOutputInfo>>();
        @GuardedBy(value="this")
        private List<String> columnNames;
        @GuardedBy(value="this")
        private List<Type> columnTypes;
        @GuardedBy(value="this")
        private final Set<URI> exchangeLocations = new LinkedHashSet<URI>();
        @GuardedBy(value="this")
        private boolean noMoreExchangeLocations;

        public QueryOutputManager(Executor executor) {
            this.executor = Objects.requireNonNull(executor, "executor is null");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addOutputInfoListener(Consumer<QueryExecution.QueryOutputInfo> listener) {
            Optional<QueryExecution.QueryOutputInfo> queryOutputInfo;
            Objects.requireNonNull(listener, "listener is null");
            QueryOutputManager queryOutputManager = this;
            synchronized (queryOutputManager) {
                this.outputInfoListeners.add(listener);
                queryOutputInfo = this.getQueryOutputInfo();
            }
            queryOutputInfo.ifPresent(info -> this.executor.execute(() -> listener.accept((QueryExecution.QueryOutputInfo)info)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setColumns(List<String> columnNames, List<Type> columnTypes) {
            ImmutableList outputInfoListeners;
            Optional<QueryExecution.QueryOutputInfo> queryOutputInfo;
            Objects.requireNonNull(columnNames, "columnNames is null");
            Objects.requireNonNull(columnTypes, "columnTypes is null");
            Preconditions.checkArgument((columnNames.size() == columnTypes.size() ? 1 : 0) != 0, (Object)"columnNames and columnTypes must be the same size");
            QueryOutputManager queryOutputManager = this;
            synchronized (queryOutputManager) {
                Preconditions.checkState((this.columnNames == null && this.columnTypes == null ? 1 : 0) != 0, (Object)"output fields already set");
                this.columnNames = ImmutableList.copyOf(columnNames);
                this.columnTypes = ImmutableList.copyOf(columnTypes);
                queryOutputInfo = this.getQueryOutputInfo();
                outputInfoListeners = ImmutableList.copyOf(this.outputInfoListeners);
            }
            queryOutputInfo.ifPresent(arg_0 -> this.lambda$setColumns$2((List)outputInfoListeners, arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateOutputLocations(Set<URI> newExchangeLocations, boolean noMoreExchangeLocations) {
            ImmutableList outputInfoListeners;
            Optional<QueryExecution.QueryOutputInfo> queryOutputInfo;
            Objects.requireNonNull(newExchangeLocations, "newExchangeLocations is null");
            QueryOutputManager queryOutputManager = this;
            synchronized (queryOutputManager) {
                if (this.noMoreExchangeLocations) {
                    Preconditions.checkArgument((boolean)this.exchangeLocations.containsAll(newExchangeLocations), (Object)"New locations added after no more locations set");
                    return;
                }
                this.exchangeLocations.addAll(newExchangeLocations);
                this.noMoreExchangeLocations = noMoreExchangeLocations;
                queryOutputInfo = this.getQueryOutputInfo();
                outputInfoListeners = ImmutableList.copyOf(this.outputInfoListeners);
            }
            queryOutputInfo.ifPresent(arg_0 -> this.lambda$updateOutputLocations$3((List)outputInfoListeners, arg_0));
        }

        private synchronized Optional<QueryExecution.QueryOutputInfo> getQueryOutputInfo() {
            if (this.columnNames == null || this.columnTypes == null) {
                return Optional.empty();
            }
            return Optional.of(new QueryExecution.QueryOutputInfo(this.columnNames, this.columnTypes, this.exchangeLocations, this.noMoreExchangeLocations));
        }

        private void fireStateChanged(QueryExecution.QueryOutputInfo queryOutputInfo, List<Consumer<QueryExecution.QueryOutputInfo>> outputInfoListeners) {
            for (Consumer<QueryExecution.QueryOutputInfo> outputInfoListener : outputInfoListeners) {
                this.executor.execute(() -> outputInfoListener.accept(queryOutputInfo));
            }
        }

        private /* synthetic */ void lambda$updateOutputLocations$3(List outputInfoListeners, QueryExecution.QueryOutputInfo info) {
            this.fireStateChanged(info, outputInfoListeners);
        }

        private /* synthetic */ void lambda$setColumns$2(List outputInfoListeners, QueryExecution.QueryOutputInfo info) {
            this.fireStateChanged(info, outputInfoListeners);
        }
    }
}

