/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.metadata.FunctionInvoker;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.UndeclaredDependencyException;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.sql.tree.QualifiedName;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FunctionDependencies {
    private final Metadata metadata;
    private final Map<TypeSignature, Type> types;
    private final Map<FunctionKey, ResolvedFunction> functions;
    private final Map<OperatorKey, ResolvedFunction> operators;
    private final Map<CastKey, ResolvedFunction> casts;

    public FunctionDependencies(Metadata metadata, Map<TypeSignature, Type> typeDependencies, Collection<ResolvedFunction> functionDependencies) {
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(typeDependencies, "typeDependencies is null");
        Objects.requireNonNull(functionDependencies, "functionDependencies is null");
        this.metadata = metadata;
        this.types = ImmutableMap.copyOf(typeDependencies);
        this.functions = (Map)functionDependencies.stream().filter(function -> !Signature.isOperatorName(function.getSignature().getName())).collect(ImmutableMap.toImmutableMap(x$0 -> new FunctionKey((ResolvedFunction)x$0), Function.identity()));
        this.operators = (Map)functionDependencies.stream().filter(FunctionDependencies::isOperator).collect(ImmutableMap.toImmutableMap(x$0 -> new OperatorKey((ResolvedFunction)x$0), Function.identity()));
        this.casts = (Map)functionDependencies.stream().filter(FunctionDependencies::isCast).collect(ImmutableMap.toImmutableMap(x$0 -> new CastKey((ResolvedFunction)x$0), Function.identity()));
    }

    public Type getType(TypeSignature typeSignature) {
        Type type = this.types.get(typeSignature);
        if (type == null) {
            throw new UndeclaredDependencyException(typeSignature.toString());
        }
        return type;
    }

    public FunctionMetadata getFunctionMetadata(QualifiedName name, List<Type> parameterTypes) {
        FunctionKey functionKey = new FunctionKey(name, FunctionDependencies.toTypeSignatures(parameterTypes));
        ResolvedFunction resolvedFunction = this.functions.get(functionKey);
        if (resolvedFunction == null) {
            throw new UndeclaredDependencyException(functionKey.toString());
        }
        return this.metadata.getFunctionMetadata(resolvedFunction);
    }

    public FunctionMetadata getOperatorMetadata(OperatorType operatorType, List<Type> parameterTypes) {
        OperatorKey operatorKey = new OperatorKey(operatorType, FunctionDependencies.toTypeSignatures(parameterTypes));
        ResolvedFunction resolvedFunction = this.operators.get(operatorKey);
        if (resolvedFunction == null) {
            throw new UndeclaredDependencyException(operatorKey.toString());
        }
        return this.metadata.getFunctionMetadata(resolvedFunction);
    }

    public FunctionMetadata getCastMetadata(Type fromType, Type toType) {
        CastKey castKey = new CastKey(fromType.getTypeSignature(), toType.getTypeSignature());
        ResolvedFunction resolvedFunction = this.casts.get(castKey);
        if (resolvedFunction == null) {
            throw new UndeclaredDependencyException(castKey.toString());
        }
        return this.metadata.getFunctionMetadata(resolvedFunction);
    }

    public FunctionInvoker getFunctionInvoker(QualifiedName name, List<Type> parameterTypes, Optional<InvocationConvention> invocationConvention) {
        FunctionKey functionKey = new FunctionKey(name, FunctionDependencies.toTypeSignatures(parameterTypes));
        ResolvedFunction resolvedFunction = this.functions.get(functionKey);
        if (resolvedFunction == null) {
            throw new UndeclaredDependencyException(functionKey.toString());
        }
        return this.metadata.getScalarFunctionInvoker(resolvedFunction, invocationConvention);
    }

    public FunctionInvoker getFunctionSignatureInvoker(QualifiedName name, List<TypeSignature> parameterTypes, Optional<InvocationConvention> invocationConvention) {
        FunctionKey functionKey = new FunctionKey(name, parameterTypes);
        ResolvedFunction resolvedFunction = this.functions.get(functionKey);
        if (resolvedFunction == null) {
            throw new UndeclaredDependencyException(functionKey.toString());
        }
        return this.metadata.getScalarFunctionInvoker(resolvedFunction, invocationConvention);
    }

    public FunctionInvoker getOperatorInvoker(OperatorType operatorType, List<Type> parameterTypes, Optional<InvocationConvention> invocationConvention) {
        OperatorKey operatorKey = new OperatorKey(operatorType, FunctionDependencies.toTypeSignatures(parameterTypes));
        ResolvedFunction resolvedFunction = this.operators.get(operatorKey);
        if (resolvedFunction == null) {
            throw new UndeclaredDependencyException(operatorKey.toString());
        }
        return this.metadata.getScalarFunctionInvoker(resolvedFunction, invocationConvention);
    }

    public FunctionInvoker getOperatorSignatureInvoker(OperatorType operatorType, List<TypeSignature> parameterTypes, Optional<InvocationConvention> invocationConvention) {
        OperatorKey operatorKey = new OperatorKey(operatorType, parameterTypes);
        ResolvedFunction resolvedFunction = this.operators.get(operatorKey);
        if (resolvedFunction == null) {
            throw new UndeclaredDependencyException(operatorKey.toString());
        }
        return this.metadata.getScalarFunctionInvoker(resolvedFunction, invocationConvention);
    }

    public FunctionInvoker getCastInvoker(Type fromType, Type toType, Optional<InvocationConvention> invocationConvention) {
        CastKey castKey = new CastKey(fromType.getTypeSignature(), toType.getTypeSignature());
        ResolvedFunction resolvedFunction = this.casts.get(castKey);
        if (resolvedFunction == null) {
            throw new UndeclaredDependencyException(castKey.toString());
        }
        return this.metadata.getScalarFunctionInvoker(resolvedFunction, invocationConvention);
    }

    public FunctionInvoker getCastSignatureInvoker(TypeSignature fromType, TypeSignature toType, Optional<InvocationConvention> invocationConvention) {
        CastKey castKey = new CastKey(fromType, toType);
        ResolvedFunction resolvedFunction = this.casts.get(castKey);
        if (resolvedFunction == null) {
            throw new UndeclaredDependencyException(castKey.toString());
        }
        return this.metadata.getScalarFunctionInvoker(resolvedFunction, invocationConvention);
    }

    private static List<TypeSignature> toTypeSignatures(List<Type> types) {
        return (List)types.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList());
    }

    private static boolean isOperator(ResolvedFunction function) {
        String name = function.getSignature().getName();
        return Signature.isOperatorName(name) && Signature.unmangleOperator(name) != OperatorType.CAST;
    }

    private static boolean isCast(ResolvedFunction function) {
        String name = function.getSignature().getName();
        return Signature.isOperatorName(name) && Signature.unmangleOperator(name) == OperatorType.CAST;
    }

    private static final class CastKey {
        private final TypeSignature fromType;
        private final TypeSignature toType;

        private CastKey(ResolvedFunction resolvedFunction) {
            this.fromType = resolvedFunction.getSignature().getArgumentTypes().get(0).getTypeSignature();
            this.toType = resolvedFunction.getSignature().getReturnType().getTypeSignature();
        }

        private CastKey(TypeSignature fromType, TypeSignature toType) {
            this.fromType = fromType;
            this.toType = toType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CastKey that = (CastKey)o;
            return Objects.equals(this.fromType, that.fromType) && Objects.equals(this.toType, that.toType);
        }

        public int hashCode() {
            return Objects.hash(this.fromType, this.toType);
        }

        public String toString() {
            return String.format("cast(%s, %s)", this.fromType, this.toType);
        }
    }

    public static final class OperatorKey {
        private final OperatorType operatorType;
        private final List<TypeSignature> argumentTypes;

        private OperatorKey(ResolvedFunction resolvedFunction) {
            this.operatorType = Signature.unmangleOperator(resolvedFunction.getSignature().getName());
            this.argumentTypes = FunctionDependencies.toTypeSignatures(resolvedFunction.getSignature().getArgumentTypes());
        }

        private OperatorKey(OperatorType operatorType, List<TypeSignature> argumentTypes) {
            this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
            this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperatorKey that = (OperatorKey)o;
            return this.operatorType == that.operatorType && Objects.equals(this.argumentTypes, that.argumentTypes);
        }

        public int hashCode() {
            return Objects.hash(this.operatorType, this.argumentTypes);
        }

        public String toString() {
            return this.operatorType + this.argumentTypes.stream().map(TypeSignature::toString).collect(Collectors.joining(", ", "(", ")"));
        }
    }

    public static final class FunctionKey {
        private final QualifiedName name;
        private final List<TypeSignature> argumentTypes;

        private FunctionKey(ResolvedFunction resolvedFunction) {
            Signature signature = resolvedFunction.getSignature().toSignature();
            this.name = QualifiedName.of((String)signature.getName());
            this.argumentTypes = (List)resolvedFunction.getSignature().getArgumentTypes().stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList());
        }

        private FunctionKey(QualifiedName name, List<TypeSignature> argumentTypes) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionKey that = (FunctionKey)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.argumentTypes, that.argumentTypes);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.argumentTypes);
        }

        public String toString() {
            return this.name + this.argumentTypes.stream().map(TypeSignature::toString).collect(Collectors.joining(", ", "(", ")"));
        }
    }
}

