/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import io.prestosql.metadata.BoundSignature;
import io.prestosql.metadata.FunctionInvoker;
import io.prestosql.metadata.ScalarFunctionAdapter;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.InvocationConvention;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;

class FunctionInvokerProvider {
    private final ScalarFunctionAdapter functionAdapter = new ScalarFunctionAdapter(ScalarFunctionAdapter.NullAdaptationPolicy.UNSUPPORTED);

    FunctionInvokerProvider() {
    }

    public FunctionInvoker createFunctionInvoker(ScalarFunctionImplementation scalarFunctionImplementation, BoundSignature boundSignature, InvocationConvention expectedConvention) {
        ArrayList<Choice> choices = new ArrayList<Choice>();
        for (ScalarFunctionImplementation.ScalarImplementationChoice choice : scalarFunctionImplementation.getChoices()) {
            InvocationConvention callingConvention = choice.getInvocationConvention();
            if (!this.functionAdapter.canAdapt(callingConvention, expectedConvention)) continue;
            choices.add(new Choice(choice, callingConvention));
        }
        if (choices.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Function implementation for (%s) cannot be adapted to convention (%s)", boundSignature, expectedConvention));
        }
        Choice bestChoice = Collections.max(choices, Comparator.comparingInt(Choice::getScore));
        MethodHandle methodHandle = this.functionAdapter.adapt(bestChoice.getChoice().getMethodHandle(), boundSignature.getArgumentTypes(), bestChoice.getCallingConvention(), expectedConvention);
        return new FunctionInvoker(methodHandle, bestChoice.getChoice().getInstanceFactory(), bestChoice.getChoice().getLambdaInterfaces());
    }

    private static final class Choice {
        private final ScalarFunctionImplementation.ScalarImplementationChoice choice;
        private final InvocationConvention callingConvention;
        private final int score;

        public Choice(ScalarFunctionImplementation.ScalarImplementationChoice choice, InvocationConvention callingConvention) {
            this.choice = Objects.requireNonNull(choice, "choice is null");
            this.callingConvention = Objects.requireNonNull(callingConvention, "callingConvention is null");
            int score = 0;
            for (InvocationConvention.InvocationArgumentConvention argument : callingConvention.getArgumentConventions()) {
                if (argument == InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
                    ++score;
                    continue;
                }
                if (argument != InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION) continue;
                score += 1000;
            }
            this.score = score;
        }

        public ScalarFunctionImplementation.ScalarImplementationChoice getChoice() {
            return this.choice;
        }

        public InvocationConvention getCallingConvention() {
            return this.callingConvention;
        }

        public int getScore() {
            return this.score;
        }
    }
}

