/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import io.prestosql.block.BlockSerdeUtil;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;

public class LiteralFunction
extends SqlScalarFunction {
    public static final String LITERAL_FUNCTION_NAME = "$literal$";
    private static final Set<Class<?>> SUPPORTED_LITERAL_TYPES = ImmutableSet.of(Long.TYPE, Double.TYPE, Slice.class, Boolean.TYPE);
    private final Supplier<BlockEncodingSerde> blockEncodingSerdeSupplier;

    public LiteralFunction(Supplier<BlockEncodingSerde> blockEncodingSerdeSupplier) {
        super(new FunctionMetadata(new Signature(LITERAL_FUNCTION_NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("F"), (Object)Signature.typeVariable("T")), (List<LongVariableConstraint>)ImmutableList.of(), new TypeSignature("T", new TypeSignatureParameter[0]), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("F", new TypeSignatureParameter[0])), false), false, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false)), true, true, "literal", FunctionKind.SCALAR));
        this.blockEncodingSerdeSupplier = blockEncodingSerdeSupplier;
    }

    @Override
    public ScalarFunctionImplementation specialize(FunctionBinding functionBinding) {
        Type parameterType = functionBinding.getTypeVariable("F");
        Type type = functionBinding.getTypeVariable("T");
        MethodHandle methodHandle = null;
        if (parameterType.getJavaType() == type.getJavaType()) {
            methodHandle = MethodHandles.identity(parameterType.getJavaType());
        }
        if (parameterType.getJavaType() == Slice.class) {
            if (type.getJavaType() == Block.class) {
                methodHandle = BlockSerdeUtil.READ_BLOCK.bindTo(this.blockEncodingSerdeSupplier.get());
            } else if (type.getJavaType() != Slice.class) {
                methodHandle = BlockSerdeUtil.READ_BLOCK_VALUE.bindTo(this.blockEncodingSerdeSupplier.get()).bindTo(type);
            }
        }
        Preconditions.checkArgument((methodHandle != null ? 1 : 0) != 0, (String)"Expected type %s to use (or can be converted into) Java type %s, but Java type is %s", (Object)type, (Object)parameterType.getJavaType(), (Object)type.getJavaType());
        return new ScalarFunctionImplementation(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    public static boolean isSupportedLiteralType(Type type) {
        return SUPPORTED_LITERAL_TYPES.contains(type.getJavaType());
    }

    public static Type typeForMagicLiteral(Type type) {
        Class clazz = type.getJavaType();
        if ((clazz = Primitives.unwrap((Class)clazz)) == Long.TYPE) {
            return BigintType.BIGINT;
        }
        if (clazz == Double.TYPE) {
            return DoubleType.DOUBLE;
        }
        if (!clazz.isPrimitive()) {
            if (type instanceof VarcharType) {
                return type;
            }
            return VarbinaryType.VARBINARY;
        }
        if (clazz == Boolean.TYPE) {
            return BooleanType.BOOLEAN;
        }
        throw new IllegalArgumentException("Unhandled Java type: " + clazz.getName());
    }
}

