/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.DynamicClassLoader;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionDependencies;
import io.prestosql.metadata.FunctionDependencyDeclaration;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlAggregationFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.aggregation.AccumulatorCompiler;
import io.prestosql.operator.aggregation.AggregationMetadata;
import io.prestosql.operator.aggregation.AggregationUtils;
import io.prestosql.operator.aggregation.GenericAccumulatorFactoryBinder;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.aggregation.state.BlockPositionState;
import io.prestosql.operator.aggregation.state.BlockPositionStateSerializer;
import io.prestosql.operator.aggregation.state.NullableBooleanState;
import io.prestosql.operator.aggregation.state.NullableDoubleState;
import io.prestosql.operator.aggregation.state.NullableLongState;
import io.prestosql.operator.aggregation.state.StateCompiler;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AccumulatorStateFactory;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.util.Failures;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public abstract class AbstractMinMaxAggregationFunction
extends SqlAggregationFunction {
    private static final MethodHandle LONG_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "input", MethodHandle.class, NullableLongState.class, Long.TYPE);
    private static final MethodHandle DOUBLE_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "input", MethodHandle.class, NullableDoubleState.class, Double.TYPE);
    private static final MethodHandle BOOLEAN_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "input", MethodHandle.class, NullableBooleanState.class, Boolean.TYPE);
    private static final MethodHandle BLOCK_POSITION_MIN_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "minInput", Type.class, BlockPositionState.class, Block.class, Integer.TYPE);
    private static final MethodHandle BLOCK_POSITION_MAX_INPUT_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "maxInput", Type.class, BlockPositionState.class, Block.class, Integer.TYPE);
    private static final MethodHandle LONG_OUTPUT_FUNCTION = Reflection.methodHandle(NullableLongState.class, "write", Type.class, NullableLongState.class, BlockBuilder.class);
    private static final MethodHandle DOUBLE_OUTPUT_FUNCTION = Reflection.methodHandle(NullableDoubleState.class, "write", Type.class, NullableDoubleState.class, BlockBuilder.class);
    private static final MethodHandle BOOLEAN_OUTPUT_FUNCTION = Reflection.methodHandle(NullableBooleanState.class, "write", Type.class, NullableBooleanState.class, BlockBuilder.class);
    private static final MethodHandle BLOCK_POSITION_OUTPUT_FUNCTION = Reflection.methodHandle(BlockPositionState.class, "write", Type.class, BlockPositionState.class, BlockBuilder.class);
    private static final MethodHandle LONG_COMBINE_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "combine", MethodHandle.class, NullableLongState.class, NullableLongState.class);
    private static final MethodHandle DOUBLE_COMBINE_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "combine", MethodHandle.class, NullableDoubleState.class, NullableDoubleState.class);
    private static final MethodHandle BOOLEAN_COMBINE_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "combine", MethodHandle.class, NullableBooleanState.class, NullableBooleanState.class);
    private static final MethodHandle BLOCK_POSITION_MIN_COMBINE_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "minCombine", Type.class, BlockPositionState.class, BlockPositionState.class);
    private static final MethodHandle BLOCK_POSITION_MAX_COMBINE_FUNCTION = Reflection.methodHandle(AbstractMinMaxAggregationFunction.class, "maxCombine", Type.class, BlockPositionState.class, BlockPositionState.class);
    private final OperatorType operatorType;
    private final boolean min;

    protected AbstractMinMaxAggregationFunction(String name, boolean min, String description) {
        super(new FunctionMetadata(new Signature(name, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.orderableTypeParameter("E")), (List<LongVariableConstraint>)ImmutableList.of(), new TypeSignature("E", new TypeSignatureParameter[0]), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("E", new TypeSignatureParameter[0])), false), true, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false)), false, true, description, FunctionKind.AGGREGATE), true, false);
        this.min = min;
        this.operatorType = min ? OperatorType.LESS_THAN : OperatorType.GREATER_THAN;
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        return FunctionDependencyDeclaration.builder().addOperatorSignature(this.operatorType, (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("E", new TypeSignatureParameter[0]), (Object)new TypeSignature("E", new TypeSignatureParameter[0]))).build();
    }

    @Override
    public List<TypeSignature> getIntermediateTypes(FunctionBinding functionBinding) {
        Type type = functionBinding.getTypeVariable("E");
        if (type.getJavaType() == Long.TYPE) {
            return ImmutableList.of((Object)StateCompiler.getSerializedType(NullableLongState.class).getTypeSignature());
        }
        if (type.getJavaType() == Double.TYPE) {
            return ImmutableList.of((Object)StateCompiler.getSerializedType(NullableDoubleState.class).getTypeSignature());
        }
        if (type.getJavaType() == Boolean.TYPE) {
            return ImmutableList.of((Object)StateCompiler.getSerializedType(NullableBooleanState.class).getTypeSignature());
        }
        return ImmutableList.of((Object)new BlockPositionStateSerializer(type).getSerializedType().getTypeSignature());
    }

    @Override
    public InternalAggregationFunction specialize(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        Type type = functionBinding.getTypeVariable("E");
        MethodHandle compareMethodHandle = functionDependencies.getOperatorInvoker(this.operatorType, (List<Type>)ImmutableList.of((Object)type, (Object)type), Optional.empty()).getMethodHandle();
        return this.generateAggregation(type, compareMethodHandle);
    }

    protected InternalAggregationFunction generateAggregation(Type type, MethodHandle compareMethodHandle) {
        MethodHandle outputFunction;
        MethodHandle combineFunction;
        MethodHandle inputFunction;
        BlockPositionStateSerializer stateSerializer;
        Class stateInterface;
        DynamicClassLoader classLoader = new DynamicClassLoader(AbstractMinMaxAggregationFunction.class.getClassLoader());
        ImmutableList inputTypes = ImmutableList.of((Object)type);
        if (type.getJavaType() == Long.TYPE) {
            stateInterface = NullableLongState.class;
            stateSerializer = StateCompiler.generateStateSerializer(stateInterface, classLoader);
            inputFunction = LONG_INPUT_FUNCTION.bindTo(compareMethodHandle);
            combineFunction = LONG_COMBINE_FUNCTION.bindTo(compareMethodHandle);
            outputFunction = LONG_OUTPUT_FUNCTION.bindTo(type);
        } else if (type.getJavaType() == Double.TYPE) {
            stateInterface = NullableDoubleState.class;
            stateSerializer = StateCompiler.generateStateSerializer(stateInterface, classLoader);
            inputFunction = DOUBLE_INPUT_FUNCTION.bindTo(compareMethodHandle);
            combineFunction = DOUBLE_COMBINE_FUNCTION.bindTo(compareMethodHandle);
            outputFunction = DOUBLE_OUTPUT_FUNCTION.bindTo(type);
        } else if (type.getJavaType() == Boolean.TYPE) {
            stateInterface = NullableBooleanState.class;
            stateSerializer = StateCompiler.generateStateSerializer(stateInterface, classLoader);
            inputFunction = BOOLEAN_INPUT_FUNCTION.bindTo(compareMethodHandle);
            combineFunction = BOOLEAN_COMBINE_FUNCTION.bindTo(compareMethodHandle);
            outputFunction = BOOLEAN_OUTPUT_FUNCTION.bindTo(type);
        } else {
            stateInterface = BlockPositionState.class;
            stateSerializer = new BlockPositionStateSerializer(type);
            inputFunction = this.min ? BLOCK_POSITION_MIN_INPUT_FUNCTION.bindTo(type) : BLOCK_POSITION_MAX_INPUT_FUNCTION.bindTo(type);
            combineFunction = this.min ? BLOCK_POSITION_MIN_COMBINE_FUNCTION.bindTo(type) : BLOCK_POSITION_MAX_COMBINE_FUNCTION.bindTo(type);
            outputFunction = BLOCK_POSITION_OUTPUT_FUNCTION.bindTo(type);
        }
        AccumulatorStateFactory<NullableLongState> stateFactory = StateCompiler.generateStateFactory(stateInterface, classLoader);
        Type intermediateType = stateSerializer.getSerializedType();
        String name = this.getFunctionMetadata().getSignature().getName();
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(name, type.getTypeSignature(), (List)inputTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())), AbstractMinMaxAggregationFunction.createParameterMetadata(type), inputFunction, Optional.empty(), combineFunction, outputFunction, (List<AggregationMetadata.AccumulatorStateDescriptor>)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(stateInterface, stateSerializer, stateFactory)), type);
        GenericAccumulatorFactoryBinder factory = AccumulatorCompiler.generateAccumulatorFactoryBinder(metadata, classLoader);
        return new InternalAggregationFunction(name, (List<Type>)inputTypes, (List<Type>)ImmutableList.of((Object)intermediateType), type, factory);
    }

    private static List<AggregationMetadata.ParameterMetadata> createParameterMetadata(Type type) {
        if (type.getJavaType().isPrimitive()) {
            return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.INPUT_CHANNEL, type));
        }
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, type), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    @UsedByGeneratedCode
    public static void input(MethodHandle methodHandle, NullableDoubleState state, double value) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, value);
    }

    @UsedByGeneratedCode
    public static void input(MethodHandle methodHandle, NullableLongState state, long value) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, value);
    }

    @UsedByGeneratedCode
    public static void input(MethodHandle methodHandle, NullableBooleanState state, boolean value) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, value);
    }

    @UsedByGeneratedCode
    public static void minInput(Type type, BlockPositionState state, Block block, int position) {
        if (state.getBlock() == null || type.compareTo(block, position, state.getBlock(), state.getPosition()) < 0) {
            state.setBlock(block);
            state.setPosition(position);
        }
    }

    @UsedByGeneratedCode
    public static void maxInput(Type type, BlockPositionState state, Block block, int position) {
        if (state.getBlock() == null || type.compareTo(block, position, state.getBlock(), state.getPosition()) > 0) {
            state.setBlock(block);
            state.setPosition(position);
        }
    }

    @UsedByGeneratedCode
    public static void combine(MethodHandle methodHandle, NullableLongState state, NullableLongState otherState) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, otherState.getLong());
    }

    @UsedByGeneratedCode
    public static void combine(MethodHandle methodHandle, NullableDoubleState state, NullableDoubleState otherState) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, otherState.getDouble());
    }

    @UsedByGeneratedCode
    public static void combine(MethodHandle methodHandle, NullableBooleanState state, NullableBooleanState otherState) {
        AbstractMinMaxAggregationFunction.compareAndUpdateState(methodHandle, state, otherState.getBoolean());
    }

    @UsedByGeneratedCode
    public static void minCombine(Type type, BlockPositionState state, BlockPositionState otherState) {
        if (state.getBlock() == null || type.compareTo(otherState.getBlock(), otherState.getPosition(), state.getBlock(), state.getPosition()) < 0) {
            state.setBlock(otherState.getBlock());
            state.setPosition(otherState.getPosition());
        }
    }

    @UsedByGeneratedCode
    public static void maxCombine(Type type, BlockPositionState state, BlockPositionState otherState) {
        if (state.getBlock() == null || type.compareTo(otherState.getBlock(), otherState.getPosition(), state.getBlock(), state.getPosition()) > 0) {
            state.setBlock(otherState.getBlock());
            state.setPosition(otherState.getPosition());
        }
    }

    private static void compareAndUpdateState(MethodHandle methodHandle, NullableLongState state, long value) {
        if (state.isNull()) {
            state.setNull(false);
            state.setLong(value);
            return;
        }
        try {
            if (methodHandle.invokeExact(value, state.getLong())) {
                state.setLong(value);
            }
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    private static void compareAndUpdateState(MethodHandle methodHandle, NullableDoubleState state, double value) {
        if (state.isNull()) {
            state.setNull(false);
            state.setDouble(value);
            return;
        }
        try {
            if (methodHandle.invokeExact(value, state.getDouble())) {
                state.setDouble(value);
            }
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }

    private static void compareAndUpdateState(MethodHandle methodHandle, NullableBooleanState state, boolean value) {
        if (state.isNull()) {
            state.setNull(false);
            state.setBoolean(value);
            return;
        }
        try {
            if (methodHandle.invokeExact(value, state.getBoolean())) {
                state.setBoolean(value);
            }
        }
        catch (Throwable t) {
            throw Failures.internalError(t);
        }
    }
}

