/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import io.prestosql.type.TypeUtils;
import io.prestosql.util.Failures;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class TypedSet {
    @VisibleForTesting
    public static final DataSize MAX_FUNCTION_MEMORY = DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TypedSet.class).instanceSize();
    private static final int INT_ARRAY_LIST_INSTANCE_SIZE = ClassLayout.parseClass(IntArrayList.class).instanceSize();
    private static final float FILL_RATIO = 0.75f;
    private final Type elementType;
    private final Optional<MethodHandle> elementIsDistinctFrom;
    private final IntArrayList blockPositionByHash;
    private final BlockBuilder elementBlock;
    private final String functionName;
    private final long maxBlockMemoryInBytes;
    private int initialElementBlockOffset;
    private long initialElementBlockSizeInBytes;
    private int size;
    private int hashCapacity;
    private int maxFill;
    private int hashMask;
    private static final int EMPTY_SLOT = -1;
    private boolean containsNullElement;

    public TypedSet(Type elementType, int expectedSize, String functionName) {
        this(elementType, Optional.empty(), elementType.createBlockBuilder(null, expectedSize), expectedSize, functionName);
    }

    public TypedSet(Type elementType, MethodHandle elementIsDistinctFrom, int expectedSize, String functionName) {
        this(elementType, Optional.of(elementIsDistinctFrom), elementType.createBlockBuilder(null, expectedSize), expectedSize, functionName);
    }

    public TypedSet(Type elementType, Optional<MethodHandle> elementIsDistinctFrom, BlockBuilder blockBuilder, int expectedSize, String functionName) {
        this(elementType, elementIsDistinctFrom, blockBuilder, expectedSize, functionName, Optional.of(MAX_FUNCTION_MEMORY));
    }

    public TypedSet(Type elementType, Optional<MethodHandle> elementIsDistinctFrom, BlockBuilder blockBuilder, int expectedSize, String functionName, Optional<DataSize> maxBlockMemory) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (Object)"expectedSize must not be negative");
        this.elementType = Objects.requireNonNull(elementType, "elementType must not be null");
        this.elementIsDistinctFrom = Objects.requireNonNull(elementIsDistinctFrom, "elementIsDistinctFrom is null");
        elementIsDistinctFrom.ifPresent(methodHandle -> Preconditions.checkArgument((boolean)methodHandle.type().equals((Object)MethodType.methodType(Boolean.TYPE, Block.class, Integer.TYPE, Block.class, Integer.TYPE))));
        this.elementBlock = Objects.requireNonNull(blockBuilder, "blockBuilder must not be null");
        this.functionName = functionName;
        this.maxBlockMemoryInBytes = maxBlockMemory.map(DataSize::toBytes).orElse(Long.MAX_VALUE);
        this.initialElementBlockOffset = this.elementBlock.getPositionCount();
        this.initialElementBlockSizeInBytes = this.elementBlock.getSizeInBytes();
        this.size = 0;
        this.hashCapacity = HashCommon.arraySize((int)expectedSize, (float)0.75f);
        this.maxFill = TypedSet.calculateMaxFill(this.hashCapacity);
        this.hashMask = this.hashCapacity - 1;
        this.blockPositionByHash = new IntArrayList(this.hashCapacity);
        this.blockPositionByHash.size(this.hashCapacity);
        for (int i = 0; i < this.hashCapacity; ++i) {
            this.blockPositionByHash.set(i, -1);
        }
        this.containsNullElement = false;
    }

    public long getRetainedSizeInBytes() {
        return (long)(INSTANCE_SIZE + INT_ARRAY_LIST_INSTANCE_SIZE) + this.elementBlock.getRetainedSizeInBytes() + (long)(this.blockPositionByHash.size() * 4);
    }

    public boolean contains(Block block, int position) {
        Objects.requireNonNull(block, "block must not be null");
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"position must be >= 0");
        if (block.isNull(position)) {
            return this.containsNullElement;
        }
        return this.blockPositionByHash.getInt(this.getHashPositionOfElement(block, position)) != -1;
    }

    public void add(Block block, int position) {
        int hashPosition;
        Objects.requireNonNull(block, "block must not be null");
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"position must be >= 0");
        if (block.isNull(position)) {
            this.containsNullElement = true;
        }
        if (this.blockPositionByHash.getInt(hashPosition = this.getHashPositionOfElement(block, position)) == -1) {
            this.addNewElement(hashPosition, block, position);
        }
    }

    public int size() {
        return this.size;
    }

    public int positionOf(Block block, int position) {
        return this.blockPositionByHash.getInt(this.getHashPositionOfElement(block, position));
    }

    private int getHashPositionOfElement(Block block, int position) {
        int hashPosition = this.getMaskedHash(TypeUtils.hashPosition(this.elementType, block, position));
        int blockPosition;
        while ((blockPosition = this.blockPositionByHash.getInt(hashPosition)) != -1) {
            if (this.isContainedAt(block, position, blockPosition)) {
                return hashPosition;
            }
            hashPosition = this.getMaskedHash(hashPosition + 1);
        }
        return hashPosition;
    }

    private boolean isContainedAt(Block block, int position, int atPosition) {
        if (this.elementIsDistinctFrom.isPresent()) {
            try {
                boolean isNotDistinctFrom = !this.elementIsDistinctFrom.get().invokeExact((Block)this.elementBlock, atPosition, block, position);
                return isNotDistinctFrom;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return TypeUtils.positionEqualsPosition(this.elementType, (Block)this.elementBlock, atPosition, block, position);
    }

    private void addNewElement(int hashPosition, Block block, int position) {
        this.elementType.appendTo(block, position, this.elementBlock);
        if (this.elementBlock.getSizeInBytes() - this.initialElementBlockSizeInBytes > this.maxBlockMemoryInBytes) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT, String.format("The input to %s is too large. More than %s of memory is needed to hold the intermediate hash set.\n", this.functionName, MAX_FUNCTION_MEMORY));
        }
        this.blockPositionByHash.set(hashPosition, this.elementBlock.getPositionCount() - 1);
        ++this.size;
        if (this.size >= this.maxFill) {
            this.rehash();
        }
    }

    private void rehash() {
        int newCapacity;
        long newCapacityLong = (long)this.hashCapacity * 2L;
        if (newCapacityLong > Integer.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of hash table cannot exceed 1 billion entries");
        }
        this.hashCapacity = newCapacity = (int)newCapacityLong;
        this.hashMask = newCapacity - 1;
        this.maxFill = TypedSet.calculateMaxFill(newCapacity);
        this.blockPositionByHash.size(newCapacity);
        for (int i = 0; i < newCapacity; ++i) {
            this.blockPositionByHash.set(i, -1);
        }
        for (int blockPosition = this.initialElementBlockOffset; blockPosition < this.elementBlock.getPositionCount(); ++blockPosition) {
            this.blockPositionByHash.set(this.getHashPositionOfElement((Block)this.elementBlock, blockPosition), blockPosition);
        }
    }

    private static int calculateMaxFill(int hashSize) {
        Preconditions.checkArgument((hashSize > 0 ? 1 : 0) != 0, (Object)"hashSize must be greater than 0");
        int maxFill = (int)Math.ceil((float)hashSize * 0.75f);
        if (maxFill == hashSize) {
            --maxFill;
        }
        Preconditions.checkArgument((hashSize > maxFill ? 1 : 0) != 0, (Object)"hashSize must be larger than maxFill");
        return maxFill;
    }

    private int getMaskedHash(long rawHash) {
        return (int)(rawHash & (long)this.hashMask);
    }
}

