/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.airlift.slice.Slice;
import io.prestosql.operator.aggregation.ApproximateMostFrequentHistogram;
import io.prestosql.operator.aggregation.StringApproximateMostFrequentStateFactory;
import io.prestosql.operator.aggregation.StringApproximateMostFrequentStateSerializer;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AccumulatorState;
import io.prestosql.spi.function.AccumulatorStateMetadata;
import io.prestosql.spi.function.AggregationFunction;
import io.prestosql.spi.function.AggregationState;
import io.prestosql.spi.function.CombineFunction;
import io.prestosql.spi.function.InputFunction;
import io.prestosql.spi.function.OutputFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.util.Failures;

@AggregationFunction(value="approx_most_frequent")
public final class VarcharApproximateMostFrequent {
    private VarcharApproximateMostFrequent() {
    }

    @InputFunction
    public static void input(@AggregationState State state, @SqlType(value="bigint") long buckets, @SqlType(value="varchar") Slice value, @SqlType(value="bigint") long capacity) {
        ApproximateMostFrequentHistogram<Slice> histogram = state.get();
        if (histogram == null) {
            Failures.checkCondition(buckets >= 2L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "approx_most_frequent bucket count must be greater than one", new Object[0]);
            histogram = new ApproximateMostFrequentHistogram<Slice>(Math.toIntExact(buckets), Math.toIntExact(capacity), StringApproximateMostFrequentStateSerializer::serializeBucket, StringApproximateMostFrequentStateSerializer::deserializeBucket);
            state.set(histogram);
        }
        histogram.add(value);
    }

    @CombineFunction
    public static void combine(@AggregationState State state, @AggregationState State otherState) {
        ApproximateMostFrequentHistogram<Slice> otherHistogram = otherState.get();
        ApproximateMostFrequentHistogram<Slice> histogram = state.get();
        if (histogram == null) {
            state.set(otherHistogram);
        } else {
            histogram.merge(otherHistogram);
        }
    }

    @OutputFunction(value="map(varchar,bigint)")
    public static void output(@AggregationState State state, BlockBuilder out) {
        if (state.get() == null) {
            out.appendNull();
        } else {
            BlockBuilder entryBuilder = out.beginBlockEntry();
            state.get().forEachBucket((key, value) -> {
                VarcharType.VARCHAR.writeSlice(entryBuilder, key);
                BigintType.BIGINT.writeLong(entryBuilder, value);
            });
            out.closeEntry();
        }
    }

    @AccumulatorStateMetadata(stateSerializerClass=StringApproximateMostFrequentStateSerializer.class, stateFactoryClass=StringApproximateMostFrequentStateFactory.class)
    public static interface State
    extends AccumulatorState {
        public ApproximateMostFrequentHistogram<Slice> get();

        public void set(ApproximateMostFrequentHistogram<Slice> var1);
    }
}

