/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.state;

import io.prestosql.operator.aggregation.state.NullableDoubleState;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AccumulatorStateSerializer;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;

public class NullableDoubleStateSerializer
implements AccumulatorStateSerializer<NullableDoubleState> {
    public Type getSerializedType() {
        return DoubleType.DOUBLE;
    }

    public void serialize(NullableDoubleState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            DoubleType.DOUBLE.writeDouble(out, state.getDouble());
        }
    }

    public void deserialize(Block block, int index, NullableDoubleState state) {
        state.setNull(false);
        state.setDouble(DoubleType.DOUBLE.getDouble(block, index));
    }
}

