/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.annotations;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionDependencies;
import io.prestosql.metadata.FunctionDependencyDeclaration;
import io.prestosql.metadata.FunctionInvoker;
import io.prestosql.metadata.SignatureBinder;
import io.prestosql.operator.annotations.ScalarImplementationDependency;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.TypeSignature;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class OperatorImplementationDependency
extends ScalarImplementationDependency {
    private final OperatorType operator;
    private final List<TypeSignature> argumentTypes;

    public OperatorImplementationDependency(OperatorType operator, List<TypeSignature> argumentTypes, Optional<InvocationConvention> invocationConvention) {
        super(invocationConvention);
        this.operator = Objects.requireNonNull(operator, "operator is null");
        Preconditions.checkArgument((operator != OperatorType.CAST && operator != OperatorType.SATURATED_FLOOR_CAST ? 1 : 0) != 0);
        this.argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
    }

    public OperatorType getOperator() {
        return this.operator;
    }

    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Override
    public void declareDependencies(FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder) {
        builder.addOperatorSignature(this.operator, this.argumentTypes);
    }

    @Override
    protected FunctionInvoker getInvoker(FunctionBinding functionBinding, FunctionDependencies functionDependencies, Optional<InvocationConvention> invocationConvention) {
        List<TypeSignature> types = SignatureBinder.applyBoundVariables(this.argumentTypes, functionBinding);
        return functionDependencies.getOperatorSignatureInvoker(this.operator, types, invocationConvention);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorImplementationDependency that = (OperatorImplementationDependency)o;
        return this.operator == that.operator && Objects.equals(this.argumentTypes, that.argumentTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.operator, this.argumentTypes);
    }
}

