/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionDependencies;
import io.prestosql.metadata.FunctionDependencyDeclaration;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.sql.gen.BytecodeUtils;
import io.prestosql.sql.gen.CallSiteBinder;
import io.prestosql.util.CompilerUtils;
import io.prestosql.util.Failures;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class AbstractGreatestLeast
extends SqlScalarFunction {
    private static final MethodHandle CHECK_NOT_NAN = Reflection.methodHandle(AbstractGreatestLeast.class, "checkNotNaN", String.class, Double.TYPE);
    private final OperatorType operatorType;

    protected AbstractGreatestLeast(String name, OperatorType operatorType, String description) {
        super(new FunctionMetadata(new Signature(name, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.orderableTypeParameter("E")), (List<LongVariableConstraint>)ImmutableList.of(), new TypeSignature("E", new TypeSignatureParameter[0]), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("E", new TypeSignatureParameter[0])), true), false, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false)), false, true, description, FunctionKind.SCALAR));
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies() {
        return FunctionDependencyDeclaration.builder().addOperatorSignature(this.operatorType, (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("E", new TypeSignatureParameter[0]), (Object)new TypeSignature("E", new TypeSignatureParameter[0]))).build();
    }

    @Override
    public ScalarFunctionImplementation specialize(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        Type type = functionBinding.getTypeVariable("E");
        Preconditions.checkArgument((boolean)type.isOrderable(), (Object)"Type must be orderable");
        MethodHandle compareMethod = functionDependencies.getOperatorInvoker(this.operatorType, (List<Type>)ImmutableList.of((Object)type, (Object)type), Optional.empty()).getMethodHandle();
        List javaTypes = (List)IntStream.range(0, functionBinding.getArity()).mapToObj(i -> type.getJavaType()).collect(ImmutableList.toImmutableList());
        Class<?> clazz = this.generate(javaTypes, type, compareMethod);
        MethodHandle methodHandle = Reflection.methodHandle(clazz, this.getFunctionMetadata().getSignature().getName(), javaTypes.toArray(new Class[javaTypes.size()]));
        return new ScalarFunctionImplementation(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, Collections.nCopies(javaTypes.size(), InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    @UsedByGeneratedCode
    public static void checkNotNaN(String name, double value) {
        if (Double.isNaN(value)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Invalid argument to %s(): NaN", name));
        }
    }

    private Class<?> generate(List<Class<?>> javaTypes, Type type, MethodHandle compareMethod) {
        Signature signature = this.getFunctionMetadata().getSignature();
        Failures.checkCondition(javaTypes.size() <= 127, (ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Too many arguments for function call %s()", signature.getName());
        String javaTypeName = javaTypes.stream().map(Class::getSimpleName).collect(Collectors.joining());
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(javaTypeName + "$" + signature.getName()), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        List parameters = (List)IntStream.range(0, javaTypes.size()).mapToObj(i -> Parameter.arg((String)("arg" + i), (Class)((Class)javaTypes.get(i)))).collect(ImmutableList.toImmutableList());
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), signature.getName(), ParameterizedType.type(javaTypes.get(0)), (Iterable)parameters);
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        CallSiteBinder binder = new CallSiteBinder();
        if (type.equals(DoubleType.DOUBLE)) {
            for (Parameter parameter : parameters) {
                body.append((BytecodeNode)parameter);
                body.append((BytecodeNode)BytecodeUtils.invoke(binder.bind(CHECK_NOT_NAN.bindTo(signature.getName())), "checkNotNaN"));
            }
        }
        Variable value = scope.declareVariable(javaTypes.get(0), "value");
        body.append((BytecodeNode)value.set((BytecodeExpression)parameters.get(0)));
        for (int i2 = 1; i2 < javaTypes.size(); ++i2) {
            body.append((BytecodeNode)new IfStatement().condition((BytecodeNode)new BytecodeBlock().append((BytecodeNode)parameters.get(i2)).append((BytecodeNode)value).append((BytecodeNode)BytecodeUtils.invoke(binder.bind(compareMethod), "compare"))).ifTrue((BytecodeNode)value.set((BytecodeExpression)parameters.get(i2))));
        }
        body.append((BytecodeNode)value.ret());
        return CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), (ClassLoader)new DynamicClassLoader(this.getClass().getClassLoader()));
    }
}

