/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.sql.gen.lambda.BinaryFunctionInterface;
import io.prestosql.sql.gen.lambda.UnaryFunctionInterface;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class ArrayReduceFunction
extends SqlScalarFunction {
    public static final ArrayReduceFunction ARRAY_REDUCE_FUNCTION = new ArrayReduceFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayReduceFunction.class, "reduce", Type.class, Block.class, Object.class, BinaryFunctionInterface.class, UnaryFunctionInterface.class);

    private ArrayReduceFunction() {
        super(new FunctionMetadata(new Signature("reduce", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("T"), (Object)Signature.typeVariable("S"), (Object)Signature.typeVariable("R")), (List<LongVariableConstraint>)ImmutableList.of(), new TypeSignature("R", new TypeSignatureParameter[0]), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0])), (Object)new TypeSignature("S", new TypeSignatureParameter[0]), (Object)TypeSignature.functionType((TypeSignature)new TypeSignature("S", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("T", new TypeSignatureParameter[0]), new TypeSignature("S", new TypeSignatureParameter[0])}), (Object)TypeSignature.functionType((TypeSignature)new TypeSignature("S", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("R", new TypeSignatureParameter[0])})), false), true, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(true), (Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false)), false, false, "Reduce elements of the array into a single value", FunctionKind.SCALAR));
    }

    @Override
    protected ScalarFunctionImplementation specialize(FunctionBinding functionBinding) {
        Type inputType = functionBinding.getTypeVariable("T");
        Type intermediateType = functionBinding.getTypeVariable("S");
        Type outputType = functionBinding.getTypeVariable("R");
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(inputType);
        return new ScalarFunctionImplementation(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, (Object)InvocationConvention.InvocationArgumentConvention.FUNCTION, (Object)InvocationConvention.InvocationArgumentConvention.FUNCTION), (List<Optional<Class<?>>>)ImmutableList.of(Optional.empty(), Optional.empty(), Optional.of(BinaryFunctionInterface.class), Optional.of(UnaryFunctionInterface.class)), methodHandle.asType(methodHandle.type().changeParameterType(1, Primitives.wrap((Class)intermediateType.getJavaType())).changeReturnType(Primitives.wrap((Class)outputType.getJavaType()))), Optional.empty());
    }

    public static Object reduce(Type inputType, Block block, Object initialIntermediateValue, BinaryFunctionInterface inputFunction, UnaryFunctionInterface outputFunction) {
        int positionCount = block.getPositionCount();
        Object intermediateValue = initialIntermediateValue;
        for (int position = 0; position < positionCount; ++position) {
            Object input = TypeUtils.readNativeValue((Type)inputType, (Block)block, (int)position);
            intermediateValue = inputFunction.apply(intermediateValue, input);
        }
        return outputFunction.apply(intermediateValue);
    }
}

