/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.SqlOperator;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.SingleRowBlockWriter;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.type.JsonType;
import io.prestosql.util.Failures;
import io.prestosql.util.JsonCastException;
import io.prestosql.util.JsonUtil;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class JsonToRowCast
extends SqlOperator {
    public static final JsonToRowCast JSON_TO_ROW = new JsonToRowCast();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(JsonToRowCast.class, "toRow", RowType.class, JsonUtil.BlockBuilderAppender[].class, Optional.class, ConnectorSession.class, Slice.class);

    private JsonToRowCast() {
        super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)new TypeVariableConstraint("T", false, false, "row", (Set<TypeSignature>)ImmutableSet.of(), (Set<TypeSignature>)ImmutableSet.of((Object)JsonType.JSON.getTypeSignature()))), (List<LongVariableConstraint>)ImmutableList.of(), new TypeSignature("T", new TypeSignatureParameter[0]), (List<TypeSignature>)ImmutableList.of((Object)JsonType.JSON.getTypeSignature()), true);
    }

    @Override
    protected ScalarFunctionImplementation specialize(FunctionBinding functionBinding) {
        Preconditions.checkArgument((functionBinding.getArity() == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        RowType rowType = (RowType)functionBinding.getTypeVariable("T");
        Failures.checkCondition(JsonUtil.canCastFromJson((Type)rowType), (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast JSON to %s", rowType);
        List rowFields = rowType.getFields();
        JsonUtil.BlockBuilderAppender[] fieldAppenders = (JsonUtil.BlockBuilderAppender[])rowFields.stream().map(rowField -> JsonUtil.BlockBuilderAppender.createBlockBuilderAppender(rowField.getType())).toArray(JsonUtil.BlockBuilderAppender[]::new);
        MethodHandle methodHandle = METHOD_HANDLE.bindTo(rowType).bindTo(fieldAppenders).bindTo(JsonUtil.getFieldNameToIndex(rowFields));
        return new ScalarFunctionImplementation(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), methodHandle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @UsedByGeneratedCode
    public static Block toRow(RowType rowType, JsonUtil.BlockBuilderAppender[] fieldAppenders, Optional<Map<String, Integer>> fieldNameToIndex, ConnectorSession connectorSession, Slice json) {
        try (JsonParser jsonParser = JsonUtil.createJsonParser(JsonUtil.JSON_FACTORY, json);){
            jsonParser.nextToken();
            if (jsonParser.getCurrentToken() == JsonToken.VALUE_NULL) {
                Block block2 = null;
                return block2;
            }
            if (jsonParser.getCurrentToken() != JsonToken.START_ARRAY && jsonParser.getCurrentToken() != JsonToken.START_OBJECT) {
                throw new JsonCastException(String.format("Expected a json array or object, but got %s", jsonParser.getText()));
            }
            BlockBuilder rowBlockBuilder = rowType.createBlockBuilder(null, 1);
            JsonUtil.parseJsonToSingleRowBlock(jsonParser, (SingleRowBlockWriter)rowBlockBuilder.beginBlockEntry(), fieldAppenders, fieldNameToIndex);
            rowBlockBuilder.closeEntry();
            if (jsonParser.nextToken() != null) {
                throw new JsonCastException(String.format("Unexpected trailing token: %s", jsonParser.getText()));
            }
            Block block = rowType.getObject((Block)rowBlockBuilder, 0);
            return block;
        }
        catch (PrestoException | JsonCastException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast to %s. %s\n%s", rowType, e.getMessage(), JsonUtil.truncateIfNecessaryForErrorMessage(json)), e);
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast to %s.\n%s", rowType, JsonUtil.truncateIfNecessaryForErrorMessage(json)), (Throwable)e);
        }
    }
}

