/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionDependencies;
import io.prestosql.metadata.FunctionDependencyDeclaration;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlOperator;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.type.TypeUtils;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public class MapHashCodeOperator
extends SqlOperator {
    public static final MapHashCodeOperator MAP_HASH_CODE = new MapHashCodeOperator();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapHashCodeOperator.class, "hash", MethodHandle.class, MethodHandle.class, Type.class, Type.class, Block.class);

    private MapHashCodeOperator() {
        super(OperatorType.HASH_CODE, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableTypeParameter("K"), (Object)Signature.comparableTypeParameter("V")), (List<LongVariableConstraint>)ImmutableList.of(), BigintType.BIGINT.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.mapType((TypeSignature)new TypeSignature("K", new TypeSignatureParameter[0]), (TypeSignature)new TypeSignature("V", new TypeSignatureParameter[0]))), false);
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies(FunctionBinding functionBinding) {
        Type keyType = functionBinding.getTypeVariable("K");
        Type valueType = functionBinding.getTypeVariable("V");
        return FunctionDependencyDeclaration.builder().addOperator(OperatorType.HASH_CODE, (List<Type>)ImmutableList.of((Object)keyType)).addOperator(OperatorType.HASH_CODE, (List<Type>)ImmutableList.of((Object)valueType)).build();
    }

    @Override
    public ScalarFunctionImplementation specialize(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        Type keyType = functionBinding.getTypeVariable("K");
        Type valueType = functionBinding.getTypeVariable("V");
        MethodHandle keyHashCodeFunction = functionDependencies.getOperatorInvoker(OperatorType.HASH_CODE, (List<Type>)ImmutableList.of((Object)keyType), Optional.empty()).getMethodHandle();
        MethodHandle valueHashCodeFunction = functionDependencies.getOperatorInvoker(OperatorType.HASH_CODE, (List<Type>)ImmutableList.of((Object)valueType), Optional.empty()).getMethodHandle();
        MethodHandle method = METHOD_HANDLE.bindTo(keyHashCodeFunction).bindTo(valueHashCodeFunction).bindTo(keyType).bindTo(valueType);
        return new ScalarFunctionImplementation(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), method);
    }

    @UsedByGeneratedCode
    public static long hash(MethodHandle keyHashCodeFunction, MethodHandle valueHashCodeFunction, Type keyType, Type valueType, Block block) {
        long result = 0L;
        for (int position = 0; position < block.getPositionCount(); position += 2) {
            result += TypeUtils.hashPosition(keyHashCodeFunction, keyType, block, position) ^ TypeUtils.hashPosition(valueHashCodeFunction, valueType, block, position + 1);
        }
        return result;
    }
}

