/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.SqlOperator;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.Chars;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.type.Re2JRegexp;
import io.prestosql.type.Re2JRegexpType;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Re2JCastToRegexpFunction
extends SqlOperator {
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(Re2JCastToRegexpFunction.class, "castToRegexp", Integer.TYPE, Integer.TYPE, Boolean.TYPE, Long.TYPE, Slice.class);
    private final int dfaStatesLimit;
    private final int dfaRetries;
    private final boolean padSpaces;

    public static SqlOperator castVarcharToRe2JRegexp(int dfaStatesLimit, int dfaRetries) {
        return new Re2JCastToRegexpFunction("varchar(x)", dfaStatesLimit, dfaRetries, false);
    }

    public static SqlOperator castCharToRe2JRegexp(int dfaStatesLimit, int dfaRetries) {
        return new Re2JCastToRegexpFunction("char(x)", dfaStatesLimit, dfaRetries, true);
    }

    private Re2JCastToRegexpFunction(String sourceType, int dfaStatesLimit, int dfaRetries, boolean padSpaces) {
        super(OperatorType.CAST, Collections.emptyList(), Collections.emptyList(), Re2JRegexpType.RE2J_REGEXP_SIGNATURE, (List<TypeSignature>)ImmutableList.of((Object)TypeSignatureTranslator.parseTypeSignature(sourceType, (Set<String>)ImmutableSet.of((Object)"x"))), false);
        this.dfaStatesLimit = dfaStatesLimit;
        this.dfaRetries = dfaRetries;
        this.padSpaces = padSpaces;
    }

    @Override
    protected ScalarFunctionImplementation specialize(FunctionBinding functionBinding) {
        return new ScalarFunctionImplementation(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), MethodHandles.insertArguments(METHOD_HANDLE, 0, this.dfaStatesLimit, this.dfaRetries, this.padSpaces, functionBinding.getLongVariable("x")));
    }

    @UsedByGeneratedCode
    public static Re2JRegexp castToRegexp(int dfaStatesLimit, int dfaRetries, boolean padSpaces, long typeLength, Slice pattern) {
        try {
            if (padSpaces) {
                pattern = Chars.padSpaces((Slice)pattern, (int)((int)typeLength));
            }
            return new Re2JRegexp(dfaStatesLimit, dfaRetries, pattern);
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }
}

