/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionDependencies;
import io.prestosql.metadata.FunctionDependencyDeclaration;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlOperator;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.util.Failures;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public class RowEqualOperator
extends SqlOperator {
    public static final RowEqualOperator ROW_EQUAL = new RowEqualOperator();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(RowEqualOperator.class, "equals", RowType.class, List.class, Block.class, Block.class);

    private RowEqualOperator() {
        super(OperatorType.EQUAL, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableWithVariadicBound("T", "row")), (List<LongVariableConstraint>)ImmutableList.of(), BooleanType.BOOLEAN.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("T", new TypeSignatureParameter[0]), (Object)new TypeSignature("T", new TypeSignatureParameter[0])), true);
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies(FunctionBinding functionBinding) {
        RowType rowType = (RowType)functionBinding.getTypeVariable("T");
        FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder = FunctionDependencyDeclaration.builder();
        rowType.getTypeParameters().forEach(type -> builder.addOperator(OperatorType.EQUAL, (List<Type>)ImmutableList.of((Object)type, (Object)type)));
        return builder.build();
    }

    @Override
    public ScalarFunctionImplementation specialize(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        RowType type = (RowType)functionBinding.getTypeVariable("T");
        return new ScalarFunctionImplementation(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), METHOD_HANDLE.bindTo(type).bindTo(RowEqualOperator.resolveFieldEqualOperators(type, functionDependencies)));
    }

    public static List<MethodHandle> resolveFieldEqualOperators(RowType rowType, FunctionDependencies functionDependencies) {
        return (List)rowType.getTypeParameters().stream().map(type -> RowEqualOperator.resolveEqualOperator(type, functionDependencies)).collect(ImmutableList.toImmutableList());
    }

    private static MethodHandle resolveEqualOperator(Type type, FunctionDependencies functionDependencies) {
        return functionDependencies.getOperatorInvoker(OperatorType.EQUAL, (List<Type>)ImmutableList.of((Object)type, (Object)type), Optional.empty()).getMethodHandle();
    }

    public static Boolean equals(RowType rowType, List<MethodHandle> fieldEqualOperators, Block leftRow, Block rightRow) {
        boolean indeterminate = false;
        for (int fieldIndex = 0; fieldIndex < leftRow.getPositionCount(); ++fieldIndex) {
            if (leftRow.isNull(fieldIndex) || rightRow.isNull(fieldIndex)) {
                indeterminate = true;
                continue;
            }
            Type fieldType = (Type)rowType.getTypeParameters().get(fieldIndex);
            Object leftField = TypeUtils.readNativeValue((Type)fieldType, (Block)leftRow, (int)fieldIndex);
            Object rightField = TypeUtils.readNativeValue((Type)fieldType, (Block)rightRow, (int)fieldIndex);
            try {
                MethodHandle equalOperator = fieldEqualOperators.get(fieldIndex);
                Boolean result = equalOperator.invoke(leftField, rightField);
                if (result == null) {
                    indeterminate = true;
                    continue;
                }
                if (result.booleanValue()) continue;
                return false;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (indeterminate) {
            return null;
        }
        return true;
    }
}

