/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.LabelNode;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionDependencies;
import io.prestosql.metadata.FunctionDependencyDeclaration;
import io.prestosql.metadata.FunctionInvoker;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlOperator;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.sql.gen.CachedInstanceBinder;
import io.prestosql.sql.gen.CallSiteBinder;
import io.prestosql.sql.gen.InvokeFunctionBytecodeExpression;
import io.prestosql.sql.gen.SqlTypeBytecodeExpression;
import io.prestosql.type.UnknownType;
import io.prestosql.util.CompilerUtils;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class RowIndeterminateOperator
extends SqlOperator {
    public static final RowIndeterminateOperator ROW_INDETERMINATE = new RowIndeterminateOperator();

    private RowIndeterminateOperator() {
        super(OperatorType.INDETERMINATE, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.withVariadicBound("T", "row")), (List<LongVariableConstraint>)ImmutableList.of(), BooleanType.BOOLEAN.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("T", new TypeSignatureParameter[0])), false);
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies(FunctionBinding functionBinding) {
        RowType rowType = (RowType)functionBinding.getTypeVariable("T");
        FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder = FunctionDependencyDeclaration.builder();
        rowType.getTypeParameters().forEach(type -> builder.addOperator(OperatorType.INDETERMINATE, (List<Type>)ImmutableList.of((Object)type)));
        return builder.build();
    }

    @Override
    public ScalarFunctionImplementation specialize(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        Preconditions.checkArgument((functionBinding.getArity() == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type type = functionBinding.getTypeVariable("T");
        Class<?> indeterminateOperatorClass = RowIndeterminateOperator.generateIndeterminate(type, functionDependencies);
        MethodHandle indeterminateMethod = Reflection.methodHandle(indeterminateOperatorClass, "indeterminate", type.getJavaType(), Boolean.TYPE);
        return new ScalarFunctionImplementation(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NULL_FLAG), indeterminateMethod);
    }

    private static Class<?> generateIndeterminate(Type type, FunctionDependencies functionDependencies) {
        CallSiteBinder binder = new CallSiteBinder();
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("RowIndeterminateOperator"), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        Parameter value = Parameter.arg((String)"value", (Class)type.getJavaType());
        Parameter isNull = Parameter.arg((String)"isNull", Boolean.TYPE);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "indeterminate", ParameterizedType.type(Boolean.TYPE), new Parameter[]{value, isNull});
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable wasNull = scope.declareVariable(Boolean.TYPE, "wasNull");
        body.append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
        CachedInstanceBinder cachedInstanceBinder = new CachedInstanceBinder(definition, binder);
        LabelNode end = new LabelNode("end");
        List fieldTypes = type.getTypeParameters();
        boolean hasUnknownFields = fieldTypes.stream().anyMatch(fieldType -> fieldType.equals((Object)UnknownType.UNKNOWN));
        body.append((BytecodeNode)new IfStatement("if isNull is true...", new Object[0]).condition((BytecodeNode)isNull).ifTrue((BytecodeNode)new BytecodeBlock().push(true).gotoLabel(end)));
        if (hasUnknownFields) {
            body.push(true).gotoLabel(end);
        } else {
            for (int i = 0; i < fieldTypes.size(); ++i) {
                IfStatement ifNullField = new IfStatement("if the field is null...", new Object[0]);
                ifNullField.condition((BytecodeNode)value.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)i)})).ifTrue((BytecodeNode)new BytecodeBlock().push(true).gotoLabel(end));
                Type fieldType2 = (Type)fieldTypes.get(i);
                FunctionMetadata functionMetadata = functionDependencies.getOperatorMetadata(OperatorType.INDETERMINATE, (List<Type>)ImmutableList.of((Object)fieldType2));
                Function<InvocationConvention, FunctionInvoker> functionInvokerProvider = invocationConvention -> functionDependencies.getOperatorInvoker(OperatorType.INDETERMINATE, (List<Type>)ImmutableList.of((Object)fieldType2), Optional.of(invocationConvention));
                BytecodeExpression element = SqlTypeBytecodeExpression.constantType(binder, fieldType2).getValue((BytecodeExpression)value, BytecodeExpressions.constantInt((int)i));
                ifNullField.ifFalse((BytecodeNode)new IfStatement("if the field is not null but indeterminate...", new Object[0]).condition((BytecodeNode)InvokeFunctionBytecodeExpression.invokeFunction(scope, cachedInstanceBinder, (Type)BooleanType.BOOLEAN, functionMetadata, functionInvokerProvider, element)).ifTrue((BytecodeNode)new BytecodeBlock().push(true).gotoLabel(end)));
                body.append((BytecodeNode)ifNullField);
            }
            body.push(false);
        }
        body.visitLabel(end).retBoolean();
        MethodDefinition constructorDefinition = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        BytecodeBlock constructorBody = constructorDefinition.getBody();
        Variable thisVariable = constructorDefinition.getThis();
        constructorBody.comment("super();").append((BytecodeNode)thisVariable).invokeConstructor(Object.class, new Class[0]);
        cachedInstanceBinder.generateInitializations(thisVariable, constructorBody);
        constructorBody.ret();
        return CompilerUtils.defineClass(definition, Object.class, binder.getBindings(), RowIndeterminateOperator.class.getClassLoader());
    }
}

