/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionDependencies;
import io.prestosql.metadata.FunctionDependencyDeclaration;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlOperator;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.RowEqualOperator;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class RowNotEqualOperator
extends SqlOperator {
    public static final RowNotEqualOperator ROW_NOT_EQUAL = new RowNotEqualOperator();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(RowNotEqualOperator.class, "notEqual", RowType.class, List.class, Block.class, Block.class);

    private RowNotEqualOperator() {
        super(OperatorType.NOT_EQUAL, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableWithVariadicBound("T", "row")), (List<LongVariableConstraint>)ImmutableList.of(), BooleanType.BOOLEAN.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)new TypeSignature("T", new TypeSignatureParameter[0]), (Object)new TypeSignature("T", new TypeSignatureParameter[0])), true);
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies(FunctionBinding functionBinding) {
        RowType rowType = (RowType)functionBinding.getTypeVariable("T");
        FunctionDependencyDeclaration.FunctionDependencyDeclarationBuilder builder = FunctionDependencyDeclaration.builder();
        rowType.getTypeParameters().forEach(type -> builder.addOperator(OperatorType.EQUAL, (List<Type>)ImmutableList.of((Object)type, (Object)type)));
        return builder.build();
    }

    @Override
    public ScalarFunctionImplementation specialize(FunctionBinding functionBinding, FunctionDependencies functionDependencies) {
        RowType type = (RowType)functionBinding.getTypeVariable("T");
        return new ScalarFunctionImplementation(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), METHOD_HANDLE.bindTo(type).bindTo(RowEqualOperator.resolveFieldEqualOperators(type, functionDependencies)));
    }

    @UsedByGeneratedCode
    public static Boolean notEqual(RowType rowType, List<MethodHandle> fieldEqualOperators, Block leftRow, Block rightRow) {
        Boolean result = RowEqualOperator.equals(rowType, fieldEqualOperators, leftRow, rightRow);
        if (result == null) {
            return null;
        }
        return result == false;
    }
}

