/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.InvocationConvention;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.TypeDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ScalarFunctionImplementation {
    private final List<ScalarImplementationChoice> choices;

    public ScalarFunctionImplementation(InvocationConvention.InvocationReturnConvention returnConvention, List<InvocationConvention.InvocationArgumentConvention> argumentConventions, MethodHandle methodHandle) {
        this(returnConvention, argumentConventions, Collections.nCopies(argumentConventions.size(), Optional.empty()), methodHandle, Optional.empty());
    }

    public ScalarFunctionImplementation(InvocationConvention.InvocationReturnConvention returnConvention, List<InvocationConvention.InvocationArgumentConvention> argumentConventions, MethodHandle methodHandle, Optional<MethodHandle> instanceFactory) {
        this(returnConvention, argumentConventions, Collections.nCopies(argumentConventions.size(), Optional.empty()), methodHandle, instanceFactory);
    }

    public ScalarFunctionImplementation(InvocationConvention.InvocationReturnConvention returnConvention, List<InvocationConvention.InvocationArgumentConvention> argumentConventions, List<Optional<Class<?>>> lambdaInterfaces, MethodHandle methodHandle, Optional<MethodHandle> instanceFactory) {
        this((List<ScalarImplementationChoice>)ImmutableList.of((Object)new ScalarImplementationChoice(returnConvention, argumentConventions, lambdaInterfaces, methodHandle, instanceFactory)));
    }

    public ScalarFunctionImplementation(List<ScalarImplementationChoice> choices) {
        Preconditions.checkArgument((!choices.isEmpty() ? 1 : 0) != 0, (Object)"choices is an empty list");
        this.choices = ImmutableList.copyOf(choices);
    }

    public List<ScalarImplementationChoice> getChoices() {
        return this.choices;
    }

    public static class ScalarImplementationChoice {
        private final MethodHandle methodHandle;
        private final Optional<MethodHandle> instanceFactory;
        private final InvocationConvention invocationConvention;
        private final List<Optional<Class<?>>> lambdaInterfaces;

        public ScalarImplementationChoice(InvocationConvention.InvocationReturnConvention returnConvention, List<InvocationConvention.InvocationArgumentConvention> argumentConventions, List<Optional<Class<?>>> lambdaInterfaces, MethodHandle methodHandle, Optional<MethodHandle> instanceFactory) {
            this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
            this.instanceFactory = Objects.requireNonNull(instanceFactory, "instanceFactory is null");
            if (instanceFactory.isPresent()) {
                TypeDescriptor.OfField instanceType = instanceFactory.get().type().returnType();
                Preconditions.checkArgument((boolean)instanceFactory.get().type().parameterList().isEmpty(), (Object)"instanceFactory should have no parameter");
                Preconditions.checkArgument((boolean)instanceType.equals(methodHandle.type().parameterType(0)), (Object)"methodHandle is not an instance method");
            }
            List<Class<?>> parameterList = methodHandle.type().parameterList();
            boolean hasSession = false;
            if (parameterList.contains(ConnectorSession.class)) {
                Preconditions.checkArgument((parameterList.stream().filter(ConnectorSession.class::equals).count() == 1L ? 1 : 0) != 0, (Object)"function implementation should have exactly one ConnectorSession parameter");
                if (instanceFactory.isEmpty()) {
                    Preconditions.checkArgument((parameterList.get(0) == ConnectorSession.class ? 1 : 0) != 0, (Object)"ConnectorSession must be the first argument when instanceFactory is not present");
                } else {
                    Preconditions.checkArgument((parameterList.get(1) == ConnectorSession.class ? 1 : 0) != 0, (Object)"ConnectorSession must be the second argument when instanceFactory is present");
                }
                hasSession = true;
            }
            this.lambdaInterfaces = ImmutableList.copyOf((Collection)Objects.requireNonNull(lambdaInterfaces, "lambdaInterfaces is null"));
            this.invocationConvention = new InvocationConvention(argumentConventions, returnConvention, hasSession, instanceFactory.isPresent());
            Preconditions.checkArgument((lambdaInterfaces.size() == argumentConventions.size() ? 1 : 0) != 0);
        }

        public MethodHandle getMethodHandle() {
            return this.methodHandle;
        }

        public Optional<MethodHandle> getInstanceFactory() {
            return this.instanceFactory;
        }

        public List<Optional<Class<?>>> getLambdaInterfaces() {
            return this.lambdaInterfaces;
        }

        public InvocationConvention getInvocationConvention() {
            return this.invocationConvention;
        }
    }
}

