/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionBinding;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.TypeUtils;
import io.prestosql.sql.gen.lambda.BinaryFunctionInterface;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public final class ZipWithFunction
extends SqlScalarFunction {
    public static final ZipWithFunction ZIP_WITH_FUNCTION = new ZipWithFunction();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ZipWithFunction.class, "zipWith", Type.class, Type.class, ArrayType.class, Object.class, Block.class, Block.class, BinaryFunctionInterface.class);
    private static final MethodHandle STATE_FACTORY = Reflection.methodHandle(ZipWithFunction.class, "createState", ArrayType.class);

    private ZipWithFunction() {
        super(new FunctionMetadata(new Signature("zip_with", (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("T"), (Object)Signature.typeVariable("U"), (Object)Signature.typeVariable("R")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.arrayType((TypeSignature)new TypeSignature("R", new TypeSignatureParameter[0])), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0])), (Object)TypeSignature.arrayType((TypeSignature)new TypeSignature("U", new TypeSignatureParameter[0])), (Object)TypeSignature.functionType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{new TypeSignature("U", new TypeSignatureParameter[0]), new TypeSignature("R", new TypeSignatureParameter[0])})), false), false, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false)), false, false, "Merge two arrays, element-wise, into a single array using the lambda function", FunctionKind.SCALAR));
    }

    @Override
    protected ScalarFunctionImplementation specialize(FunctionBinding functionBinding) {
        Type leftElementType = functionBinding.getTypeVariable("T");
        Type rightElementType = functionBinding.getTypeVariable("U");
        Type outputElementType = functionBinding.getTypeVariable("R");
        ArrayType outputArrayType = new ArrayType(outputElementType);
        return new ScalarFunctionImplementation(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List<InvocationConvention.InvocationArgumentConvention>)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.FUNCTION), (List<Optional<Class<?>>>)ImmutableList.of(Optional.empty(), Optional.empty(), Optional.of(BinaryFunctionInterface.class)), METHOD_HANDLE.bindTo(leftElementType).bindTo(rightElementType).bindTo(outputArrayType), Optional.of(STATE_FACTORY.bindTo(outputArrayType)));
    }

    public static Object createState(ArrayType arrayType) {
        return new PageBuilder((List)ImmutableList.of((Object)arrayType));
    }

    public static Block zipWith(Type leftElementType, Type rightElementType, ArrayType outputArrayType, Object state, Block leftBlock, Block rightBlock, BinaryFunctionInterface function) {
        Type outputElementType = outputArrayType.getElementType();
        int leftPositionCount = leftBlock.getPositionCount();
        int rightPositionCount = rightBlock.getPositionCount();
        int outputPositionCount = Math.max(leftPositionCount, rightPositionCount);
        PageBuilder pageBuilder = (PageBuilder)state;
        if (pageBuilder.isFull()) {
            pageBuilder.reset();
        }
        BlockBuilder arrayBlockBuilder = pageBuilder.getBlockBuilder(0);
        BlockBuilder blockBuilder = arrayBlockBuilder.beginBlockEntry();
        for (int position = 0; position < outputPositionCount; ++position) {
            Object output;
            Object left = position < leftPositionCount ? TypeUtils.readNativeValue((Type)leftElementType, (Block)leftBlock, (int)position) : null;
            Object right = position < rightPositionCount ? TypeUtils.readNativeValue((Type)rightElementType, (Block)rightBlock, (int)position) : null;
            try {
                output = function.apply(left, right);
            }
            catch (Throwable throwable) {
                arrayBlockBuilder.closeEntry();
                pageBuilder.declarePosition();
                Throwables.throwIfUnchecked((Throwable)throwable);
                throw new RuntimeException(throwable);
            }
            TypeUtils.writeNativeValue((Type)outputElementType, (BlockBuilder)blockBuilder, (Object)output);
        }
        arrayBlockBuilder.closeEntry();
        pageBuilder.declarePosition();
        return outputArrayType.getObject((Block)arrayBlockBuilder, arrayBlockBuilder.getPositionCount() - 1);
    }
}

