/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.time;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.XxHash64;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.AbstractLongType;
import io.prestosql.spi.type.TimeType;
import io.prestosql.type.Constraint;
import io.prestosql.type.DateTimes;
import java.nio.charset.StandardCharsets;

public final class TimeOperators {
    private TimeOperators() {
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @LiteralParameters(value={"p"})
    @SqlType(value="interval day to second")
    public static long subtract(@SqlType(value="time(p)") long left, @SqlType(value="time(p)") long right) {
        long interval = left - right;
        interval = DateTimes.rescaleWithRounding(interval, 12, 3);
        return interval;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="time(p)") long left, @SqlType(value="time(p)") long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="time(p)") long left, @SqlType(value="time(p)") long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="time(p)") long left, @SqlType(value="time(p)") long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="time(p)") long left, @SqlType(value="time(p)") long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="time(p)") long left, @SqlType(value="time(p)") long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="time(p)") long left, @SqlType(value="time(p)") long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x", "p"})
    @SqlType(value="time(p)")
    public static long castFromVarchar(@LiteralParameter(value="p") long precision, @SqlType(value="varchar(x)") Slice value) {
        try {
            long picos = DateTimes.parseTime(value.toStringUtf8());
            return DateTimes.round(picos, (int)(12L - precision)) % 86400000000000000L;
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Value cannot be cast to time: " + value.toStringUtf8(), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="time(p)") long value) {
        return AbstractLongType.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long xxHash64(@SqlType(value="time(p)") long value) {
        return XxHash64.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="time(p)") long value, @IsNull boolean isNull) {
        return isNull;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision)")
    public static long castToTime(@LiteralParameter(value="sourcePrecision") long sourcePrecision, @LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="time(sourcePrecision)") long time) {
        if (sourcePrecision <= targetPrecision) {
            return time;
        }
        return DateTimes.round(time, (int)(12L - targetPrecision)) % 86400000000000000L;
    }

    @ScalarOperator(value=OperatorType.ADD)
    @LiteralParameters(value={"p", "u"})
    @SqlType(value="time(u)")
    @Constraint(variable="u", expression="max(3, p)")
    public static long timePlusIntervalDayToSecond(@SqlType(value="time(p)") long time, @SqlType(value="interval day to second") long interval) {
        return TimeOperators.add(time, interval * 1000000000L);
    }

    @ScalarOperator(value=OperatorType.ADD)
    @LiteralParameters(value={"p", "u"})
    @SqlType(value="time(u)")
    @Constraint(variable="u", expression="max(3, p)")
    public static long intervalDayToSecondPlusTime(@SqlType(value="interval day to second") long interval, @SqlType(value="time(p)") long time) {
        return TimeOperators.timePlusIntervalDayToSecond(time, interval);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @LiteralParameters(value={"p", "u"})
    @SqlType(value="time(u)")
    @Constraint(variable="u", expression="max(3, p)")
    public static long timeMinusIntervalDayToSecond(@SqlType(value="time(p)") long time, @SqlType(value="interval day to second") long interval) {
        return TimeOperators.add(time, -interval * 1000000000L);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@LiteralParameter(value="p") long precision, @SqlType(value="time(p)") long value) {
        int size = (int)((long)(8 + (precision > 0L ? 1 : 0)) + precision);
        DynamicSliceOutput output = new DynamicSliceOutput(size);
        String formatted = String.format("%02d:%02d:%02d", value / 3600000000000000L, value / 60000000000000L % 60L, value / 1000000000000L % 60L);
        output.appendBytes(formatted.getBytes(StandardCharsets.UTF_8));
        if (precision > 0L) {
            long scaledFraction = value % 1000000000000L / DateTimes.scaleFactor((int)precision, 12);
            output.appendByte(46);
            output.appendBytes(String.format("%0" + precision + "d", scaledFraction).getBytes(StandardCharsets.UTF_8));
        }
        return output.slice();
    }

    public static long add(long picos, long delta) {
        long result = (picos + delta) % 86400000000000000L;
        if (result < 0L) {
            result += 86400000000000000L;
        }
        return result;
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    public static final class TimeDistinctFromOperator {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@SqlType(value="time(p)") long left, @IsNull boolean leftNull, @SqlType(value="time(p)") long right, @IsNull boolean rightNull) {
            if (leftNull != rightNull) {
                return true;
            }
            if (leftNull) {
                return false;
            }
            return TimeOperators.notEqual(left, right);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@BlockPosition @SqlType(value="time(p)", nativeContainerType=long.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="time(p)", nativeContainerType=long.class) Block right, @BlockIndex int rightPosition) {
            if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
                return true;
            }
            if (left.isNull(leftPosition)) {
                return false;
            }
            return TimeOperators.notEqual(TimeType.TIME.getLong(left, leftPosition), TimeType.TIME.getLong(right, rightPosition));
        }
    }
}

