/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.time;

import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.DateTimes;
import java.time.LocalDate;

@ScalarOperator(value=OperatorType.CAST)
public final class TimeToTimestampCast {
    private TimeToTimestampCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static long castToShort(@LiteralParameter(value="sourcePrecision") long sourcePrecision, @LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="time(sourcePrecision)") long time) {
        return TimeToTimestampCast.cast(sourcePrecision, targetPrecision, session, time);
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static LongTimestamp castToLong(@LiteralParameter(value="sourcePrecision") long sourcePrecision, @LiteralParameter(value="targetPrecision") long targetPrecision, ConnectorSession session, @SqlType(value="time(sourcePrecision)") long time) {
        long epochMicros = TimeToTimestampCast.cast(sourcePrecision, targetPrecision, session, time);
        return new LongTimestamp(epochMicros, (int)(time % 1000000L));
    }

    private static long cast(long sourcePrecision, long targetPrecision, ConnectorSession session, long time) {
        long epochDay = LocalDate.ofInstant(session.getStart(), session.getTimeZoneKey().getZoneId()).toEpochDay();
        long epochSecond = Math.multiplyExact(epochDay, 86400L) + time / 1000000000000L;
        long picoFraction = time % 1000000000000L;
        if (sourcePrecision > targetPrecision) {
            picoFraction = DateTimes.round(picoFraction, (int)(12L - targetPrecision));
        }
        long microFraction = DateTimes.rescale(picoFraction, 12, 6);
        return Math.multiplyExact(epochSecond, 1000000) + microFraction;
    }
}

