/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.DateTimes;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampToTimestampCast {
    private TimestampToTimestampCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static long shortToShort(@LiteralParameter(value="sourcePrecision") long sourcePrecision, @LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision)") long value) {
        long epochMicros = value;
        if (sourcePrecision <= targetPrecision) {
            return epochMicros;
        }
        return DateTimes.round(epochMicros, (int)(6L - targetPrecision));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static LongTimestamp shortToLong(@SqlType(value="timestamp(sourcePrecision)") long value) {
        return new LongTimestamp(value, 0);
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static long longToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision)") LongTimestamp value) {
        long epochMicros = value.getEpochMicros();
        if (targetPrecision < 6L) {
            return DateTimes.round(epochMicros, (int)(6L - targetPrecision));
        }
        if (DateTimes.roundToNearest(value.getPicosOfMicro(), 1000000L) == 1000000L) {
            ++epochMicros;
        }
        return epochMicros;
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static LongTimestamp longToLong(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision)") LongTimestamp value) {
        return new LongTimestamp(value.getEpochMicros(), (int)DateTimes.round(value.getPicosOfMicro(), (int)(12L - targetPrecision)));
    }
}

