/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.airlift.slice.Slice;
import io.prestosql.operator.scalar.DateTimeFunctions;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.util.DateTimeZoneIndex;
import org.joda.time.chrono.ISOChronology;

@Description(value="Truncate to the specified precision")
@ScalarFunction(value="date_trunc")
public final class DateTrunc {
    private DateTrunc() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static long truncate(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="timestamp(p) with time zone") long packedEpochMillis) {
        ISOChronology chronology = DateTimeZoneIndex.unpackChronology(packedEpochMillis);
        long epochMillis = DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis);
        epochMillis = DateTimeFunctions.getTimestampField(chronology, unit).roundFloor(epochMillis);
        return DateTimeEncoding.updateMillisUtc((long)epochMillis, (long)packedEpochMillis);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static LongTimestampWithTimeZone truncate(@SqlType(value="varchar(x)") Slice unit, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        ISOChronology chronology = DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey()));
        long epochMillis = timestamp.getEpochMillis();
        epochMillis = DateTimeFunctions.getTimestampField(chronology, unit).roundFloor(epochMillis);
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)epochMillis, (int)0, (short)timestamp.getTimeZoneKey());
    }
}

