/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.util.DateTimeZoneIndex;

@Description(value="Time zone minute of the given timestamp")
@ScalarFunction(value="timezone_minute")
public class TimeZoneMinute {
    private TimeZoneMinute() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p) with time zone") long packedEpochMillis) {
        return DateTimeZoneIndex.extractZoneOffsetMinutes(packedEpochMillis) % 60;
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        return DateTimeZoneIndex.extractZoneOffsetMinutes(timestamp.getEpochMillis(), timestamp.getTimeZoneKey()) % 60;
    }
}

