/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.prestosql.operator.scalar.timestamptz.TimestampWithTimeZoneOperators;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimestampWithTimeZoneType;

@ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
public final class TimestampWithTimeZoneDistinctFromOperator {
    private static final TimestampWithTimeZoneType SHORT_TYPE = TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0);
    private static final TimestampWithTimeZoneType LONG_TYPE = TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)4);

    private TimestampWithTimeZoneDistinctFromOperator() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@SqlType(value="timestamp(p) with time zone") long left, @IsNull boolean leftNull, @SqlType(value="timestamp(p) with time zone") long right, @IsNull boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        return TimestampWithTimeZoneOperators.NotEqual.notEqual(left, right);
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@BlockPosition @SqlType(value="timestamp(p) with time zone", nativeContainerType=long.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="timestamp(p) with time zone", nativeContainerType=long.class) Block right, @BlockIndex int rightPosition) {
        if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
            return true;
        }
        if (left.isNull(leftPosition)) {
            return false;
        }
        return TimestampWithTimeZoneOperators.NotEqual.notEqual(SHORT_TYPE.getLong(left, leftPosition), SHORT_TYPE.getLong(right, rightPosition));
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    public static boolean isDistinctFromShort(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone left, @IsNull boolean leftNull, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone right, @IsNull boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        return TimestampWithTimeZoneOperators.NotEqual.notEqual(left, right);
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    public static boolean isDistinctFromLong(@BlockPosition @SqlType(value="timestamp(p) with time zone", nativeContainerType=LongTimestampWithTimeZone.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="timestamp(p) with time zone", nativeContainerType=LongTimestampWithTimeZone.class) Block right, @BlockIndex int rightPosition) {
        if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
            return true;
        }
        if (left.isNull(leftPosition)) {
            return false;
        }
        return !LONG_TYPE.equalTo(left, leftPosition, right, rightPosition);
    }
}

