/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.airlift.slice.XxHash64;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.TimestampWithTimeZoneTypes;
import io.prestosql.type.Constraint;
import io.prestosql.type.DateTimes;
import org.joda.time.DateTimeField;
import org.joda.time.chrono.ISOChronology;

public final class TimestampWithTimeZoneOperators {
    private TimestampWithTimeZoneOperators() {
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    public static final class TimestampMinusTimestamp {
        @LiteralParameters(value={"p"})
        @SqlType(value="interval day to second")
        public static long subtract(@SqlType(value="timestamp(p) with time zone") long left, @SqlType(value="timestamp(p) with time zone") long right) {
            return DateTimeEncoding.unpackMillisUtc((long)left) - DateTimeEncoding.unpackMillisUtc((long)right);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="interval day to second")
        public static long subtract(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone left, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone right) {
            long interval = left.getEpochMillis() - right.getEpochMillis();
            int deltaPicos = left.getPicosOfMilli() - right.getPicosOfMilli();
            if (deltaPicos < 0 && DateTimes.roundToNearest(-deltaPicos, 1000000000L) == 1000000000L) {
                --interval;
            } else if (deltaPicos > 0 && DateTimes.roundToNearest(deltaPicos, 1000000000L) == 1000000000L) {
                ++interval;
            }
            return interval;
        }
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    public static final class TimestampMinusIntervalDayToSecond {
        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static long subtract(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p) with time zone") long timestamp, @SqlType(value="interval day to second") long interval) {
            return TimestampPlusIntervalDayToSecond.add(precision, timestamp, -interval);
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static LongTimestampWithTimeZone subtract(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp, @SqlType(value="interval day to second") long interval) {
            return TimestampPlusIntervalDayToSecond.add(timestamp, -interval);
        }
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    public static final class TimestampMinusIntervalYearToMonth {
        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p) with time zone")
        public static long subtract(@SqlType(value="timestamp(p) with time zone") long timestamp, @SqlType(value="interval year to month") long interval) {
            return TimestampPlusIntervalYearToMonth.add(timestamp, -interval);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p) with time zone")
        public static LongTimestampWithTimeZone subtract(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp, @SqlType(value="interval year to month") long interval) {
            return TimestampPlusIntervalYearToMonth.add(timestamp, -interval);
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class IntervalYearToMonthPlusTimestamp {
        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p) with time zone")
        public static long add(@SqlType(value="interval year to month") long interval, @SqlType(value="timestamp(p) with time zone") long timestamp) {
            return TimestampPlusIntervalYearToMonth.add(timestamp, interval);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p) with time zone")
        public static LongTimestampWithTimeZone add(@SqlType(value="interval year to month") long interval, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
            return TimestampPlusIntervalYearToMonth.add(timestamp, interval);
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class TimestampPlusIntervalYearToMonth {
        private static final DateTimeField MONTH_OF_YEAR_UTC = ISOChronology.getInstanceUTC().monthOfYear();

        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p) with time zone")
        public static long add(@SqlType(value="timestamp(p) with time zone") long packedEpochMillis, @SqlType(value="interval year to month") long interval) {
            long epochMillis = DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis);
            long result = MONTH_OF_YEAR_UTC.add(epochMillis, interval);
            return DateTimeEncoding.packDateTimeWithZone((long)result, (TimeZoneKey)DateTimeEncoding.unpackZoneKey((long)packedEpochMillis));
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="timestamp(p) with time zone")
        public static LongTimestampWithTimeZone add(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp, @SqlType(value="interval year to month") long interval) {
            long epochMillis = timestamp.getEpochMillis();
            long result = MONTH_OF_YEAR_UTC.add(epochMillis, interval);
            return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)result, (int)timestamp.getPicosOfMilli(), (short)timestamp.getTimeZoneKey());
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class IntervalDayToSecondPlusTimestamp {
        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static long add(@LiteralParameter(value="p") long precision, @SqlType(value="interval day to second") long interval, @SqlType(value="timestamp(p) with time zone") long timestamp) {
            return TimestampPlusIntervalDayToSecond.add(precision, timestamp, interval);
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static LongTimestampWithTimeZone add(@SqlType(value="interval day to second") long interval, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
            return TimestampPlusIntervalDayToSecond.add(timestamp, interval);
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class TimestampPlusIntervalDayToSecond {
        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static long add(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p) with time zone") long packedEpochMillis, @SqlType(value="interval day to second") long interval) {
            return DateTimeEncoding.packDateTimeWithZone((long)(DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis) + interval), (TimeZoneKey)DateTimeEncoding.unpackZoneKey((long)packedEpochMillis));
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="timestamp(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static LongTimestampWithTimeZone add(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp, @SqlType(value="interval day to second") long interval) {
            return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)(timestamp.getEpochMillis() + interval), (int)timestamp.getPicosOfMilli(), (short)timestamp.getTimeZoneKey());
        }
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    public static final class XxHash64Operator {
        @LiteralParameters(value={"p"})
        @SqlType(value="bigint")
        public static long xxHash64(@SqlType(value="timestamp(p) with time zone") long value) {
            return XxHash64.hash((long)DateTimeEncoding.unpackMillisUtc((long)value));
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="bigint")
        public static long xxHash64(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone value) {
            return XxHash64.hash((long)value.getEpochMillis()) ^ XxHash64.hash((long)value.getPicosOfMilli());
        }
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    public static final class Indeterminate {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean indeterminate(@SqlType(value="timestamp(p) with time zone") long value, @IsNull boolean isNull) {
            return isNull;
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean indeterminate(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone value, @IsNull boolean isNull) {
            return isNull;
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    public static final class HashCode {
        @SqlType(value="bigint")
        @LiteralParameters(value={"p"})
        public static long hashCode(@SqlType(value="timestamp(p) with time zone") long value) {
            return TimestampWithTimeZoneTypes.hashShortTimestampWithTimeZone((long)value);
        }

        @SqlType(value="bigint")
        @LiteralParameters(value={"p"})
        public static long hashCode(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone value) {
            return TimestampWithTimeZoneTypes.hashLongTimestampWithTimeZone((LongTimestampWithTimeZone)value);
        }
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    public static final class GreaterThanOrEqual {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean greaterThanOrEqual(@SqlType(value="timestamp(p) with time zone") long left, @SqlType(value="timestamp(p) with time zone") long right) {
            return !LessThan.lessThan(left, right);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean greaterThanOrEqual(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone left, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone right) {
            return !LessThan.lessThan(left, right);
        }
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    public static final class GreaterThan {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean greaterThan(@SqlType(value="timestamp(p) with time zone") long left, @SqlType(value="timestamp(p) with time zone") long right) {
            return !LessThanOrEqual.lessThanOrEqual(left, right);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean greaterThan(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone left, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone right) {
            return !LessThanOrEqual.lessThanOrEqual(left, right);
        }
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    public static final class LessThanOrEqual {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean lessThanOrEqual(@SqlType(value="timestamp(p) with time zone") long left, @SqlType(value="timestamp(p) with time zone") long right) {
            return DateTimeEncoding.unpackMillisUtc((long)left) <= DateTimeEncoding.unpackMillisUtc((long)right);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean lessThanOrEqual(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone left, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone right) {
            return left.getEpochMillis() < right.getEpochMillis() || left.getEpochMillis() == right.getEpochMillis() && left.getPicosOfMilli() <= right.getPicosOfMilli();
        }
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    public static final class LessThan {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean lessThan(@SqlType(value="timestamp(p) with time zone") long left, @SqlType(value="timestamp(p) with time zone") long right) {
            return DateTimeEncoding.unpackMillisUtc((long)left) < DateTimeEncoding.unpackMillisUtc((long)right);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean lessThan(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone left, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone right) {
            return left.getEpochMillis() < right.getEpochMillis() || left.getEpochMillis() == right.getEpochMillis() && left.getPicosOfMilli() < right.getPicosOfMilli();
        }
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    public static final class NotEqual {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean notEqual(@SqlType(value="timestamp(p) with time zone") long left, @SqlType(value="timestamp(p) with time zone") long right) {
            return Equal.equal(left, right) == false;
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean notEqual(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone left, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone right) {
            return Equal.equal(left, right) == false;
        }
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    public static final class Equal {
        @LiteralParameters(value={"p"})
        @SqlNullable
        @SqlType(value="boolean")
        public static Boolean equal(@SqlType(value="timestamp(p) with time zone") long left, @SqlType(value="timestamp(p) with time zone") long right) {
            return DateTimeEncoding.unpackMillisUtc((long)left) == DateTimeEncoding.unpackMillisUtc((long)right);
        }

        @LiteralParameters(value={"p"})
        @SqlNullable
        @SqlType(value="boolean")
        public static Boolean equal(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone left, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone right) {
            return left.getEpochMillis() == right.getEpochMillis() && left.getPicosOfMilli() == right.getPicosOfMilli();
        }
    }
}

