/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimeWithTimeZone;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.type.DateTimes;
import io.prestosql.util.DateTimeZoneIndex;
import java.time.Instant;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampWithTimeZoneToTimeWithTimezoneCast {
    private TimestampWithTimeZoneToTimeWithTimezoneCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision) with time zone")
    public static long shortToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision) with time zone") long packedTimestamp) {
        TimeZoneKey zoneKey = DateTimeEncoding.unpackZoneKey((long)packedTimestamp);
        long epochMillis = DateTimeZoneIndex.getChronology(zoneKey).getZone().convertUTCToLocal(DateTimeEncoding.unpackMillisUtc((long)packedTimestamp));
        if (targetPrecision <= 3L) {
            epochMillis = DateTimes.round(epochMillis, (int)(3L - targetPrecision));
        }
        long nanos = DateTimes.rescale(Math.floorMod(epochMillis, 86400000L), 3, 9);
        return DateTimeEncoding.packTimeWithTimeZone((long)nanos, (int)DateTimes.getOffsetMinutes(Instant.ofEpochMilli(epochMillis), zoneKey));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision) with time zone")
    public static long longToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision) with time zone") LongTimestampWithTimeZone timestamp) {
        TimeZoneKey zoneKey = TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey());
        long epochMillis = DateTimeZoneIndex.getChronology(zoneKey).getZone().convertUTCToLocal(timestamp.getEpochMillis());
        long picos = DateTimes.rescale(Math.floorMod(epochMillis, 86400000L), 3, 12) + (long)timestamp.getPicosOfMilli();
        picos = DateTimes.round(picos, (int)(12L - targetPrecision));
        picos = Math.floorMod(picos, 86400000000000000L);
        long nanos = DateTimes.rescale(picos, 12, 9);
        return DateTimeEncoding.packTimeWithTimeZone((long)nanos, (int)DateTimes.getOffsetMinutes(Instant.ofEpochMilli(epochMillis), zoneKey));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision) with time zone")
    public static LongTimeWithTimeZone shortToLong(@SqlType(value="timestamp(sourcePrecision) with time zone") long timestamp) {
        TimeZoneKey zoneKey = DateTimeEncoding.unpackZoneKey((long)timestamp);
        long epochMillis = DateTimeZoneIndex.getChronology(zoneKey).getZone().convertUTCToLocal(DateTimeEncoding.unpackMillisUtc((long)timestamp));
        long millis = Math.floorMod(epochMillis, 86400000L);
        return new LongTimeWithTimeZone(millis * 1000000000L, DateTimes.getOffsetMinutes(Instant.ofEpochMilli(epochMillis), zoneKey));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision) with time zone")
    public static LongTimeWithTimeZone longToLong(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision) with time zone") LongTimestampWithTimeZone timestamp) {
        TimeZoneKey zoneKey = TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey());
        long epochMillis = DateTimeZoneIndex.getChronology(zoneKey).getZone().convertUTCToLocal(timestamp.getEpochMillis());
        long picos = DateTimes.rescale(Math.floorMod(epochMillis, 86400000L), 3, 12) + (long)timestamp.getPicosOfMilli();
        picos = DateTimes.round(picos, (int)(12L - targetPrecision));
        return new LongTimeWithTimeZone(Math.floorMod(picos, 86400000000000000L), DateTimes.getOffsetMinutes(Instant.ofEpochMilli(epochMillis), zoneKey));
    }
}

