/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.type.DateTimes;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampWithTimeZoneToTimestampWithTimeZoneCast {
    private TimestampWithTimeZoneToTimestampWithTimeZoneCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision) with time zone")
    public static long shortToShort(@LiteralParameter(value="sourcePrecision") long sourcePrecision, @LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision) with time zone") long packedEpochMillis) {
        if (sourcePrecision <= targetPrecision) {
            return packedEpochMillis;
        }
        long epochMillis = DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis);
        epochMillis = DateTimes.round(epochMillis, (int)(3L - targetPrecision));
        return DateTimeEncoding.packDateTimeWithZone((long)epochMillis, (TimeZoneKey)DateTimeEncoding.unpackZoneKey((long)packedEpochMillis));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision) with time zone")
    public static LongTimestampWithTimeZone shortToLong(@SqlType(value="timestamp(sourcePrecision) with time zone") long packedEpochMillis) {
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis), (int)0, (TimeZoneKey)DateTimeEncoding.unpackZoneKey((long)packedEpochMillis));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision) with time zone")
    public static long longToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision) with time zone") LongTimestampWithTimeZone timestamp) {
        long epochMillis = timestamp.getEpochMillis();
        if (targetPrecision < 3L) {
            epochMillis = DateTimes.round(epochMillis, (int)(3L - targetPrecision));
        } else if (DateTimes.roundToNearest(timestamp.getPicosOfMilli(), 1000000000L) == 1000000000L) {
            ++epochMillis;
        }
        return DateTimeEncoding.packDateTimeWithZone((long)epochMillis, (short)timestamp.getTimeZoneKey());
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision) with time zone")
    public static LongTimestampWithTimeZone longToLong(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision) with time zone") LongTimestampWithTimeZone timestamp) {
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)timestamp.getEpochMillis(), (int)((int)DateTimes.round(timestamp.getPicosOfMilli(), (int)(12L - targetPrecision))), (short)timestamp.getTimeZoneKey());
    }
}

