/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.type.DateTimes;
import io.prestosql.util.DateTimeZoneIndex;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampWithTimezoneToTimestampCast {
    private TimestampWithTimezoneToTimestampCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static long shortToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision) with time zone") long timestamp) {
        long epochMillis = DateTimeZoneIndex.getChronology(DateTimeEncoding.unpackZoneKey((long)timestamp)).getZone().convertUTCToLocal(DateTimeEncoding.unpackMillisUtc((long)timestamp));
        return DateTimes.round(DateTimes.scaleEpochMillisToMicros(epochMillis), (int)(6L - targetPrecision));
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static long longToShort(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision) with time zone") LongTimestampWithTimeZone timestamp) {
        long epochMillis = DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey())).getZone().convertUTCToLocal(timestamp.getEpochMillis());
        int picosOfMilli = timestamp.getPicosOfMilli();
        long epochMicros = DateTimes.toEpochMicros(epochMillis, picosOfMilli);
        if (targetPrecision < 6L) {
            return DateTimes.round(epochMicros, (int)(6L - targetPrecision));
        }
        if (DateTimes.roundToNearest(timestamp.getPicosOfMilli(), 1000000000L) == 1000000000L) {
            ++epochMicros;
        }
        return epochMicros;
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static LongTimestamp shortToLong(@SqlType(value="timestamp(sourcePrecision) with time zone") long timestamp) {
        long epochMillis = DateTimeZoneIndex.getChronology(DateTimeEncoding.unpackZoneKey((long)timestamp)).getZone().convertUTCToLocal(DateTimeEncoding.unpackMillisUtc((long)timestamp));
        return new LongTimestamp(DateTimes.scaleEpochMillisToMicros(epochMillis), 0);
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="timestamp(targetPrecision)")
    public static LongTimestamp longToLong(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="timestamp(sourcePrecision) with time zone") LongTimestampWithTimeZone timestamp) {
        int picosOfMicro;
        long epochMicros;
        long epochMillis = DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey())).getZone().convertUTCToLocal(timestamp.getEpochMillis());
        if (targetPrecision <= 6L) {
            epochMicros = DateTimes.toEpochMicros(epochMillis, timestamp.getPicosOfMilli());
            epochMicros = DateTimes.round(epochMicros, (int)(6L - targetPrecision));
            picosOfMicro = 0;
        } else {
            int picosOfMilli = timestamp.getPicosOfMilli();
            epochMicros = DateTimes.toEpochMicros(epochMillis, picosOfMilli);
            picosOfMicro = (int)DateTimes.round(picosOfMilli % 1000000, (int)(12L - targetPrecision));
        }
        return new LongTimestamp(epochMicros, picosOfMicro);
    }
}

