/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timetz;

import io.prestosql.operator.scalar.timetz.TimeWithTimeZoneOperators;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimeWithTimeZone;
import io.prestosql.spi.type.TimeWithTimeZoneType;

@ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
public final class TimeWithTimeZoneDistinctFromOperator {
    private static final TimeWithTimeZoneType SHORT_TYPE = TimeWithTimeZoneType.createTimeWithTimeZoneType((int)0);
    private static final TimeWithTimeZoneType LONG_TYPE = TimeWithTimeZoneType.createTimeWithTimeZoneType((int)10);

    private TimeWithTimeZoneDistinctFromOperator() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@SqlType(value="time(p) with time zone") long left, @IsNull boolean leftNull, @SqlType(value="time(p) with time zone") long right, @IsNull boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        return TimeWithTimeZoneOperators.NotEqual.notEqual(left, right);
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@BlockPosition @SqlType(value="time(p) with time zone", nativeContainerType=long.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="time(p) with time zone", nativeContainerType=long.class) Block right, @BlockIndex int rightPosition) {
        if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
            return true;
        }
        if (left.isNull(leftPosition)) {
            return false;
        }
        return TimeWithTimeZoneOperators.NotEqual.notEqual(SHORT_TYPE.getLong(left, leftPosition), SHORT_TYPE.getLong(right, rightPosition));
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    public static boolean isDistinctFromShort(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone left, @IsNull boolean leftNull, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone right, @IsNull boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        return TimeWithTimeZoneOperators.NotEqual.notEqual(left, right);
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    public static boolean isDistinctFromLong(@BlockPosition @SqlType(value="time(p) with time zone", nativeContainerType=LongTimeWithTimeZone.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="time(p) with time zone", nativeContainerType=LongTimeWithTimeZone.class) Block right, @BlockIndex int rightPosition) {
        if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
            return true;
        }
        if (left.isNull(leftPosition)) {
            return false;
        }
        return !LONG_TYPE.equalTo(left, leftPosition, right, rightPosition);
    }
}

