/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timetz;

import io.airlift.slice.XxHash64;
import io.prestosql.operator.scalar.time.TimeOperators;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimeWithTimeZone;
import io.prestosql.spi.type.TimeWithTimezoneTypes;
import io.prestosql.type.Constraint;
import io.prestosql.type.DateTimes;

public final class TimeWithTimeZoneOperators {
    private TimeWithTimeZoneOperators() {
    }

    static long normalize(long packedTime) {
        long nanos = DateTimeEncoding.unpackTimeNanos((long)packedTime);
        int offsetMinutes = DateTimeEncoding.unpackOffsetMinutes((long)packedTime);
        return Math.floorMod(nanos - (long)offsetMinutes * 60000000000L, 86400000000000L);
    }

    static long normalize(LongTimeWithTimeZone time) {
        return Math.floorMod(time.getPicoSeconds() - (long)time.getOffsetMinutes() * 60000000000000L, 86400000000000000L);
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    public static final class TimeMinusTime {
        @LiteralParameters(value={"p"})
        @SqlType(value="interval day to second")
        public static long subtract(@SqlType(value="time(p) with time zone") long left, @SqlType(value="time(p) with time zone") long right) {
            long nanos = TimeWithTimeZoneOperators.normalize(left) - TimeWithTimeZoneOperators.normalize(right);
            return DateTimes.rescaleWithRounding(nanos, 9, 3);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="interval day to second")
        public static long subtract(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone left, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone right) {
            long picos = TimeWithTimeZoneOperators.normalize(left) - TimeWithTimeZoneOperators.normalize(right);
            return DateTimes.rescaleWithRounding(picos, 12, 3);
        }
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    public static final class TimeMinusIntervalDayToSecond {
        @LiteralParameters(value={"p", "u"})
        @SqlType(value="time(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static long subtract(@SqlType(value="time(p) with time zone") long packedTime, @SqlType(value="interval day to second") long interval) {
            return TimePlusIntervalDayToSecond.add(packedTime, -interval);
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="time(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static LongTimeWithTimeZone subtract(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone time, @SqlType(value="interval day to second") long interval) {
            return TimePlusIntervalDayToSecond.add(time, -interval);
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class IntervalDayToSecondPlusTime {
        @LiteralParameters(value={"p", "u"})
        @SqlType(value="time(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static long add(@SqlType(value="interval day to second") long interval, @SqlType(value="time(p) with time zone") long time) {
            return TimePlusIntervalDayToSecond.add(time, interval);
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="time(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static LongTimeWithTimeZone add(@SqlType(value="interval day to second") long interval, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone time) {
            return TimePlusIntervalDayToSecond.add(time, interval);
        }
    }

    @ScalarOperator(value=OperatorType.ADD)
    public static final class TimePlusIntervalDayToSecond {
        @LiteralParameters(value={"p", "u"})
        @SqlType(value="time(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static long add(@SqlType(value="time(p) with time zone") long packedTime, @SqlType(value="interval day to second") long interval) {
            long picos = DateTimeEncoding.unpackTimeNanos((long)packedTime) * 1000L;
            long nanos = TimeOperators.add(picos, interval * 1000000000L) / 1000L;
            return DateTimeEncoding.packTimeWithTimeZone((long)nanos, (int)DateTimeEncoding.unpackOffsetMinutes((long)packedTime));
        }

        @LiteralParameters(value={"p", "u"})
        @SqlType(value="time(u) with time zone")
        @Constraint(variable="u", expression="max(3, p)")
        public static LongTimeWithTimeZone add(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone time, @SqlType(value="interval day to second") long interval) {
            long picos = TimeOperators.add(time.getPicoSeconds(), interval * 1000000000L);
            return new LongTimeWithTimeZone(picos, time.getOffsetMinutes());
        }
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    public static final class XxHash64Operator {
        @LiteralParameters(value={"p"})
        @SqlType(value="bigint")
        public static long xxHash64(@SqlType(value="time(p) with time zone") long packedTime) {
            return XxHash64.hash((long)TimeWithTimeZoneOperators.normalize(packedTime));
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="bigint")
        public static long xxHash64(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone time) {
            return XxHash64.hash((long)TimeWithTimeZoneOperators.normalize(time));
        }
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    public static final class Indeterminate {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean indeterminate(@SqlType(value="time(p) with time zone") long value, @IsNull boolean isNull) {
            return isNull;
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean indeterminate(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone value, @IsNull boolean isNull) {
            return isNull;
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    public static final class HashCode {
        @SqlType(value="bigint")
        @LiteralParameters(value={"p"})
        public static long hashCode(@SqlType(value="time(p) with time zone") long packedTime) {
            return TimeWithTimezoneTypes.hashShortTimeWithTimeZone((long)packedTime);
        }

        @SqlType(value="bigint")
        @LiteralParameters(value={"p"})
        public static long hashCode(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone time) {
            return TimeWithTimezoneTypes.hashLongTimeWithTimeZone((LongTimeWithTimeZone)time);
        }
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    public static final class GreaterThanOrEqual {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean greaterThanOrEqual(@SqlType(value="time(p) with time zone") long left, @SqlType(value="time(p) with time zone") long right) {
            return !LessThan.lessThan(left, right);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean greaterThanOrEqual(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone left, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone right) {
            return !LessThan.lessThan(left, right);
        }
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    public static final class GreaterThan {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean greaterThan(@SqlType(value="time(p) with time zone") long left, @SqlType(value="time(p) with time zone") long right) {
            return !LessThanOrEqual.lessThanOrEqual(left, right);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean greaterThan(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone left, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone right) {
            return !LessThanOrEqual.lessThanOrEqual(left, right);
        }
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    public static final class LessThanOrEqual {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean lessThanOrEqual(@SqlType(value="time(p) with time zone") long left, @SqlType(value="time(p) with time zone") long right) {
            return TimeWithTimeZoneOperators.normalize(left) <= TimeWithTimeZoneOperators.normalize(right);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean lessThanOrEqual(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone left, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone right) {
            return TimeWithTimeZoneOperators.normalize(left) <= TimeWithTimeZoneOperators.normalize(right);
        }
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    public static final class LessThan {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean lessThan(@SqlType(value="time(p) with time zone") long left, @SqlType(value="time(p) with time zone") long right) {
            return TimeWithTimeZoneOperators.normalize(left) < TimeWithTimeZoneOperators.normalize(right);
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean lessThan(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone left, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone right) {
            return TimeWithTimeZoneOperators.normalize(left) < TimeWithTimeZoneOperators.normalize(right);
        }
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    public static final class NotEqual {
        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean notEqual(@SqlType(value="time(p) with time zone") long left, @SqlType(value="time(p) with time zone") long right) {
            return Equal.equal(left, right) == false;
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="boolean")
        public static boolean notEqual(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone left, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone right) {
            return Equal.equal(left, right) == false;
        }
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    public static final class Equal {
        @LiteralParameters(value={"p"})
        @SqlNullable
        @SqlType(value="boolean")
        public static Boolean equal(@SqlType(value="time(p) with time zone") long left, @SqlType(value="time(p) with time zone") long right) {
            return TimeWithTimeZoneOperators.normalize(left) == TimeWithTimeZoneOperators.normalize(right);
        }

        @LiteralParameters(value={"p"})
        @SqlNullable
        @SqlType(value="boolean")
        public static Boolean equal(@SqlType(value="time(p) with time zone") LongTimeWithTimeZone left, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone right) {
            return TimeWithTimeZoneOperators.normalize(left) == TimeWithTimeZoneOperators.normalize(right);
        }
    }
}

