/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.log.Logger;
import io.prestosql.spi.security.GroupProvider;
import io.prestosql.spi.security.GroupProviderFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class GroupProviderManager
implements GroupProvider {
    private static final Logger log = Logger.get(GroupProviderManager.class);
    private static final File GROUP_PROVIDER_CONFIGURATION = new File("etc/group-provider.properties");
    private static final String GROUP_PROVIDER_PROPERTY_NAME = "group-provider.name";
    private final Map<String, GroupProviderFactory> groupProviderFactories = new ConcurrentHashMap<String, GroupProviderFactory>();
    private final AtomicReference<Optional<GroupProvider>> configuredGroupProvider = new AtomicReference(Optional.empty());

    public void addGroupProviderFactory(GroupProviderFactory groupProviderFactory) {
        Objects.requireNonNull(groupProviderFactory, "groupProviderFactory is null");
        if (this.groupProviderFactories.putIfAbsent(groupProviderFactory.getName(), groupProviderFactory) != null) {
            throw new IllegalArgumentException(String.format("Group provider '%s' is already registered", groupProviderFactory.getName()));
        }
    }

    public void loadConfiguredGroupProvider() throws IOException {
        this.loadConfiguredGroupProvider(GROUP_PROVIDER_CONFIGURATION);
    }

    @VisibleForTesting
    void loadConfiguredGroupProvider(File groupProviderFile) throws IOException {
        if (this.configuredGroupProvider.get().isPresent() || !groupProviderFile.exists()) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>(ConfigurationLoader.loadPropertiesFrom((String)groupProviderFile.getPath()));
        String groupProviderName = (String)properties.remove(GROUP_PROVIDER_PROPERTY_NAME);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)groupProviderName) ? 1 : 0) != 0, (String)"Group provider configuration %s does not contain %s", (Object)groupProviderFile.getAbsoluteFile(), (Object)GROUP_PROVIDER_PROPERTY_NAME);
        this.setConfiguredGroupProvider(groupProviderName, properties);
    }

    private void setConfiguredGroupProvider(String name, Map<String, String> properties) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(properties, "properties is null");
        log.info("-- Loading group provider %s --", new Object[]{name});
        GroupProviderFactory groupProviderFactory = this.groupProviderFactories.get(name);
        Preconditions.checkState((groupProviderFactory != null ? 1 : 0) != 0, (String)"Group provider %s is not registered", (Object)name);
        GroupProvider groupProvider = groupProviderFactory.create((Map)ImmutableMap.copyOf(properties));
        Preconditions.checkState((boolean)this.configuredGroupProvider.compareAndSet(Optional.empty(), Optional.of(groupProvider)), (Object)"groupProvider is already set");
        log.info("-- Loaded group provider %s --", new Object[]{name});
    }

    public Set<String> getGroups(String user) {
        Objects.requireNonNull(user, "user is null");
        return (Set)this.configuredGroupProvider.get().map(provider -> provider.getGroups(user)).map(ImmutableSet::copyOf).orElse(ImmutableSet.of());
    }
}

