/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.server.EmbeddedDiscoveryModule;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.client.QueryResults;
import io.prestosql.cost.CostCalculator;
import io.prestosql.cost.CostCalculatorUsingExchanges;
import io.prestosql.cost.CostCalculatorWithEstimatedExchanges;
import io.prestosql.cost.CostComparator;
import io.prestosql.cost.StatsAndCosts;
import io.prestosql.cost.StatsCalculatorModule;
import io.prestosql.cost.TaskCountEstimator;
import io.prestosql.dispatcher.DispatchExecutor;
import io.prestosql.dispatcher.DispatchManager;
import io.prestosql.dispatcher.DispatchQueryFactory;
import io.prestosql.dispatcher.FailedDispatchQueryFactory;
import io.prestosql.dispatcher.LocalDispatchQueryFactory;
import io.prestosql.dispatcher.QueuedStatementResource;
import io.prestosql.event.QueryMonitor;
import io.prestosql.event.QueryMonitorConfig;
import io.prestosql.execution.ClusterSizeMonitor;
import io.prestosql.execution.ExplainAnalyzeContext;
import io.prestosql.execution.ForQueryExecution;
import io.prestosql.execution.QueryExecution;
import io.prestosql.execution.QueryExecutionMBean;
import io.prestosql.execution.QueryIdGenerator;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryManager;
import io.prestosql.execution.QueryPerformanceFetcher;
import io.prestosql.execution.QueryPreparer;
import io.prestosql.execution.RemoteTaskFactory;
import io.prestosql.execution.SqlQueryManager;
import io.prestosql.execution.TaskInfo;
import io.prestosql.execution.TaskManagerConfig;
import io.prestosql.execution.resourcegroups.InternalResourceGroupManager;
import io.prestosql.execution.resourcegroups.LegacyResourceGroupConfigurationManager;
import io.prestosql.execution.resourcegroups.ResourceGroupManager;
import io.prestosql.execution.scheduler.AllAtOnceExecutionPolicy;
import io.prestosql.execution.scheduler.ExecutionPolicy;
import io.prestosql.execution.scheduler.PhasedExecutionPolicy;
import io.prestosql.execution.scheduler.SplitSchedulerStats;
import io.prestosql.failuredetector.FailureDetectorModule;
import io.prestosql.memory.ClusterMemoryManager;
import io.prestosql.memory.ForMemoryManager;
import io.prestosql.memory.LowMemoryKiller;
import io.prestosql.memory.MemoryManagerConfig;
import io.prestosql.memory.NoneLowMemoryKiller;
import io.prestosql.memory.TotalReservationLowMemoryKiller;
import io.prestosql.memory.TotalReservationOnBlockedNodesLowMemoryKiller;
import io.prestosql.metadata.CatalogManager;
import io.prestosql.operator.ForScheduler;
import io.prestosql.server.DynamicFilterService;
import io.prestosql.server.EmbeddedDiscoveryConfig;
import io.prestosql.server.ForStatementResource;
import io.prestosql.server.ForWorkerInfo;
import io.prestosql.server.GenerateTraceTokenRequestFilter;
import io.prestosql.server.HttpRemoteTaskFactory;
import io.prestosql.server.NodeResource;
import io.prestosql.server.QueryExecutionFactoryModule;
import io.prestosql.server.QueryResource;
import io.prestosql.server.QuerySessionSupplier;
import io.prestosql.server.QueryStateInfoResource;
import io.prestosql.server.ResourceGroupStateInfoResource;
import io.prestosql.server.SessionSupplier;
import io.prestosql.server.StatementHttpExecutionMBean;
import io.prestosql.server.TaskUpdateRequest;
import io.prestosql.server.protocol.ExecutingStatementResource;
import io.prestosql.server.remotetask.RemoteTaskStats;
import io.prestosql.server.ui.WebUiModule;
import io.prestosql.server.ui.WorkerResource;
import io.prestosql.spi.memory.ClusterMemoryPoolManager;
import io.prestosql.spi.security.SelectedRole;
import io.prestosql.sql.analyzer.QueryExplainer;
import io.prestosql.sql.planner.PlanFragmenter;
import io.prestosql.sql.planner.PlanOptimizers;
import io.prestosql.sql.planner.RuleStatsRecorder;
import io.prestosql.transaction.ForTransactionManager;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionManager;
import io.prestosql.transaction.TransactionManagerConfig;
import io.prestosql.version.EmbedVersion;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.weakref.jmx.guice.ExportBinder;

public class CoordinatorModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.install((Module)new WebUiModule());
        this.install(ConditionalModule.installModuleIf(EmbeddedDiscoveryConfig.class, EmbeddedDiscoveryConfig::isEnabled, (Module)new EmbeddedDiscoveryModule()));
        DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("presto-coordinator");
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(QueryInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(QueryResults.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(SelectedRole.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(QueuedStatementResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ExecutingStatementResource.class);
        binder.bind(StatementHttpExecutionMBean.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(StatementHttpExecutionMBean.class).withGeneratedName();
        ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(HttpServerConfig.class, config -> {
            config.setMaxRequestHeaderSize(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
            config.setMaxResponseHeaderSize(DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        });
        binder.install((Module)new FailureDetectorModule());
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(NodeResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(WorkerResource.class);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("workerInfo", ForWorkerInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(StatsAndCosts.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(QueryMonitorConfig.class);
        binder.bind(QueryMonitor.class).in(Scopes.SINGLETON);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(QueryResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(QueryStateInfoResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ResourceGroupStateInfoResource.class);
        binder.bind(QueryIdGenerator.class).in(Scopes.SINGLETON);
        binder.bind(QueryManager.class).to(SqlQueryManager.class).in(Scopes.SINGLETON);
        binder.bind(QueryPreparer.class).in(Scopes.SINGLETON);
        binder.bind(SessionSupplier.class).to(QuerySessionSupplier.class).in(Scopes.SINGLETON);
        binder.bind(InternalResourceGroupManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(InternalResourceGroupManager.class).withGeneratedName();
        binder.bind(ResourceGroupManager.class).to(InternalResourceGroupManager.class);
        binder.bind(LegacyResourceGroupConfigurationManager.class).in(Scopes.SINGLETON);
        binder.bind(DispatchManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(DispatchManager.class).as("presto.execution:name=QueryManager");
        binder.bind(FailedDispatchQueryFactory.class).in(Scopes.SINGLETON);
        binder.bind(DispatchExecutor.class).in(Scopes.SINGLETON);
        binder.bind(DispatchQueryFactory.class).to(LocalDispatchQueryFactory.class);
        binder.bind(ClusterMemoryManager.class).in(Scopes.SINGLETON);
        binder.bind(ClusterMemoryPoolManager.class).to(ClusterMemoryManager.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("memoryManager", ForMemoryManager.class).withTracing().withConfigDefaults(config -> {
            config.setIdleTimeout(new Duration(30.0, TimeUnit.SECONDS));
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
        });
        this.bindLowMemoryKiller(MemoryManagerConfig.LowMemoryKillerPolicy.NONE, NoneLowMemoryKiller.class);
        this.bindLowMemoryKiller(MemoryManagerConfig.LowMemoryKillerPolicy.TOTAL_RESERVATION, TotalReservationLowMemoryKiller.class);
        this.bindLowMemoryKiller(MemoryManagerConfig.LowMemoryKillerPolicy.TOTAL_RESERVATION_ON_BLOCKED_NODES, TotalReservationOnBlockedNodesLowMemoryKiller.class);
        ExportBinder.newExporter((Binder)binder).export(ClusterMemoryManager.class).withGeneratedName();
        binder.bind(ClusterSizeMonitor.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ClusterSizeMonitor.class).withGeneratedName();
        binder.install((Module)new StatsCalculatorModule());
        binder.bind(TaskCountEstimator.class).in(Scopes.SINGLETON);
        binder.bind(CostCalculator.class).to(CostCalculatorUsingExchanges.class).in(Scopes.SINGLETON);
        binder.bind(CostCalculator.class).annotatedWith(CostCalculator.EstimatedExchanges.class).to(CostCalculatorWithEstimatedExchanges.class).in(Scopes.SINGLETON);
        binder.bind(CostComparator.class).in(Scopes.SINGLETON);
        binder.bind(DynamicFilterService.class).in(Scopes.SINGLETON);
        binder.bind(PlanFragmenter.class).in(Scopes.SINGLETON);
        binder.bind(PlanOptimizers.class).in(Scopes.SINGLETON);
        binder.bind(RuleStatsRecorder.class).in(Scopes.SINGLETON);
        binder.bind(QueryExplainer.class).in(Scopes.SINGLETON);
        binder.bind(ExplainAnalyzeContext.class).in(Scopes.SINGLETON);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskUpdateRequest.class);
        binder.bind(RemoteTaskFactory.class).to(HttpRemoteTaskFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(RemoteTaskFactory.class).withGeneratedName();
        binder.bind(RemoteTaskStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(RemoteTaskStats.class).withGeneratedName();
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("scheduler", ForScheduler.class).withTracing().withFilter(GenerateTraceTokenRequestFilter.class).withConfigDefaults(config -> {
            config.setIdleTimeout(new Duration(30.0, TimeUnit.SECONDS));
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
            config.setMaxConnectionsPerServer(250);
        });
        binder.bind(ScheduledExecutorService.class).annotatedWith(ForScheduler.class).toInstance((Object)Executors.newSingleThreadScheduledExecutor(Threads.threadsNamed((String)"stage-scheduler")));
        binder.bind(ExecutorService.class).annotatedWith(ForQueryExecution.class).toInstance((Object)Executors.newCachedThreadPool(Threads.threadsNamed((String)"query-execution-%s")));
        binder.bind(QueryExecutionMBean.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(QueryExecutionMBean.class).as(generator -> generator.generatedNameOf(QueryExecution.class));
        binder.bind(SplitSchedulerStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(SplitSchedulerStats.class).withGeneratedName();
        MapBinder executionPolicyBinder = MapBinder.newMapBinder((Binder)binder, String.class, ExecutionPolicy.class);
        executionPolicyBinder.addBinding((Object)"all-at-once").to(AllAtOnceExecutionPolicy.class);
        executionPolicyBinder.addBinding((Object)"phased").to(PhasedExecutionPolicy.class);
        this.install(new QueryExecutionFactoryModule());
        binder.bind(ExecutorCleanup.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public static ResourceGroupManager<?> getResourceGroupManager(ResourceGroupManager manager) {
        return manager;
    }

    @Provides
    @Singleton
    public static QueryPerformanceFetcher createQueryPerformanceFetcher(QueryManager queryManager) {
        return queryManager::getFullQueryInfo;
    }

    @Provides
    @Singleton
    @ForStatementResource
    public static ExecutorService createStatementResponseCoreExecutor() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"statement-response-%s"));
    }

    @Provides
    @Singleton
    @ForStatementResource
    public static BoundedExecutor createStatementResponseExecutor(@ForStatementResource ExecutorService coreExecutor, TaskManagerConfig config) {
        return new BoundedExecutor((Executor)coreExecutor, config.getHttpResponseThreads());
    }

    @Provides
    @Singleton
    @ForStatementResource
    public static ScheduledExecutorService createStatementTimeoutExecutor(TaskManagerConfig config) {
        return Executors.newScheduledThreadPool(config.getHttpTimeoutThreads(), Threads.daemonThreadsNamed((String)"statement-timeout-%s"));
    }

    @Provides
    @Singleton
    @ForTransactionManager
    public static ScheduledExecutorService createTransactionIdleCheckExecutor() {
        return Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"transaction-idle-check"));
    }

    @Provides
    @Singleton
    @ForTransactionManager
    public static ExecutorService createTransactionFinishingExecutor() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"transaction-finishing-%s"));
    }

    @Provides
    @Singleton
    public static TransactionManager createTransactionManager(TransactionManagerConfig config, CatalogManager catalogManager, EmbedVersion embedVersion, @ForTransactionManager ScheduledExecutorService idleCheckExecutor, @ForTransactionManager ExecutorService finishingExecutor) {
        return InMemoryTransactionManager.create(config, idleCheckExecutor, catalogManager, embedVersion.embedVersion(finishingExecutor));
    }

    private void bindLowMemoryKiller(MemoryManagerConfig.LowMemoryKillerPolicy policy, Class<? extends LowMemoryKiller> clazz) {
        this.install(ConditionalModule.installModuleIf(MemoryManagerConfig.class, config -> policy == config.getLowMemoryKillerPolicy(), binder -> binder.bind(LowMemoryKiller.class).to(clazz).in(Scopes.SINGLETON)));
    }

    public static class ExecutorCleanup {
        private final List<ExecutorService> executors;

        @Inject
        public ExecutorCleanup(@ForStatementResource ExecutorService statementResponseExecutor, @ForStatementResource ScheduledExecutorService statementTimeoutExecutor, @ForQueryExecution ExecutorService queryExecutionExecutor, @ForScheduler ScheduledExecutorService schedulerExecutor, @ForTransactionManager ExecutorService transactionFinishingExecutor, @ForTransactionManager ScheduledExecutorService transactionIdleExecutor) {
            this.executors = ImmutableList.builder().add((Object)statementResponseExecutor).add((Object)statementTimeoutExecutor).add((Object)queryExecutionExecutor).add((Object)schedulerExecutor).add((Object)transactionFinishingExecutor).add((Object)transactionIdleExecutor).build();
        }

        @PreDestroy
        public void shutdown() {
            this.executors.forEach(ExecutorService::shutdownNow);
        }
    }
}

