/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import io.prestosql.Session;
import io.prestosql.execution.DynamicFilterConfig;
import io.prestosql.execution.SqlQueryExecution;
import io.prestosql.execution.StageState;
import io.prestosql.operator.JoinUtils;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.DynamicFilter;
import io.prestosql.spi.predicate.DiscreteValues;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Ranges;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.sql.DynamicFilters;
import io.prestosql.sql.planner.ExpressionExtractor;
import io.prestosql.sql.planner.PlanFragment;
import io.prestosql.sql.planner.SubPlan;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SystemPartitioningHandle;
import io.prestosql.sql.planner.optimizations.PlanNodeSearcher;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.SemiJoinNode;
import io.prestosql.util.MorePredicates;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class DynamicFilterService {
    private final Duration dynamicFilteringRefreshInterval;
    private final ScheduledExecutorService collectDynamicFiltersExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"DynamicFilterService"));
    private final Map<QueryId, DynamicFilterContext> dynamicFilterContexts = new ConcurrentHashMap<QueryId, DynamicFilterContext>();

    @Inject
    public DynamicFilterService(DynamicFilterConfig dynamicFilterConfig) {
        this.dynamicFilteringRefreshInterval = Objects.requireNonNull(dynamicFilterConfig, "dynamicFilterConfig is null").getDynamicFilteringRefreshInterval();
    }

    @PostConstruct
    public void start() {
        this.collectDynamicFiltersExecutor.scheduleWithFixedDelay(this::collectDynamicFilters, 0L, this.dynamicFilteringRefreshInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void stop() {
        this.collectDynamicFiltersExecutor.shutdownNow();
    }

    public void registerQuery(SqlQueryExecution sqlQueryExecution, SubPlan fragmentedPlan) {
        PlanNode queryPlan = sqlQueryExecution.getQueryPlan().getRoot();
        Set<DynamicFilterId> dynamicFilters = DynamicFilterService.getProducedDynamicFilters(queryPlan);
        Set<DynamicFilterId> replicatedDynamicFilters = DynamicFilterService.getReplicatedDynamicFilters(queryPlan);
        Set lazyDynamicFilters = (Set)fragmentedPlan.getAllFragments().stream().flatMap(plan -> DynamicFilterService.getLazyDynamicFilters(plan).stream()).collect(ImmutableSet.toImmutableSet());
        if (!dynamicFilters.isEmpty()) {
            this.registerQuery(sqlQueryExecution.getQueryId(), sqlQueryExecution::getStageDynamicFilters, dynamicFilters, lazyDynamicFilters, replicatedDynamicFilters);
        }
    }

    @VisibleForTesting
    public void registerQuery(QueryId queryId, Supplier<List<StageDynamicFilters>> stageDynamicFiltersSupplier, Set<DynamicFilterId> dynamicFilters, Set<DynamicFilterId> lazyDynamicFilters, Set<DynamicFilterId> replicatedDynamicFilters) {
        Map lazyDynamicFilterFutures = (Map)lazyDynamicFilters.stream().collect(ImmutableMap.toImmutableMap(filter -> filter, filter -> SettableFuture.create()));
        this.dynamicFilterContexts.putIfAbsent(queryId, new DynamicFilterContext(stageDynamicFiltersSupplier, dynamicFilters, lazyDynamicFilterFutures, replicatedDynamicFilters));
    }

    public DynamicFiltersStats getDynamicFilteringStats(QueryId queryId, Session session) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(queryId);
        if (context == null) {
            return DynamicFiltersStats.EMPTY;
        }
        int lazyFilters = context.getLazyDynamicFilters().size();
        int replicatedFilters = context.getReplicatedDynamicFilters().size();
        int totalDynamicFilters = context.getTotalDynamicFilters();
        List dynamicFilterDomainStats = (List)context.getDynamicFilterSummaries().entrySet().stream().map(entry -> {
            DynamicFilterId dynamicFilterId = (DynamicFilterId)entry.getKey();
            Domain domain = (Domain)entry.getValue();
            String simplifiedDomain = domain.simplify(1).toString(session.toConnectorSession());
            int rangeCount = (Integer)domain.getValues().getValuesProcessor().transform(Ranges::getRangeCount, discreteValues -> 0, allOrNone -> 0);
            int discreteValuesCount = (Integer)domain.getValues().getValuesProcessor().transform(ranges -> 0, DiscreteValues::getValuesCount, allOrNone -> 0);
            return new DynamicFilterDomainStats(dynamicFilterId, simplifiedDomain, rangeCount, discreteValuesCount);
        }).collect(ImmutableList.toImmutableList());
        return new DynamicFiltersStats(dynamicFilterDomainStats, lazyFilters, replicatedFilters, totalDynamicFilters, dynamicFilterDomainStats.size());
    }

    public void removeQuery(QueryId queryId) {
        this.dynamicFilterContexts.remove(queryId);
    }

    public boolean isCollectingTaskNeeded(QueryId queryId, PlanFragment plan) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(queryId);
        if (context == null) {
            return false;
        }
        return !DynamicFilterService.getSourceStageInnerLazyDynamicFilters(plan).isEmpty();
    }

    public void unblockStageDynamicFilters(QueryId queryId, PlanFragment plan) {
        DynamicFilterContext context = this.dynamicFilterContexts.get(queryId);
        if (context == null) {
            return;
        }
        DynamicFilterService.getSourceStageInnerLazyDynamicFilters(plan).forEach(filter -> Objects.requireNonNull(context.getLazyDynamicFilters().get(filter), "Future not found").set(null));
    }

    public DynamicFilter createDynamicFilter(QueryId queryId, List<DynamicFilters.Descriptor> dynamicFilterDescriptors, Map<Symbol, ColumnHandle> columnHandles) {
        final Multimap<DynamicFilterId, ColumnHandle> sourceColumnHandles = DynamicFilterService.extractSourceColumnHandles(dynamicFilterDescriptors, columnHandles);
        final Set dynamicFilters = (Set)dynamicFilterDescriptors.stream().map(DynamicFilters.Descriptor::getId).collect(ImmutableSet.toImmutableSet());
        final DynamicFilterContext context = this.dynamicFilterContexts.get(queryId);
        if (context == null) {
            return DynamicFilter.EMPTY;
        }
        final List lazyDynamicFilterFutures = (List)dynamicFilters.stream().map(context.getLazyDynamicFilters()::get).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        final AtomicReference<CurrentDynamicFilter> currentDynamicFilter = new AtomicReference<CurrentDynamicFilter>(new CurrentDynamicFilter(0, (TupleDomain<ColumnHandle>)TupleDomain.all()));
        return new DynamicFilter(){

            public CompletableFuture<?> isBlocked() {
                List undoneFutures = (List)lazyDynamicFilterFutures.stream().filter(future -> !future.isDone()).collect(ImmutableList.toImmutableList());
                if (undoneFutures.isEmpty()) {
                    return NOT_BLOCKED;
                }
                return MoreFutures.unmodifiableFuture((CompletableFuture)MoreFutures.toCompletableFuture((ListenableFuture)MoreFutures.whenAnyComplete((Iterable)undoneFutures)));
            }

            public boolean isComplete() {
                return dynamicFilters.stream().allMatch(context.getDynamicFilterSummaries()::containsKey);
            }

            public boolean isAwaitable() {
                return lazyDynamicFilterFutures.stream().anyMatch(future -> !future.isDone());
            }

            public TupleDomain<ColumnHandle> getCurrentPredicate() {
                Set completedDynamicFilters = (Set)dynamicFilters.stream().filter(filter -> context.getDynamicFilterSummaries().containsKey(filter)).collect(ImmutableSet.toImmutableSet());
                CurrentDynamicFilter currentFilter = (CurrentDynamicFilter)currentDynamicFilter.get();
                if (currentFilter.getCompletedDynamicFiltersCount() >= completedDynamicFilters.size()) {
                    return currentFilter.getDynamicFilter();
                }
                TupleDomain dynamicFilter = completedDynamicFilters.stream().map(filter -> DynamicFilterService.translateSummaryToTupleDomain(filter, context.getDynamicFilterSummaries().get(filter), (Multimap<DynamicFilterId, ColumnHandle>)sourceColumnHandles)).reduce(TupleDomain.all(), TupleDomain::intersect);
                currentDynamicFilter.set(new CurrentDynamicFilter(completedDynamicFilters.size(), (TupleDomain<ColumnHandle>)dynamicFilter));
                return dynamicFilter;
            }
        };
    }

    @VisibleForTesting
    void collectDynamicFilters() {
        for (DynamicFilterContext context : this.dynamicFilterContexts.values()) {
            if (context.isCompleted()) continue;
            Set<DynamicFilterId> uncollectedFilters = context.getUncollectedDynamicFilters();
            ImmutableMap.Builder newDynamicFiltersBuilder = ImmutableMap.builder();
            for (StageDynamicFilters stageDynamicFilters : context.getDynamicFilterSupplier().get()) {
                StageState stageState = stageDynamicFilters.getStageState();
                stageDynamicFilters.getTaskDynamicFilters().stream().flatMap(taskDomains -> taskDomains.entrySet().stream()).filter(domain -> uncollectedFilters.contains(domain.getKey())).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, ImmutableList.toImmutableList()))).entrySet().stream().filter(stageDomains -> {
                    if (((ImmutableList)stageDomains.getValue()).stream().anyMatch(Domain::isAll)) {
                        return true;
                    }
                    if (context.getReplicatedDynamicFilters().contains(stageDomains.getKey())) {
                        Preconditions.checkState((((ImmutableList)stageDomains.getValue()).size() == 1 ? 1 : 0) != 0, (Object)"Replicated dynamic filter should be collected from single task");
                        return true;
                    }
                    return !stageState.canScheduleMoreTasks() && ((ImmutableList)stageDomains.getValue()).size() == stageDynamicFilters.getNumberOfTasks();
                }).forEach(stageDomains -> newDynamicFiltersBuilder.put((Object)((DynamicFilterId)stageDomains.getKey()), (Object)Domain.union((List)((List)stageDomains.getValue()))));
            }
            context.addDynamicFilters((Map<DynamicFilterId, Domain>)newDynamicFiltersBuilder.build());
        }
    }

    @VisibleForTesting
    Optional<Domain> getSummary(QueryId queryId, DynamicFilterId filterId) {
        return Optional.ofNullable(this.dynamicFilterContexts.get(queryId).getDynamicFilterSummaries().get(filterId));
    }

    private static TupleDomain<ColumnHandle> translateSummaryToTupleDomain(DynamicFilterId filterId, Domain summary, Multimap<DynamicFilterId, ColumnHandle> sourceColumnHandles) {
        Preconditions.checkState((boolean)sourceColumnHandles.containsKey((Object)filterId), (String)"No source column handles for dynamic filter %s", (Object)filterId);
        return TupleDomain.withColumnDomains((Map)((Map)sourceColumnHandles.get((Object)filterId).stream().collect(ImmutableMap.toImmutableMap(handle -> handle, handle -> summary))));
    }

    private static Multimap<DynamicFilterId, ColumnHandle> extractSourceColumnHandles(List<DynamicFilters.Descriptor> dynamicFilters, Map<Symbol, ColumnHandle> columnHandles) {
        return (Multimap)dynamicFilters.stream().collect(ImmutableListMultimap.toImmutableListMultimap(DynamicFilters.Descriptor::getId, descriptor -> (ColumnHandle)columnHandles.get(Symbol.from(descriptor.getInput()))));
    }

    private static Set<DynamicFilterId> getLazyDynamicFilters(PlanFragment plan) {
        Sets.SetView interStageDynamicFilters = Sets.difference(DynamicFilterService.getProducedDynamicFilters(plan.getRoot()), DynamicFilterService.getConsumedDynamicFilters(plan.getRoot()));
        return ImmutableSet.copyOf((Collection)Sets.union((Set)interStageDynamicFilters, DynamicFilterService.getSourceStageInnerLazyDynamicFilters(plan)));
    }

    @VisibleForTesting
    static Set<DynamicFilterId> getSourceStageInnerLazyDynamicFilters(PlanFragment plan) {
        if (!plan.getPartitioning().equals(SystemPartitioningHandle.SOURCE_DISTRIBUTION)) {
            return ImmutableSet.of();
        }
        PlanNode planNode = plan.getRoot();
        Sets.SetView innerStageDynamicFilters = Sets.intersection(DynamicFilterService.getProducedDynamicFilters(planNode), DynamicFilterService.getConsumedDynamicFilters(planNode));
        Set<DynamicFilterId> replicatedDynamicFilters = DynamicFilterService.getReplicatedDynamicFilters(planNode);
        return ImmutableSet.copyOf((Collection)Sets.intersection((Set)innerStageDynamicFilters, replicatedDynamicFilters));
    }

    private static Set<DynamicFilterId> getReplicatedDynamicFilters(PlanNode planNode) {
        return (Set)PlanNodeSearcher.searchFrom(planNode).where(MorePredicates.isInstanceOfAny(JoinNode.class, SemiJoinNode.class)).findAll().stream().filter(JoinUtils::isBuildSideReplicated).flatMap(node -> DynamicFilterService.getDynamicFiltersProducedInPlanNode(node).stream()).collect(ImmutableSet.toImmutableSet());
    }

    private static Set<DynamicFilterId> getProducedDynamicFilters(PlanNode planNode) {
        return (Set)PlanNodeSearcher.searchFrom(planNode).where(MorePredicates.isInstanceOfAny(JoinNode.class, SemiJoinNode.class)).findAll().stream().flatMap(node -> DynamicFilterService.getDynamicFiltersProducedInPlanNode(node).stream()).collect(ImmutableSet.toImmutableSet());
    }

    private static Set<DynamicFilterId> getDynamicFiltersProducedInPlanNode(PlanNode planNode) {
        if (planNode instanceof JoinNode) {
            return ((JoinNode)planNode).getDynamicFilters().keySet();
        }
        if (planNode instanceof SemiJoinNode) {
            return (Set)((SemiJoinNode)planNode).getDynamicFilterId().map(ImmutableSet::of).orElse(ImmutableSet.of());
        }
        throw new IllegalStateException("getDynamicFiltersProducedInPlanNode called with neither JoinNode nor SemiJoinNode");
    }

    private static Set<DynamicFilterId> getConsumedDynamicFilters(PlanNode planNode) {
        return (Set)ExpressionExtractor.extractExpressions(planNode).stream().flatMap(expression -> DynamicFilters.extractDynamicFilters(expression).getDynamicConjuncts().stream()).map(DynamicFilters.Descriptor::getId).collect(ImmutableSet.toImmutableSet());
    }

    private static class CurrentDynamicFilter {
        private final int completedDynamicFiltersCount;
        private final TupleDomain<ColumnHandle> dynamicFilter;

        private CurrentDynamicFilter(int completedDynamicFiltersCount, TupleDomain<ColumnHandle> dynamicFilter) {
            this.completedDynamicFiltersCount = completedDynamicFiltersCount;
            this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilter is null");
        }

        private int getCompletedDynamicFiltersCount() {
            return this.completedDynamicFiltersCount;
        }

        private TupleDomain<ColumnHandle> getDynamicFilter() {
            return this.dynamicFilter;
        }
    }

    private static class DynamicFilterContext {
        private final Map<DynamicFilterId, Domain> dynamicFilterSummaries = new ConcurrentHashMap<DynamicFilterId, Domain>();
        private final Supplier<List<StageDynamicFilters>> dynamicFilterSupplier;
        private final Set<DynamicFilterId> dynamicFilters;
        private final Map<DynamicFilterId, SettableFuture<?>> lazyDynamicFilters;
        private final Set<DynamicFilterId> replicatedDynamicFilters;
        private final AtomicBoolean completed = new AtomicBoolean();

        private DynamicFilterContext(Supplier<List<StageDynamicFilters>> dynamicFilterSupplier, Set<DynamicFilterId> dynamicFilters, Map<DynamicFilterId, SettableFuture<?>> lazyDynamicFilters, Set<DynamicFilterId> replicatedDynamicFilters) {
            this.dynamicFilterSupplier = Objects.requireNonNull(dynamicFilterSupplier, "dynamicFilterSupplier is null");
            this.dynamicFilters = Objects.requireNonNull(dynamicFilters, "dynamicFilters is null");
            this.lazyDynamicFilters = Objects.requireNonNull(lazyDynamicFilters, "lazyDynamicFilters is null");
            this.replicatedDynamicFilters = Objects.requireNonNull(replicatedDynamicFilters, "replicatedDynamicFilters is null");
        }

        private int getTotalDynamicFilters() {
            return this.dynamicFilters.size();
        }

        private Set<DynamicFilterId> getUncollectedDynamicFilters() {
            return (Set)this.dynamicFilters.stream().filter(filter -> !this.dynamicFilterSummaries.containsKey(filter)).collect(ImmutableSet.toImmutableSet());
        }

        private void addDynamicFilters(Map<DynamicFilterId, Domain> newDynamicFilters) {
            newDynamicFilters.forEach((filter, domain) -> {
                this.dynamicFilterSummaries.put((DynamicFilterId)filter, (Domain)domain);
                Optional.ofNullable(this.lazyDynamicFilters.get(filter)).ifPresent(future -> future.set(null));
            });
            this.completed.set(this.dynamicFilters.stream().allMatch(this.dynamicFilterSummaries::containsKey));
        }

        private Map<DynamicFilterId, Domain> getDynamicFilterSummaries() {
            return this.dynamicFilterSummaries;
        }

        private Supplier<List<StageDynamicFilters>> getDynamicFilterSupplier() {
            return this.dynamicFilterSupplier;
        }

        private Map<DynamicFilterId, SettableFuture<?>> getLazyDynamicFilters() {
            return this.lazyDynamicFilters;
        }

        private Set<DynamicFilterId> getReplicatedDynamicFilters() {
            return this.replicatedDynamicFilters;
        }

        private boolean isCompleted() {
            return this.completed.get();
        }
    }

    public static class DynamicFilterDomainStats {
        private final DynamicFilterId dynamicFilterId;
        private final String simplifiedDomain;
        private final int rangeCount;
        private final int discreteValuesCount;

        @JsonCreator
        public DynamicFilterDomainStats(@JsonProperty(value="dynamicFilterId") DynamicFilterId dynamicFilterId, @JsonProperty(value="simplifiedDomain") String simplifiedDomain, @JsonProperty(value="rangeCount") int rangeCount, @JsonProperty(value="discreteValuesCount") int discreteValuesCount) {
            this.dynamicFilterId = dynamicFilterId;
            this.simplifiedDomain = simplifiedDomain;
            this.rangeCount = rangeCount;
            this.discreteValuesCount = discreteValuesCount;
        }

        @JsonProperty
        public DynamicFilterId getDynamicFilterId() {
            return this.dynamicFilterId;
        }

        @JsonProperty
        public String getSimplifiedDomain() {
            return this.simplifiedDomain;
        }

        @JsonProperty
        public int getRangeCount() {
            return this.rangeCount;
        }

        @JsonProperty
        public int getDiscreteValuesCount() {
            return this.discreteValuesCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicFilterDomainStats that = (DynamicFilterDomainStats)o;
            return this.rangeCount == that.rangeCount && this.discreteValuesCount == that.discreteValuesCount && Objects.equals(this.dynamicFilterId, that.dynamicFilterId) && Objects.equals(this.simplifiedDomain, that.simplifiedDomain);
        }

        public int hashCode() {
            return Objects.hash(this.dynamicFilterId, this.simplifiedDomain, this.rangeCount, this.discreteValuesCount);
        }
    }

    public static class DynamicFiltersStats {
        public static final DynamicFiltersStats EMPTY = new DynamicFiltersStats((List<DynamicFilterDomainStats>)ImmutableList.of(), 0, 0, 0, 0);
        private final List<DynamicFilterDomainStats> dynamicFilterDomainStats;
        private final int lazyDynamicFilters;
        private final int replicatedDynamicFilters;
        private final int totalDynamicFilters;
        private final int dynamicFiltersCompleted;

        @JsonCreator
        public DynamicFiltersStats(@JsonProperty(value="dynamicFilterDomainStats") List<DynamicFilterDomainStats> dynamicFilterDomainStats, @JsonProperty(value="lazyDynamicFilters") int lazyDynamicFilters, @JsonProperty(value="replicatedDynamicFilters") int replicatedDynamicFilters, @JsonProperty(value="totalDynamicFilters") int totalDynamicFilters, @JsonProperty(value="dynamicFiltersCompleted") int dynamicFiltersCompleted) {
            this.dynamicFilterDomainStats = dynamicFilterDomainStats;
            this.lazyDynamicFilters = lazyDynamicFilters;
            this.replicatedDynamicFilters = replicatedDynamicFilters;
            this.totalDynamicFilters = totalDynamicFilters;
            this.dynamicFiltersCompleted = dynamicFiltersCompleted;
        }

        @JsonProperty
        public List<DynamicFilterDomainStats> getDynamicFilterDomainStats() {
            return this.dynamicFilterDomainStats;
        }

        @JsonProperty
        public int getLazyDynamicFilters() {
            return this.lazyDynamicFilters;
        }

        @JsonProperty
        public int getReplicatedDynamicFilters() {
            return this.replicatedDynamicFilters;
        }

        @JsonProperty
        public int getTotalDynamicFilters() {
            return this.totalDynamicFilters;
        }

        @JsonProperty
        public int getDynamicFiltersCompleted() {
            return this.dynamicFiltersCompleted;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicFiltersStats that = (DynamicFiltersStats)o;
            return this.lazyDynamicFilters == that.lazyDynamicFilters && this.replicatedDynamicFilters == that.replicatedDynamicFilters && this.totalDynamicFilters == that.totalDynamicFilters && this.dynamicFiltersCompleted == that.dynamicFiltersCompleted && Objects.equals(this.dynamicFilterDomainStats, that.dynamicFilterDomainStats);
        }

        public int hashCode() {
            return Objects.hash(this.dynamicFilterDomainStats, this.lazyDynamicFilters, this.replicatedDynamicFilters, this.totalDynamicFilters, this.dynamicFiltersCompleted);
        }
    }

    public static class StageDynamicFilters {
        private final StageState stageState;
        private final int numberOfTasks;
        private final List<Map<DynamicFilterId, Domain>> taskDynamicFilters;

        public StageDynamicFilters(StageState stageState, int numberOfTasks, List<Map<DynamicFilterId, Domain>> taskDynamicFilters) {
            this.stageState = Objects.requireNonNull(stageState, "stageState is null");
            this.numberOfTasks = numberOfTasks;
            this.taskDynamicFilters = ImmutableList.copyOf((Collection)Objects.requireNonNull(taskDynamicFilters, "taskDynamicFilters is null"));
        }

        private StageState getStageState() {
            return this.stageState;
        }

        private int getNumberOfTasks() {
            return this.numberOfTasks;
        }

        private List<Map<DynamicFilterId, Domain>> getTaskDynamicFilters() {
            return this.taskDynamicFilters;
        }
    }
}

