/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.base.Preconditions;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import io.prestosql.client.NodeVersion;
import io.prestosql.client.ServerInfo;
import io.prestosql.metadata.NodeState;
import io.prestosql.server.GracefulShutdownHandler;
import io.prestosql.server.ServerConfig;
import io.prestosql.server.security.ResourceSecurity;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

@Path(value="/v1/info")
public class ServerInfoResource {
    private final NodeVersion version;
    private final String environment;
    private final boolean coordinator;
    private final GracefulShutdownHandler shutdownHandler;
    private final long startTime = System.nanoTime();
    private final AtomicBoolean startupComplete = new AtomicBoolean();

    @Inject
    public ServerInfoResource(NodeVersion nodeVersion, NodeInfo nodeInfo, ServerConfig serverConfig, GracefulShutdownHandler shutdownHandler) {
        this.version = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.environment = Objects.requireNonNull(nodeInfo, "nodeInfo is null").getEnvironment();
        this.coordinator = Objects.requireNonNull(serverConfig, "serverConfig is null").isCoordinator();
        this.shutdownHandler = Objects.requireNonNull(shutdownHandler, "shutdownHandler is null");
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Produces(value={"application/json"})
    public ServerInfo getInfo() {
        boolean starting = !this.startupComplete.get();
        return new ServerInfo(this.version, this.environment, this.coordinator, starting, Optional.of(Duration.nanosSince((long)this.startTime)));
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.MANAGEMENT_WRITE)
    @PUT
    @Path(value="state")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response updateState(NodeState state) throws WebApplicationException {
        Objects.requireNonNull(state, "state is null");
        switch (state) {
            case SHUTTING_DOWN: {
                this.shutdownHandler.requestShutdown();
                return Response.ok().build();
            }
            case ACTIVE: 
            case INACTIVE: {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)String.format("Invalid state transition to %s", new Object[]{state})).build());
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)String.format("Invalid state %s", new Object[]{state})).build();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Path(value="state")
    @Produces(value={"application/json"})
    public NodeState getServerState() {
        if (this.shutdownHandler.isShutdownRequested()) {
            return NodeState.SHUTTING_DOWN;
        }
        return NodeState.ACTIVE;
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Path(value="coordinator")
    @Produces(value={"text/plain"})
    public Response getServerCoordinator() {
        if (this.coordinator) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    public void startupComplete() {
        Preconditions.checkState((boolean)this.startupComplete.compareAndSet(false, true), (Object)"Server startup already marked as complete");
    }
}

