/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.MapBinder;
import io.prestosql.server.security.ResourceAccessType;
import io.prestosql.server.security.ResourceAccessTypeLoader;
import io.prestosql.server.security.ResourceSecurity;
import java.lang.reflect.AnnotatedElement;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class ResourceSecurityBinder {
    private final MapBinder<AnnotatedElement, ResourceSecurity.AccessType> accessTypeBinder;

    public static ResourceSecurityBinder resourceSecurityBinder(Binder binder) {
        return new ResourceSecurityBinder(binder);
    }

    private ResourceSecurityBinder(Binder binder) {
        Objects.requireNonNull(binder, "binder is null");
        binder.bind(ResourceAccessType.class).in(Scopes.SINGLETON);
        binder.bind(StaticResourceAccessTypeLoader.class).in(Scopes.SINGLETON);
        this.accessTypeBinder = MapBinder.newMapBinder((Binder)binder, AnnotatedElement.class, ResourceSecurity.AccessType.class);
    }

    public ResourceSecurityBinder resourceSecurity(AnnotatedElement element, ResourceSecurity.AccessType accessType) {
        this.accessTypeBinder.addBinding((Object)element).toInstance((Object)accessType);
        return this;
    }

    public ResourceSecurityBinder publicResource(AnnotatedElement element) {
        return this.resourceSecurity(element, ResourceSecurity.AccessType.PUBLIC);
    }

    public ResourceSecurityBinder anyUserResource(AnnotatedElement element) {
        return this.resourceSecurity(element, ResourceSecurity.AccessType.AUTHENTICATED_USER);
    }

    public ResourceSecurityBinder managementReadResource(AnnotatedElement element) {
        return this.resourceSecurity(element, ResourceSecurity.AccessType.MANAGEMENT_READ);
    }

    public ResourceSecurityBinder managementWriteResource(AnnotatedElement element) {
        return this.resourceSecurity(element, ResourceSecurity.AccessType.MANAGEMENT_WRITE);
    }

    public ResourceSecurityBinder internalOnlyResource(AnnotatedElement element) {
        return this.resourceSecurity(element, ResourceSecurity.AccessType.INTERNAL_ONLY);
    }

    public static class StaticResourceAccessTypeLoader
    implements ResourceAccessTypeLoader {
        private final Map<AnnotatedElement, ResourceSecurity.AccessType> accessTypeMap;

        @Inject
        public StaticResourceAccessTypeLoader(Map<AnnotatedElement, ResourceSecurity.AccessType> accessTypeMap) {
            this.accessTypeMap = ImmutableMap.copyOf(Objects.requireNonNull(accessTypeMap, "accessTypeMap is null"));
        }

        @Override
        public Optional<ResourceSecurity.AccessType> getAccessType(AnnotatedElement element) {
            return Optional.ofNullable(this.accessTypeMap.get(element));
        }
    }
}

