/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.ResolvedField;
import io.prestosql.sql.tree.ExistsPredicate;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.InPredicate;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.QuantifiedComparisonExpression;
import io.prestosql.sql.tree.SubqueryExpression;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ExpressionAnalysis {
    private final Map<NodeRef<Expression>, Type> expressionTypes;
    private final Map<NodeRef<Expression>, Type> expressionCoercions;
    private final Set<NodeRef<Expression>> typeOnlyCoercions;
    private final Map<NodeRef<Expression>, ResolvedField> columnReferences;
    private final Set<NodeRef<InPredicate>> subqueryInPredicates;
    private final Set<NodeRef<SubqueryExpression>> scalarSubqueries;
    private final Set<NodeRef<ExistsPredicate>> existsSubqueries;
    private final Set<NodeRef<QuantifiedComparisonExpression>> quantifiedComparisons;
    private final Set<NodeRef<FunctionCall>> windowFunctions;

    public ExpressionAnalysis(Map<NodeRef<Expression>, Type> expressionTypes, Map<NodeRef<Expression>, Type> expressionCoercions, Set<NodeRef<InPredicate>> subqueryInPredicates, Set<NodeRef<SubqueryExpression>> scalarSubqueries, Set<NodeRef<ExistsPredicate>> existsSubqueries, Map<NodeRef<Expression>, ResolvedField> columnReferences, Set<NodeRef<Expression>> typeOnlyCoercions, Set<NodeRef<QuantifiedComparisonExpression>> quantifiedComparisons, Set<NodeRef<FunctionCall>> windowFunctions) {
        this.expressionTypes = ImmutableMap.copyOf(Objects.requireNonNull(expressionTypes, "expressionTypes is null"));
        this.expressionCoercions = ImmutableMap.copyOf(Objects.requireNonNull(expressionCoercions, "expressionCoercions is null"));
        this.typeOnlyCoercions = ImmutableSet.copyOf((Collection)Objects.requireNonNull(typeOnlyCoercions, "typeOnlyCoercions is null"));
        this.columnReferences = ImmutableMap.copyOf(Objects.requireNonNull(columnReferences, "columnReferences is null"));
        this.subqueryInPredicates = ImmutableSet.copyOf((Collection)Objects.requireNonNull(subqueryInPredicates, "subqueryInPredicates is null"));
        this.scalarSubqueries = ImmutableSet.copyOf((Collection)Objects.requireNonNull(scalarSubqueries, "subqueryInPredicates is null"));
        this.existsSubqueries = ImmutableSet.copyOf((Collection)Objects.requireNonNull(existsSubqueries, "existsSubqueries is null"));
        this.quantifiedComparisons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(quantifiedComparisons, "quantifiedComparisons is null"));
        this.windowFunctions = ImmutableSet.copyOf((Collection)Objects.requireNonNull(windowFunctions, "windowFunctions is null"));
    }

    public Type getType(Expression expression) {
        return this.expressionTypes.get(NodeRef.of((Node)expression));
    }

    public Map<NodeRef<Expression>, Type> getExpressionTypes() {
        return this.expressionTypes;
    }

    public Type getCoercion(Expression expression) {
        return this.expressionCoercions.get(NodeRef.of((Node)expression));
    }

    public boolean isTypeOnlyCoercion(Expression expression) {
        return this.typeOnlyCoercions.contains(NodeRef.of((Node)expression));
    }

    public boolean isColumnReference(Expression node) {
        return this.columnReferences.containsKey(NodeRef.of((Node)node));
    }

    public Set<NodeRef<InPredicate>> getSubqueryInPredicates() {
        return this.subqueryInPredicates;
    }

    public Set<NodeRef<SubqueryExpression>> getScalarSubqueries() {
        return this.scalarSubqueries;
    }

    public Set<NodeRef<ExistsPredicate>> getExistsSubqueries() {
        return this.existsSubqueries;
    }

    public Set<NodeRef<QuantifiedComparisonExpression>> getQuantifiedComparisons() {
        return this.quantifiedComparisons;
    }

    public Set<NodeRef<FunctionCall>> getWindowFunctions() {
        return this.windowFunctions;
    }
}

