/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.DynamicFilter;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.sql.DynamicFilters;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class LocalDynamicFiltersCollector {
    private final Map<DynamicFilterId, SettableFuture<Domain>> futures = new HashMap<DynamicFilterId, SettableFuture<Domain>>();

    public void register(Set<DynamicFilterId> filterIds) {
        filterIds.forEach(filterId -> Verify.verify((this.futures.put((DynamicFilterId)filterId, (SettableFuture<Domain>)SettableFuture.create()) == null ? 1 : 0) != 0, (String)"LocalDynamicFiltersCollector: duplicate filter %s", (Object)filterId));
    }

    public void collectDynamicFilterDomains(Map<DynamicFilterId, Domain> dynamicFilterDomains) {
        dynamicFilterDomains.entrySet().forEach(entry -> {
            SettableFuture<Domain> future = this.futures.get(entry.getKey());
            if (future != null) {
                Verify.verify((boolean)future.set((Object)((Domain)entry.getValue())), (String)"Dynamic filter %s already collected", entry.getKey());
            }
        });
    }

    public DynamicFilter createDynamicFilter(List<DynamicFilters.Descriptor> descriptors, Map<Symbol, ColumnHandle> columnsMap) {
        Multimap symbolsMap = (Multimap)descriptors.stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(DynamicFilters.Descriptor::getId, descriptor -> Symbol.from(descriptor.getInput())));
        List predicateFutures = (List)symbolsMap.keySet().stream().filter(this.futures.keySet()::contains).map(filterId -> {
            List probeColumns = (List)symbolsMap.get(filterId).stream().map(probeSymbol -> Objects.requireNonNull((ColumnHandle)columnsMap.get(probeSymbol), () -> String.format("Missing probe column for %s", probeSymbol))).collect(ImmutableList.toImmutableList());
            return Futures.transform((ListenableFuture)((ListenableFuture)Objects.requireNonNull(this.futures.get(filterId), () -> String.format("Missing dynamic filter %s", filterId))), domain -> TupleDomain.withColumnDomains((Map)((Map)probeColumns.stream().collect(ImmutableMap.toImmutableMap(column -> column, column -> domain)))), (Executor)MoreExecutors.directExecutor());
        }).collect(ImmutableList.toImmutableList());
        return new TableSpecificDynamicFilter(predicateFutures);
    }

    private static class TableSpecificDynamicFilter
    implements DynamicFilter {
        @GuardedBy(value="this")
        private CompletableFuture<?> isBlocked;
        @GuardedBy(value="this")
        private TupleDomain<ColumnHandle> currentPredicate;
        @GuardedBy(value="this")
        private int futuresLeft;

        private TableSpecificDynamicFilter(List<ListenableFuture<TupleDomain<ColumnHandle>>> predicateFutures) {
            this.futuresLeft = predicateFutures.size();
            this.isBlocked = predicateFutures.isEmpty() ? NOT_BLOCKED : new CompletableFuture();
            this.currentPredicate = TupleDomain.all();
            predicateFutures.stream().forEach(future -> MoreFutures.addSuccessCallback((ListenableFuture)future, this::update, (Executor)MoreExecutors.directExecutor()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(TupleDomain<ColumnHandle> predicate) {
            CompletableFuture<?> currentFuture;
            TableSpecificDynamicFilter tableSpecificDynamicFilter = this;
            synchronized (tableSpecificDynamicFilter) {
                --this.futuresLeft;
                Verify.verify((this.futuresLeft >= 0 ? 1 : 0) != 0);
                this.currentPredicate = this.currentPredicate.intersect(predicate);
                currentFuture = this.isBlocked;
                this.isBlocked = this.isComplete() ? NOT_BLOCKED : new CompletableFuture();
            }
            Verify.verify((boolean)currentFuture.complete(null));
        }

        public synchronized CompletableFuture<?> isBlocked() {
            return MoreFutures.unmodifiableFuture(this.isBlocked);
        }

        public synchronized boolean isComplete() {
            return this.futuresLeft == 0;
        }

        public synchronized boolean isAwaitable() {
            return this.futuresLeft > 0;
        }

        public synchronized TupleDomain<ColumnHandle> getCurrentPredicate() {
            return this.currentPredicate;
        }
    }
}

